/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.LldpUtils;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkdTopologyProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.opennms.netmgt.model.topology.CdpTopologyLink;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;
import org.opennms.netmgt.model.topology.IsisTopologyLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class EnhancedLinkdTopologyProvider
extends AbstractLinkdTopologyProvider {
    private static Logger LOG = LoggerFactory.getLogger(EnhancedLinkdTopologyProvider.class);
    static final String[] OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;
    private OspfLinkDao m_ospfLinkDao;
    private IsIsLinkDao m_isisLinkDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private CdpLinkDao m_cdpLinkDao;
    public static final String LLDP_EDGE_NAMESPACE = "nodes::LLDP";
    public static final String OSPF_EDGE_NAMESPACE = "nodes::OSPF";
    public static final String ISIS_EDGE_NAMESPACE = "nodes::ISIS";
    public static final String BRIDGE_EDGE_NAMESPACE = "nodes::BRIDGE";
    public static final String CDP_EDGE_NAMESPACE = "nodes::CDP";

    public void onInit() throws MalformedURLException, JAXBException {
        block3: {
            LOG.debug("init: loading enlinkd topology.");
            try {
                this.getTransactionOperations().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    public void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            EnhancedLinkdTopologyProvider.this.load(null);
                        }
                        catch (MalformedURLException | JAXBException e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    }
                });
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getUndeclaredThrowable();
                if (t instanceof MalformedURLException) {
                    throw (MalformedURLException)t;
                }
                if (!(t instanceof JAXBException)) break block3;
                throw (JAXBException)t;
            }
        }
    }

    @Override
    @Transactional
    public void load(String filename) throws MalformedURLException, JAXBException {
        File configFile;
        if (filename != null) {
            LOG.warn("Filename that was specified for linkd topology will be ignored: " + filename + ", using " + this.getConfigurationFile() + " instead");
        }
        try {
            this.resetContainer();
        }
        catch (Exception e) {
            LOG.error("Exception reset Container: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getLldpLinks();
        }
        catch (Exception e) {
            LOG.error("Exception getting Lldp link: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getOspfLinks();
        }
        catch (Exception e) {
            LOG.error("Exception getting Ospf link: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getIsIsLinks();
        }
        catch (Exception e) {
            LOG.error("Exception getting IsIs link: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getBridgeLinks();
        }
        catch (Exception e) {
            LOG.error("Exception getting Bridge link: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getCdpLinks();
        }
        catch (Exception e) {
            LOG.error("Exception getting Cdp link: " + e.getMessage(), (Throwable)e);
        }
        LOG.debug("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
        if (this.isAddNodeWithoutLink()) {
            this.addNodesWithoutLinks();
        }
        if ((configFile = new File(this.getConfigurationFile())).exists() && configFile.canRead()) {
            LOG.debug("loadtopology: loading topology from configuration file: " + this.getConfigurationFile());
            WrappedGraph graph = EnhancedLinkdTopologyProvider.getGraphFromFile(configFile);
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (!eachVertexInFile.group) continue;
                LOG.debug("loadtopology: adding group to topology: " + eachVertexInFile.id);
                if (eachVertexInFile.namespace == null) {
                    eachVertexInFile.namespace = this.getVertexNamespace();
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)eachVertexInFile);
                }
                if (eachVertexInFile.id == null) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)this.getConfigurationFile(), (Object)eachVertexInFile);
                }
                AbstractVertex newGroupVertex = this.addGroup(eachVertexInFile.id, eachVertexInFile.iconKey, eachVertexInFile.label);
                newGroupVertex.setIpAddress(eachVertexInFile.ipAddr);
                newGroupVertex.setLocked(eachVertexInFile.locked);
                if (eachVertexInFile.nodeID != null) {
                    newGroupVertex.setNodeID(eachVertexInFile.nodeID);
                }
                if (!newGroupVertex.equals((Object)eachVertexInFile.parent)) {
                    newGroupVertex.setParent((VertexRef)eachVertexInFile.parent);
                }
                newGroupVertex.setSelected(eachVertexInFile.selected);
                newGroupVertex.setStyleName(eachVertexInFile.styleName);
                newGroupVertex.setTooltipText(eachVertexInFile.tooltipText);
                if (eachVertexInFile.x != null) {
                    newGroupVertex.setX(eachVertexInFile.x);
                }
                if (eachVertexInFile.y == null) continue;
                newGroupVertex.setY(eachVertexInFile.y);
            }
            for (Vertex vertex : this.getVertices(new org.opennms.features.topology.api.topo.Criteria[0])) {
                if (vertex.getParent() == null || vertex.equals(vertex.getParent())) continue;
                LOG.debug("loadtopology: setting parent of " + vertex + " to " + vertex.getParent());
                this.setParent((VertexRef)vertex, vertex.getParent());
            }
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (eachVertexInFile.group || eachVertexInFile.parent == null) continue;
                Vertex child = this.getVertex((VertexRef)eachVertexInFile, new org.opennms.features.topology.api.topo.Criteria[0]);
                Vertex parent = this.getVertex((VertexRef)eachVertexInFile.parent, new org.opennms.features.topology.api.topo.Criteria[0]);
                if (child == null || parent == null) continue;
                LOG.debug("loadtopology: setting parent of " + child + " to " + parent);
                if (child.equals(parent)) continue;
                this.setParent((VertexRef)child, (VertexRef)parent);
            }
        } else {
            LOG.debug("loadtopology: could not load topology configFile:" + this.getConfigurationFile());
        }
        LOG.debug("Found " + this.getGroups().size() + " groups");
        LOG.debug("Found " + this.getVerticesWithoutGroups().size() + " vertices");
        LOG.debug("Found " + this.getEdges(new org.opennms.features.topology.api.topo.Criteria[0]).size() + " edges");
    }

    private void getOspfLinks() {
        List allLinks = this.getOspfLinkDao().findAll();
        HashSet<OspfLinkDetail> combinedLinkDetails = new HashSet<OspfLinkDetail>();
        for (OspfLink sourceLink : allLinks) {
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceLink.getNode().getNodeId());
            if (source == null) {
                source = this.getDefaultVertex(sourceLink.getNode().getId(), sourceLink.getNode().getSysObjectId(), sourceLink.getNode().getLabel(), sourceLink.getNode().getSysLocation(), sourceLink.getNode().getType());
                this.addVertices(new Vertex[]{source});
            }
            for (OspfLink targetLink : allLinks) {
                if (!sourceLink.getOspfRemIpAddr().equals(targetLink.getOspfIpAddr()) || !targetLink.getOspfRemIpAddr().equals(sourceLink.getOspfIpAddr())) continue;
                Vertex target = this.getVertex(this.getVertexNamespace(), targetLink.getNode().getNodeId());
                if (target == null) {
                    target = this.getDefaultVertex(targetLink.getNode().getId(), targetLink.getNode().getSysObjectId(), targetLink.getNode().getLabel(), targetLink.getNode().getSysLocation(), targetLink.getNode().getType());
                    this.addVertices(new Vertex[]{target});
                }
                OspfLinkDetail linkDetail = new OspfLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink);
                combinedLinkDetails.add(linkDetail);
            }
        }
        for (OspfLinkDetail linkDetail : combinedLinkDetails) {
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), OSPF_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getLldpLinks() {
        List allLinks = this.m_lldpLinkDao.findAll();
        HashSet<LldpLinkDetail> combinedLinkDetails = new HashSet<LldpLinkDetail>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLink sourceLink : allLinks) {
            Criteria criteria;
            List nodes;
            LOG.debug("loadtopology: parsing lldp link with id '{}' link '{}' ", (Object)sourceLink.getId(), (Object)sourceLink);
            if (parsed.contains(sourceLink.getId())) {
                LOG.debug("loadtopology: lldp link with id '{]' already parsed, skipping", (Object)sourceLink.getId());
                continue;
            }
            parsed.add(sourceLink.getId());
            OnmsNode sourceNode = sourceLink.getNode();
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceNode.getNodeId());
            if (source == null) {
                source = this.getDefaultVertex(sourceNode.getId(), sourceNode.getSysObjectId(), sourceNode.getLabel(), sourceNode.getSysLocation(), sourceNode.getType());
                this.addVertices(new Vertex[]{source});
            }
            LldpElement sourceElement = sourceNode.getLldpElement();
            LldpLink targetLink = null;
            for (LldpLink link : allLinks) {
                boolean bool3;
                LOG.debug("loadtopology: parsing lldp link with id '{}' link '{}' ", (Object)link.getId(), (Object)link);
                if (parsed.contains(link.getId())) {
                    LOG.debug("loadtopology: lldp link with id '{]' already parsed, skipping", (Object)link.getId());
                    continue;
                }
                LldpElement element = link.getNode().getLldpElement();
                if (!sourceLink.getLldpRemChassisId().equals(element.getLldpChassisId()) || !link.getLldpRemChassisId().equals(sourceElement.getLldpChassisId())) continue;
                boolean bool1 = sourceLink.getLldpRemPortId().equals(link.getLldpPortId()) && link.getLldpRemPortId().equals(sourceLink.getLldpPortId());
                boolean bool2 = sourceLink.getLldpRemPortDescr().equals(link.getLldpPortDescr()) && link.getLldpRemPortDescr().equals(sourceLink.getLldpPortDescr());
                boolean bl = bool3 = sourceLink.getLldpRemPortIdSubType() == link.getLldpPortIdSubType() && link.getLldpRemPortIdSubType() == sourceLink.getLldpPortIdSubType();
                if (!bool1 || !bool2 || !bool3) continue;
                targetLink = link;
                parsed.add(targetLink.getId());
                LOG.debug("loadtopology: found lldp mutual link: '{}' and '{}' ", (Object)sourceLink, (Object)targetLink);
                break;
            }
            if (targetLink == null && (nodes = this.m_nodeDao.findMatching(criteria = new Criteria(OnmsNode.class).addRestriction((Restriction)new EqRestriction("sysName", (Object)sourceLink.getLldpRemSysname())))).size() == 1) {
                targetLink = this.reverseLldpLink((OnmsNode)nodes.get(0), sourceLink.getNode().getLldpElement(), sourceLink);
                LOG.debug("loadtopology: found lldp link using lldp rem sysname: '{}' and '{}'", (Object)sourceLink, (Object)targetLink);
            }
            if (targetLink == null) {
                LOG.debug("loadtopology: cannot found target node for link: '{}'", (Object)sourceLink);
                continue;
            }
            OnmsNode targetNode = targetLink.getNode();
            Vertex target = this.getVertex(this.getVertexNamespace(), targetNode.getNodeId());
            if (target == null) {
                target = this.getDefaultVertex(targetNode.getId(), targetNode.getSysObjectId(), targetNode.getLabel(), targetNode.getSysLocation(), targetNode.getType());
                this.addVertices(new Vertex[]{target});
            }
            combinedLinkDetails.add(new LldpLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink));
        }
        for (LldpLinkDetail linkDetail : combinedLinkDetails) {
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), LLDP_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getCdpLinks() {
        List cdpLinks = this.m_cdpLinkDao.findLinksForTopology();
        if (cdpLinks != null && cdpLinks.size() > 0) {
            for (CdpTopologyLink link : cdpLinks) {
                Vertex target;
                LOG.debug("loadtopology: adding cdp link: '{}'", (Object)link);
                String id = Math.min(link.getSourceId(), link.getTargetId()) + "|" + Math.max(link.getSourceId(), link.getTargetId());
                Vertex source = this.getVertex(this.getVertexNamespace(), link.getSrcNodeId().toString());
                if (source == null) {
                    source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType());
                    this.addVertices(new Vertex[]{source});
                }
                if ((target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString())) == null) {
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                    this.addVertices(new Vertex[]{target});
                }
                CdpLinkDetail linkDetail = new CdpLinkDetail(id, source, link.getSrcIfIndex(), link.getSrcIfName(), target, link.getTargetIfName());
                AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), CDP_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
            }
        }
    }

    private void getIsIsLinks() {
        List isislinks = this.m_isisLinkDao.getLinksForTopology();
        if (isislinks != null && isislinks.size() > 0) {
            for (IsisTopologyLink link : isislinks) {
                Vertex target;
                LOG.debug("loadtopology: adding isis link: '{}'", (Object)link);
                String id = Math.min(link.getSourceId(), link.getTargetId()) + "|" + Math.max(link.getSourceId(), link.getTargetId());
                Vertex source = this.getVertex(this.getVertexNamespace(), link.getSrcNodeId().toString());
                if (source == null) {
                    source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType());
                    this.addVertices(new Vertex[]{source});
                }
                if ((target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString())) == null) {
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                    this.addVertices(new Vertex[]{target});
                }
                IsIsLinkDetail linkDetail = new IsIsLinkDetail(id, source, link.getSourceId(), link.getSrcIfIndex(), target, link.getTargetId(), link.getTargetIfIndex());
                AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), ISIS_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
            }
        }
    }

    private void getBridgeLinks() {
        AbstractEdge edge2;
        Vertex cloudVertex;
        Vertex cloudVertex2;
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findAll()) {
            Vertex target;
            Vertex source = this.getVertex(this.getVertexNamespace(), link.getNode().getId().toString());
            if (source == null) {
                source = this.getDefaultVertex(link.getNode().getId(), link.getNode().getSysObjectId(), link.getNode().getLabel(), link.getNode().getSysDescription(), link.getNode().getType());
                this.addVertices(new Vertex[]{source});
            }
            if ((target = this.getVertex(this.getVertexNamespace(), link.getDesignatedNode().getId().toString())) == null) {
                target = this.getDefaultVertex(link.getDesignatedNode().getId(), link.getDesignatedNode().getSysObjectId(), link.getDesignatedNode().getLabel(), link.getDesignatedNode().getSysDescription(), link.getDesignatedNode().getType());
                this.addVertices(new Vertex[]{target});
            }
            BridgeLinkDetail detail = new BridgeLinkDetail("nodes", source, link.getBridgePortIfIndex(), target, link.getDesignatedPortIfIndex(), link.getBridgePort(), link.getDesignatedPort(), link.getId(), link.getId());
            AbstractEdge edge = this.connectVertices(detail.getId(), (VertexRef)detail.getSource(), (VertexRef)detail.getTarget(), BRIDGE_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(detail));
        }
        HashMap mactocloud = new HashMap();
        int cloudindex = 0;
        for (BridgeMacTopologyLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes()) {
            AbstractEdge edge;
            Vertex target;
            String sourceLinkId = link.getSrcNodeId() + ":" + link.getBridgePort();
            String targetLinkId = link.getTargetNodeId() + ":" + link.getTargetBridgePort();
            if (link.getBridgePortIfIndex() != null) {
                sourceLinkId = link.getSrcNodeId() + ":" + link.getBridgePortIfIndex();
            }
            if (link.getTargetIfIndex() != null) {
                targetLinkId = link.getTargetNodeId() + ":" + link.getTargetIfIndex();
            }
            if (mactocloud.containsKey(sourceLinkId) && mactocloud.containsKey(targetLinkId)) {
                mactocloud.put(link.getMacAddr(), mactocloud.get(sourceLinkId));
                continue;
            }
            if (mactocloud.containsKey(sourceLinkId) && !mactocloud.containsKey(targetLinkId)) {
                cloudVertex2 = this.getVertex(this.getVertexNamespace(), (String)mactocloud.get(sourceLinkId));
                target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString());
                if (target == null) {
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                    this.addVertices(new Vertex[]{target});
                }
                edge = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getTargetId(), (int)link.getTargetId()), (VertexRef)cloudVertex2, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex2.getTooltipText()));
                mactocloud.put(link.getMacAddr(), mactocloud.get(sourceLinkId));
                mactocloud.put(targetLinkId, mactocloud.get(sourceLinkId));
                continue;
            }
            if (!mactocloud.containsKey(sourceLinkId) && mactocloud.containsKey(targetLinkId)) {
                cloudVertex2 = this.getVertex(this.getVertexNamespace(), (String)mactocloud.get(targetLinkId));
                Vertex source = this.getVertex(this.getVertexNamespace(), link.getSrcNodeId().toString());
                if (source == null) {
                    source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType());
                    this.addVertices(new Vertex[]{source});
                }
                edge = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId()), (VertexRef)cloudVertex2, (VertexRef)source, BRIDGE_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeVertexCloudToolTipTextFromSource(source, link, cloudVertex2.getTooltipText()));
                mactocloud.put(link.getMacAddr(), mactocloud.get(targetLinkId));
                mactocloud.put(sourceLinkId, mactocloud.get(targetLinkId));
                continue;
            }
            Vertex source = this.getVertex(this.getVertexNamespace(), link.getSrcNodeId().toString());
            if (source == null) {
                source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType());
                this.addVertices(new Vertex[]{source});
            }
            if ((target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString())) == null) {
                target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                this.addVertices(new Vertex[]{target});
            }
            if (mactocloud.containsKey(link.getMacAddr())) {
                Vertex cloudVertex3 = this.getVertex(this.getVertexNamespace(), (String)mactocloud.get(link.getMacAddr()));
                AbstractEdge edge1 = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId()), (VertexRef)cloudVertex3, (VertexRef)source, BRIDGE_EDGE_NAMESPACE);
                edge1.setTooltipText(this.getEdgeVertexCloudToolTipTextFromSource(source, link, cloudVertex3.getTooltipText()));
                AbstractEdge edge22 = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getTargetId(), (int)link.getTargetId()), (VertexRef)cloudVertex3, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                edge22.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex3.getTooltipText()));
                mactocloud.put(sourceLinkId, mactocloud.get(link.getMacAddr()));
                mactocloud.put(targetLinkId, mactocloud.get(link.getMacAddr()));
                continue;
            }
            String cloudId = "Cloud:" + cloudindex;
            cloudVertex = this.addVertex(cloudId, 0, 0);
            cloudVertex.setLabel("");
            cloudVertex.setIconKey("cloud");
            cloudVertex.setTooltipText("Cloud Representing a Shared Segment connecting switches");
            this.addVertices(new Vertex[]{cloudVertex});
            AbstractEdge edge1 = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId()), (VertexRef)cloudVertex, (VertexRef)source, BRIDGE_EDGE_NAMESPACE);
            edge1.setTooltipText(this.getEdgeVertexCloudToolTipTextFromSource(source, link, cloudVertex.getTooltipText()));
            edge2 = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getTargetId(), (int)link.getTargetId()), (VertexRef)cloudVertex, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
            edge2.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex.getTooltipText()));
            mactocloud.put(link.getMacAddr(), cloudId);
            mactocloud.put(sourceLinkId, cloudId);
            mactocloud.put(targetLinkId, cloudId);
            ++cloudindex;
        }
        HashMultimap multimap = HashMultimap.create();
        for (BridgeMacTopologyLink macLink : this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes()) {
            String sourceid = String.valueOf(macLink.getSrcNodeId()) + ":" + String.valueOf(macLink.getBridgePort());
            if (macLink.getBridgePortIfIndex() != null) {
                sourceid = String.valueOf(macLink.getSrcNodeId()) + ":" + String.valueOf(macLink.getBridgePortIfIndex());
            }
            multimap.put((Object)sourceid, (Object)macLink);
        }
        for (String key : multimap.keySet()) {
            Collection links = multimap.get((Object)key);
            if (links.size() == 1) {
                BridgeMacTopologyLink link = (BridgeMacTopologyLink)links.iterator().next();
                String edgeId = String.valueOf(link.getId()) + "|" + String.valueOf(link.getTargetId());
                Vertex target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString());
                if (target == null) {
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                    this.addVertices(new Vertex[]{target});
                }
                if (mactocloud.containsKey(link.getMacAddr())) {
                    cloudVertex = this.getVertex(this.getVertexNamespace(), (String)mactocloud.get(link.getMacAddr()));
                    AbstractEdge edge = this.connectVertices(edgeId, (VertexRef)cloudVertex, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                    edge.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex.getTooltipText()));
                    continue;
                }
                Vertex source = this.getVertex(this.getVertexNamespace(), link.getSrcNodeId().toString());
                if (source == null) {
                    source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType());
                    this.addVertices(new Vertex[]{source});
                }
                BridgeLinkDetail detail = new BridgeLinkDetail(edgeId, "nodes", source, link.getBridgePortIfIndex(), target, link.getTargetIfIndex(), link.getBridgePort(), link.getTargetBridgePort(), link.getId(), link.getTargetId());
                AbstractEdge edge = this.connectVertices(detail.getId(), (VertexRef)detail.getSource(), (VertexRef)detail.getTarget(), BRIDGE_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeTooltipText(detail));
                continue;
            }
            if (mactocloud.containsKey(key)) {
                cloudVertex2 = this.getVertex(this.getVertexNamespace(), (String)mactocloud.get(mactocloud.get(key)));
                for (BridgeMacTopologyLink link : multimap.get((Object)key)) {
                    String edgeId = String.valueOf(link.getId()) + "|" + String.valueOf(link.getTargetId());
                    Vertex target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString());
                    if (target == null) {
                        target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                        this.addVertices(new Vertex[]{target});
                    }
                    edge2 = this.connectVertices(edgeId, (VertexRef)cloudVertex2, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                    edge2.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex2.getTooltipText()));
                }
                continue;
            }
            String[] keyParts = key.split(":");
            String sourceNodeId = keyParts[0];
            String bridgePort = keyParts[1];
            BridgeMacTopologyLink link1 = (BridgeMacTopologyLink)multimap.get((Object)key).iterator().next();
            Vertex parentVertex = this.getVertex(this.getVertexNamespace(), sourceNodeId);
            if (parentVertex == null) {
                parentVertex = this.getDefaultVertex(link1.getSrcNodeId(), link1.getSrcSysoid(), link1.getSrcLabel(), link1.getSrcLocation(), link1.getSrcNodeType());
                this.addVertices(new Vertex[]{parentVertex});
            }
            AbstractVertex cloudVertex4 = this.addVertex(key, 0, 0);
            cloudVertex4.setLabel("");
            cloudVertex4.setIconKey("cloud");
            cloudVertex4.setTooltipText("Cloud Representing the Shared Segment connecting to switch: " + parentVertex.getLabel() + " bridge port: " + bridgePort);
            AbstractEdge edge = this.connectVertices(EdgeAlarmStatusSummary.getDefaultEdgeId((int)link1.getId(), (int)link1.getId()), (VertexRef)cloudVertex4, (VertexRef)parentVertex, BRIDGE_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeVertexCloudToolTipTextFromSource(parentVertex, link1, cloudVertex4.getTooltipText()));
            for (BridgeMacTopologyLink link : multimap.get((Object)key)) {
                String edgeId = String.valueOf(link.getId()) + "|" + String.valueOf(link.getTargetId());
                Vertex target = this.getVertex(this.getVertexNamespace(), link.getTargetNodeId().toString());
                if (target == null) {
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType());
                    this.addVertices(new Vertex[]{target});
                }
                AbstractEdge edge23 = this.connectVertices(edgeId, (VertexRef)cloudVertex4, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                edge23.setTooltipText(this.getEdgeVertexCloudToolTipTextFromTarget(target, link, cloudVertex4.getTooltipText()));
            }
        }
    }

    public void refresh() {
        try {
            this.load(null);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getEdgeVertexCloudToolTipTextFromSource(Vertex vertex, BridgeMacTopologyLink link, String cloudText) {
        if (link.getBridgePortIfName() != null) {
            return this.getEdgeVertexCloudTooltipText(vertex, " port with ifname: " + link.getBridgePortIfName(), cloudText);
        }
        if (link.getBridgePortIfIndex() != null) {
            return this.getEdgeVertexCloudTooltipText(vertex, " port with ifindex: " + String.valueOf(link.getBridgePortIfIndex()), cloudText);
        }
        return this.getEdgeVertexCloudTooltipText(vertex, " bridge port : " + String.valueOf(link.getBridgePort()), cloudText);
    }

    private String getEdgeVertexCloudToolTipTextFromTarget(Vertex vertex, BridgeMacTopologyLink link, String cloudText) {
        if (link.getTargetBridgePort() != null && link.getTargetPortIfName() != null) {
            return this.getEdgeVertexCloudTooltipText(vertex, " port with ifname: " + link.getTargetPortIfName(), cloudText);
        }
        if (link.getTargetBridgePort() != null && link.getTargetIfIndex() != null) {
            return this.getEdgeVertexCloudTooltipText(vertex, " port with ifindex: " + String.valueOf(link.getTargetIfIndex()), cloudText);
        }
        if (link.getTargetBridgePort() != null) {
            return this.getEdgeVertexCloudTooltipText(vertex, " bridge port : " + String.valueOf(link.getTargetBridgePort()), cloudText);
        }
        return this.getEdgeVertexCloudTooltipText(vertex, " ip/mac : " + link.getBridgePortIfName() + "/" + link.getMacAddr(), cloudText);
    }

    private String getEdgeVertexCloudTooltipText(Vertex vertex, String vertexPortText, String cloudText) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append("<p>");
        tooltipText.append("Type of Link: Bridge Layer 2");
        tooltipText.append("<p>");
        tooltipText.append("<p>");
        tooltipText.append("Name: &lt;endpoint1 " + vertex.getLabel() + vertexPortText);
        tooltipText.append(" ---- endpoint2 A Shared Segment &gt;");
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 1: " + vertex.getLabel() + ", " + vertex.getIpAddress());
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 1: " + cloudText);
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    private String getEdgeTooltipText(LinkDetail<?> linkDetail) {
        StringBuffer tooltipText = new StringBuffer();
        Vertex source = linkDetail.getSource();
        Vertex target = linkDetail.getTarget();
        OnmsSnmpInterface sourceInterface = this.getByNodeIdAndIfIndex(linkDetail.getSourceIfIndex(), source);
        OnmsSnmpInterface targetInterface = this.getByNodeIdAndIfIndex(linkDetail.getTargetIfIndex(), target);
        tooltipText.append("<p>");
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append("Type of Link: " + linkDetail.getType() + " Layer3/Layer2");
        } else {
            tooltipText.append("Type of Link: " + linkDetail.getType() + " Layer2");
        }
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("Name: &lt;endpoint1 " + source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append(":" + sourceInterface.getIfName());
        }
        tooltipText.append(" ---- endpoint2 " + target.getLabel());
        if (targetInterface != null) {
            tooltipText.append(":" + targetInterface.getIfName());
        }
        tooltipText.append("&gt;");
        tooltipText.append("</p>");
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append("<p>");
                tooltipText.append("Bandwidth: " + EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append("</p>");
            }
        } else if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append("<p>");
            tooltipText.append("Bandwidth: " + EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append("</p>");
        }
        tooltipText.append("<p>");
        tooltipText.append("End Point 1: " + source.getLabel() + ", " + source.getIpAddress());
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 2: " + target.getLabel() + ", " + target.getIpAddress());
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    private OnmsSnmpInterface getByNodeIdAndIfIndex(Integer ifIndex, Vertex source) {
        if (source.getId() != null && StringUtils.isNumeric((String)source.getId()) && ifIndex != null) {
            return this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(source.getId())), ifIndex);
        }
        return null;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public String getSearchProviderNamespace() {
        return "nodes";
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List<Vertex> vertices = this.getFilteredVertices();
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        org.opennms.features.topology.api.topo.Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopGraphProvider.VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.VertexHopCriteria criterion = LinkdHopCriteriaFactory.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((org.opennms.features.topology.api.topo.Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        org.opennms.features.topology.api.topo.Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    private org.opennms.features.topology.api.topo.Criteria findCriterion(String resultId, GraphContainer container) {
        org.opennms.features.topology.api.topo.Criteria[] criteria;
        for (org.opennms.features.topology.api.topo.Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (criterion instanceof LinkdHopCriteria && (id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) {
                return criterion;
            }
            if (!(criterion instanceof VertexHopGraphProvider.FocusNodeHopCriteria) || !(id = ((VertexHopGraphProvider.FocusNodeHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    private void logCriteriaInContainer(GraphContainer container) {
        org.opennms.features.topology.api.topo.Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (org.opennms.features.topology.api.topo.Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }

    private LldpLink reverseLldpLink(OnmsNode sourcenode, LldpElement element, LldpLink link) {
        LldpLink reverseLink = new LldpLink();
        reverseLink.setId(Integer.valueOf(-link.getId().intValue()));
        reverseLink.setNode(sourcenode);
        reverseLink.setLldpLocalPortNum(Integer.valueOf(0));
        reverseLink.setLldpPortId(link.getLldpRemPortId());
        reverseLink.setLldpPortIdSubType(link.getLldpRemPortIdSubType());
        reverseLink.setLldpPortDescr(link.getLldpRemPortDescr());
        if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
            try {
                reverseLink.setLldpPortIfindex(Integer.getInteger(link.getLldpRemPortId()));
            }
            catch (Exception e) {
                LOG.debug("reverseLldpLink: cannot create ifindex from  LldpRemPortId '{}'", (Object)link.getLldpRemPortId());
            }
        }
        reverseLink.setLldpRemChassisId(element.getLldpChassisId());
        reverseLink.setLldpRemChassisIdSubType(element.getLldpChassisIdSubType());
        reverseLink.setLldpRemSysname(element.getLldpSysname());
        reverseLink.setLldpRemPortId(link.getLldpPortId());
        reverseLink.setLldpRemPortIdSubType(link.getLldpPortIdSubType());
        reverseLink.setLldpRemPortDescr(link.getLldpPortDescr());
        reverseLink.setLldpLinkCreateTime(link.getLldpLinkCreateTime());
        reverseLink.setLldpLinkLastPollTime(link.getLldpLinkLastPollTime());
        return reverseLink;
    }

    public class CdpLinkDetail
    extends LinkDetail<Integer> {
        private final Integer m_sourceIfIndex;
        private final String m_sourceIfName;
        private final String m_targetIfName;

        public CdpLinkDetail(String id, Vertex source, Integer sourceIfIndex, String sourceIfName, Vertex target, String targetIfName) {
            super(id, source, null, target, null);
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_sourceIfName = sourceIfName;
            this.m_targetIfName = targetIfName;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CdpLinkDetail) {
                CdpLinkDetail objDetail = (CdpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfIndex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return null;
        }

        @Override
        public String getType() {
            return "CDP";
        }

        public String getSourceIfName() {
            return this.m_sourceIfName;
        }

        public String getTargetIfName() {
            return this.m_targetIfName;
        }
    }

    public class BridgeLinkDetail
    extends LinkDetail<Integer> {
        private final String m_vertexNamespace;
        private final Integer m_sourceBridgePort;
        private final Integer m_targetBridgePort;
        private final Integer m_sourceIfIndex;
        private final Integer m_targetifIndex;

        public BridgeLinkDetail(String vertexNamespace, Vertex source, Integer sourceIfIndex, Vertex target, Integer targetIfIndex, Integer sourceBridgePort, Integer targetBridgePort, Integer sourceLink, Integer targetLink) {
            super(EdgeAlarmStatusSummary.getDefaultEdgeId((int)sourceLink, (int)targetLink), source, sourceLink, target, targetLink);
            this.m_vertexNamespace = vertexNamespace;
            this.m_sourceBridgePort = sourceBridgePort;
            this.m_targetBridgePort = targetBridgePort;
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_targetifIndex = targetIfIndex;
        }

        public BridgeLinkDetail(String id, String vertexNamespace, Vertex source, Integer sourceIfIndex, Vertex target, Integer targetIfIndex, Integer sourceBridgePort, Integer targetBridgePort, Integer sourceLink, Integer targetLink) {
            super(id, source, sourceLink, target, targetLink);
            this.m_vertexNamespace = vertexNamespace;
            this.m_sourceBridgePort = sourceBridgePort;
            this.m_targetBridgePort = targetBridgePort;
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_targetifIndex = targetIfIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (this.getVertexNamespace() == null ? 0 : this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BridgeLinkDetail) {
                BridgeLinkDetail objDetail = (BridgeLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        public Integer getSourceBridgePort() {
            return this.m_sourceBridgePort;
        }

        public Integer getTargetBridgePort() {
            return this.m_targetBridgePort;
        }

        @Override
        public String getType() {
            return "Bridge";
        }

        public String getVertexNamespace() {
            return this.m_vertexNamespace;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfIndex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return this.m_targetifIndex;
        }
    }

    private class IsIsLinkDetail
    extends LinkDetail<Integer> {
        private final int m_sourceIfindex;
        private final int m_targetIfindex;
        private final int m_sourceLinkId;
        private final int m_targetLinkId;

        public IsIsLinkDetail(String id, Vertex source, int sourceLinkId, Integer sourceIfIndex, Vertex target, int targetLinkId, Integer targetIfIndex) {
            super(id, source, null, target, null);
            this.m_sourceLinkId = sourceLinkId;
            this.m_targetLinkId = targetLinkId;
            this.m_sourceIfindex = sourceIfIndex;
            this.m_targetIfindex = targetIfIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.m_sourceLinkId) + (this.getTargetLink() == null ? 0 : this.m_targetLinkId);
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsIsLinkDetail) {
                IsIsLinkDetail objDetail = (IsIsLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfindex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return this.m_targetIfindex;
        }

        @Override
        public String getType() {
            return "IsIs";
        }
    }

    private class OspfLinkDetail
    extends LinkDetail<OspfLink> {
        public OspfLinkDetail(String id, Vertex source, OspfLink sourceLink, Vertex target, OspfLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((OspfLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((OspfLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OspfLinkDetail) {
                OspfLinkDetail objDetail = (OspfLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((OspfLink)this.getSourceLink()).getOspfIfIndex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((OspfLink)this.getTargetLink()).getOspfIfIndex();
        }

        @Override
        public String getType() {
            return "OSPF";
        }
    }

    private class LldpLinkDetail
    extends LinkDetail<LldpLink> {
        public LldpLinkDetail(String id, Vertex source, LldpLink sourceLink, Vertex target, LldpLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((LldpLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((LldpLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof LldpLinkDetail) {
                LldpLinkDetail objDetail = (LldpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((LldpLink)this.getSourceLink()).getLldpPortIfindex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((LldpLink)this.getTargetLink()).getLldpPortIfindex();
        }

        @Override
        public String getType() {
            return "LLDP";
        }
    }

    private abstract class LinkDetail<K> {
        private final String m_id;
        private final Vertex m_source;
        private final K m_sourceLink;
        private final Vertex m_target;
        private final K m_targetLink;

        public LinkDetail(String id, Vertex source, K sourceLink, Vertex target, K targetLink) {
            this.m_id = id;
            this.m_source = source;
            this.m_sourceLink = sourceLink;
            this.m_target = target;
            this.m_targetLink = targetLink;
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract Integer getSourceIfIndex();

        public abstract Integer getTargetIfIndex();

        public abstract String getType();

        public String getId() {
            return this.m_id;
        }

        public Vertex getSource() {
            return this.m_source;
        }

        public Vertex getTarget() {
            return this.m_target;
        }

        public K getSourceLink() {
            return this.m_sourceLink;
        }

        public K getTargetLink() {
            return this.m_targetLink;
        }
    }
}

