/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.AbstractCheckedOperation;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public class LinkStatusToggleOperation
extends AbstractCheckedOperation {
    private EdgeStatusProvider m_llpdStatusProvider;
    private EdgeStatusProvider m_ospfLinkStatusProvider;
    private EdgeStatusProvider m_isisLinkStatusProvider;
    private EdgeStatusProvider m_bridgeLinkStatusProvider;
    private EdgeStatusProvider m_cdpLinkStatusProvider;
    private List<EdgeStatusProvider> m_providers;

    public void init() {
        this.m_providers = new ArrayList<EdgeStatusProvider>();
        this.m_providers.add(this.m_llpdStatusProvider);
        this.m_providers.add(this.m_ospfLinkStatusProvider);
        this.m_providers.add(this.m_isisLinkStatusProvider);
        this.m_providers.add(this.m_bridgeLinkStatusProvider);
        this.m_providers.add(this.m_cdpLinkStatusProvider);
    }

    protected boolean isChecked(GraphContainer container) {
        Set edgeStatusProviders = container.getEdgeStatusProviders();
        return edgeStatusProviders.containsAll(this.m_providers);
    }

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
        Set edgeStatusProviders = container.getEdgeStatusProviders();
        String historyValue = settings.get(((Object)((Object)this)).getClass().getName());
        boolean statusEnabled = Boolean.TRUE.toString().equals(historyValue);
        if (statusEnabled) {
            if (!edgeStatusProviders.containsAll(this.m_providers)) {
                edgeStatusProviders.addAll(this.m_providers);
            }
        } else if (edgeStatusProviders.containsAll(this.m_providers)) {
            edgeStatusProviders.removeAll(this.m_providers);
        }
    }

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        this.toggle(operationContext.getGraphContainer());
        return new Operation.Undoer(){

            public void undo(OperationContext operationContext) {
                LinkStatusToggleOperation.this.toggle(operationContext.getGraphContainer());
            }
        };
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private void toggle(GraphContainer graphContainer) {
        Set edgeStatusProviders = graphContainer.getEdgeStatusProviders();
        if (edgeStatusProviders.containsAll(this.m_providers)) {
            edgeStatusProviders.removeAll(this.m_providers);
        } else {
            edgeStatusProviders.addAll(this.m_providers);
        }
        graphContainer.redoLayout();
    }

    public void setLlpdStatusProvider(EdgeStatusProvider llpdStatusProvider) {
        this.m_llpdStatusProvider = llpdStatusProvider;
    }

    public void setOspfLinkStatusProvider(EdgeStatusProvider ospfLinkStatusProvider) {
        this.m_ospfLinkStatusProvider = ospfLinkStatusProvider;
    }

    public void setIsisLinkStatusProvider(EdgeStatusProvider isisLinkStatusProvider) {
        this.m_isisLinkStatusProvider = isisLinkStatusProvider;
    }

    public void setBridgeLinkStatusProvider(EdgeStatusProvider bridgeLinkStatusProvider) {
        this.m_bridgeLinkStatusProvider = bridgeLinkStatusProvider;
    }

    public EdgeStatusProvider getCdpLinkStatusProvider() {
        return this.m_cdpLinkStatusProvider;
    }

    public void setCdpLinkStatusProvider(EdgeStatusProvider cdpLinkStatusProvider) {
        this.m_cdpLinkStatusProvider = cdpLinkStatusProvider;
    }
}

