/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkStatusProvider;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class LldpLinkStatusProvider
extends AbstractLinkStatusProvider {
    private LldpLinkDao m_lldpLinkDao;

    @Override
    public String getNameSpace() {
        return "nodes::LLDP";
    }

    @Override
    protected Set<Integer> getLinkIds(Map<String, EdgeRef> mappedRefs) {
        HashSet<Integer> lldpLinkIds = new HashSet<Integer>();
        for (String edgeRefId : mappedRefs.keySet()) {
            if (!edgeRefId.contains("|")) continue;
            int charIndex = edgeRefId.indexOf(124);
            int sourceId = Integer.parseInt(edgeRefId.substring(0, charIndex));
            int targetId = Integer.parseInt(edgeRefId.substring(charIndex + 1, edgeRefId.length()));
            lldpLinkIds.add(sourceId);
            lldpLinkIds.add(targetId);
        }
        return lldpLinkIds;
    }

    @Override
    protected List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> linkIds) {
        List links = this.m_lldpLinkDao.findLinksForIds(linkIds);
        HashMultimap summaryMap = HashMultimap.create();
        for (LldpLink sourceLink : links) {
            OnmsNode sourceNode = sourceLink.getNode();
            LldpElement sourceElement = sourceNode.getLldpElement();
            for (LldpLink targetLink : links) {
                boolean bool5;
                OnmsNode targetNode = targetLink.getNode();
                LldpElement targetLldpElement = targetNode.getLldpElement();
                boolean bool1 = sourceLink.getLldpRemPortId().equals(targetLink.getLldpPortId()) && targetLink.getLldpRemPortId().equals(sourceLink.getLldpPortId());
                boolean bool2 = sourceLink.getLldpRemPortDescr().equals(targetLink.getLldpPortDescr()) && targetLink.getLldpRemPortDescr().equals(sourceLink.getLldpPortDescr());
                boolean bool3 = sourceLink.getLldpRemChassisId().equals(targetLldpElement.getLldpChassisId()) && targetLink.getLldpRemChassisId().equals(sourceElement.getLldpChassisId());
                boolean bool4 = sourceLink.getLldpRemSysname().equals(targetLldpElement.getLldpSysname()) && targetLink.getLldpRemSysname().equals(sourceElement.getLldpSysname());
                boolean bl = bool5 = sourceLink.getLldpRemPortIdSubType() == targetLink.getLldpPortIdSubType() && targetLink.getLldpRemPortIdSubType() == sourceLink.getLldpPortIdSubType();
                if (!bool1 || !bool2 || !bool3 || !bool4 || !bool5) continue;
                summaryMap.put((Object)(sourceNode.getNodeId() + ":" + sourceLink.getLldpPortIfindex()), (Object)new EdgeAlarmStatusSummary(sourceLink.getId().intValue(), targetLink.getId().intValue(), null));
            }
        }
        List<OnmsAlarm> alarms = this.getLinkDownAlarms();
        for (OnmsAlarm alarm : alarms) {
            String key = alarm.getNodeId() + ":" + alarm.getIfIndex();
            if (!summaryMap.containsKey((Object)key)) continue;
            Collection summaries = summaryMap.get((Object)key);
            for (EdgeAlarmStatusSummary summary : summaries) {
                summary.setEventUEI(alarm.getUei());
            }
        }
        return new ArrayList<EdgeAlarmStatusSummary>(summaryMap.values());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "lldpLinkStatusProvider";
    }

    public boolean equals(Object obj) {
        if (obj instanceof EdgeStatusProvider) {
            EdgeStatusProvider provider = (EdgeStatusProvider)obj;
            return provider.getClass().getSimpleName().equals(this.getClass().getSimpleName());
        }
        return false;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }
}

