/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkdTopologyProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.opennms.netmgt.model.topology.CdpTopologyLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class EnhancedLinkdTopologyProvider
extends AbstractLinkdTopologyProvider {
    private static Logger LOG = LoggerFactory.getLogger(EnhancedLinkdTopologyProvider.class);
    static final String[] OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    private LldpLinkDao m_lldpLinkDao;
    private OspfLinkDao m_ospfLinkDao;
    private IsIsLinkDao m_isisLinkDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private CdpLinkDao m_cdpLinkDao;
    public static final String LLDP_EDGE_NAMESPACE = "nodes::LLDP";
    public static final String OSPF_EDGE_NAMESPACE = "nodes::OSPF";
    public static final String ISIS_EDGE_NAMESPACE = "nodes::ISIS";
    public static final String BRIDGE_EDGE_NAMESPACE = "nodes::BRIDGE";
    public static final String CDP_EDGE_NAMESPACE = "nodes::CDP";

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public void onInit() throws MalformedURLException, JAXBException {
        LOG.debug("init: loading topology.");
        this.load(null);
    }

    @Override
    @Transactional
    public void load(String filename) throws MalformedURLException, JAXBException {
        File configFile;
        if (filename != null) {
            LOG.warn("Filename that was specified for linkd topology will be ignored: " + filename + ", using " + this.getConfigurationFile() + " instead");
        }
        try {
            this.resetContainer();
            this.getLldpLinks();
            this.getOspfLinks();
            this.getIsIsLinks();
            this.getBridgeLinks();
            this.getCdpLinks();
        }
        catch (Exception e) {
            LOG.debug(e.getStackTrace().toString());
        }
        LOG.debug("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
        if (this.isAddNodeWithoutLink()) {
            List<OnmsNode> allNodes = this.getAllNodesNoACL();
            for (OnmsNode onmsnode : allNodes) {
                String nodeId = onmsnode.getNodeId();
                if (this.getVertex(this.getVertexNamespace(), nodeId) != null) continue;
                LOG.debug("loadtopology: adding link-less node: " + onmsnode.getLabel());
                this.addVertices(new Vertex[]{this.getVertex(onmsnode)});
            }
        }
        if ((configFile = new File(this.getConfigurationFile())).exists() && configFile.canRead()) {
            LOG.debug("loadtopology: loading topology from configuration file: " + this.getConfigurationFile());
            WrappedGraph graph = EnhancedLinkdTopologyProvider.getGraphFromFile(configFile);
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (!eachVertexInFile.group) continue;
                LOG.debug("loadtopology: adding group to topology: " + eachVertexInFile.id);
                if (eachVertexInFile.namespace == null) {
                    eachVertexInFile.namespace = this.getVertexNamespace();
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)eachVertexInFile);
                }
                if (eachVertexInFile.id == null) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)this.getConfigurationFile(), (Object)eachVertexInFile);
                }
                AbstractVertex newGroupVertex = this.addGroup(eachVertexInFile.id, eachVertexInFile.iconKey, eachVertexInFile.label);
                newGroupVertex.setIpAddress(eachVertexInFile.ipAddr);
                newGroupVertex.setLocked(eachVertexInFile.locked);
                if (eachVertexInFile.nodeID != null) {
                    newGroupVertex.setNodeID(eachVertexInFile.nodeID);
                }
                if (!newGroupVertex.equals((Object)eachVertexInFile.parent)) {
                    newGroupVertex.setParent((VertexRef)eachVertexInFile.parent);
                }
                newGroupVertex.setSelected(eachVertexInFile.selected);
                newGroupVertex.setStyleName(eachVertexInFile.styleName);
                newGroupVertex.setTooltipText(eachVertexInFile.tooltipText);
                if (eachVertexInFile.x != null) {
                    newGroupVertex.setX(eachVertexInFile.x);
                }
                if (eachVertexInFile.y == null) continue;
                newGroupVertex.setY(eachVertexInFile.y);
            }
            for (Vertex vertex : this.getVertices(new Criteria[0])) {
                if (vertex.getParent() == null || vertex.equals(vertex.getParent())) continue;
                LOG.debug("loadtopology: setting parent of " + vertex + " to " + vertex.getParent());
                this.setParent((VertexRef)vertex, vertex.getParent());
            }
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (eachVertexInFile.group || eachVertexInFile.parent == null) continue;
                Vertex child = this.getVertex((VertexRef)eachVertexInFile, new Criteria[0]);
                Vertex parent = this.getVertex((VertexRef)eachVertexInFile.parent, new Criteria[0]);
                if (child == null || parent == null) continue;
                LOG.debug("loadtopology: setting parent of " + child + " to " + parent);
                if (child.equals(parent)) continue;
                this.setParent((VertexRef)child, (VertexRef)parent);
            }
        } else {
            LOG.debug("loadtopology: could not load topology configFile:" + this.getConfigurationFile());
        }
        LOG.debug("Found " + this.getGroups().size() + " groups");
        LOG.debug("Found " + this.getVerticesWithoutGroups().size() + " vertices");
        LOG.debug("Found " + this.getEdges(new Criteria[0]).size() + " edges");
    }

    private void getOspfLinks() {
        List allLinks = this.getOspfLinkDao().findAll();
        HashSet<OspfLinkDetail> combinedLinkDetails = new HashSet<OspfLinkDetail>();
        for (OspfLink sourceLink : allLinks) {
            for (OspfLink targetLink : allLinks) {
                boolean ipAddrCheck = sourceLink.getOspfRemIpAddr().equals(targetLink.getOspfIpAddr()) && targetLink.getOspfRemIpAddr().equals(sourceLink.getOspfIpAddr());
                if (!ipAddrCheck) continue;
                String id = "ospf::" + Math.min(sourceLink.getId(), targetLink.getId()) + "||" + Math.max(sourceLink.getId(), targetLink.getId());
                AbstractVertex source = new AbstractVertex("nodes", sourceLink.getNode().getNodeId(), sourceLink.getNode().getLabel());
                source.setIpAddress(sourceLink.getOspfIpAddr().getHostAddress());
                AbstractVertex target = new AbstractVertex("nodes", targetLink.getNode().getNodeId(), targetLink.getNode().getLabel());
                target.setIpAddress(targetLink.getOspfIpAddr().getHostAddress());
                OspfLinkDetail linkDetail = new OspfLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), (Vertex)source, sourceLink, (Vertex)target, targetLink);
                combinedLinkDetails.add(linkDetail);
            }
        }
        for (OspfLinkDetail linkDetail : combinedLinkDetails) {
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), OSPF_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getLldpLinks() {
        List allLinks = this.m_lldpLinkDao.findAll();
        HashSet<LldpLinkDetail> combinedLinkDetails = new HashSet<LldpLinkDetail>();
        for (LldpLink sourceLink : allLinks) {
            LOG.debug("loadtopology: parsing link: " + sourceLink);
            OnmsNode sourceNode = sourceLink.getNode();
            LldpElement sourceElement = sourceNode.getLldpElement();
            LOG.debug("loadtopology: found source node: " + sourceNode.getLabel());
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceNode.getNodeId());
            if (source == null) {
                LOG.debug("loadtopology: adding source node as vertex: " + sourceNode.getLabel());
                source = this.getVertex(sourceNode);
                this.addVertices(new Vertex[]{source});
            }
            for (LldpLink targetLink : allLinks) {
                boolean bool5;
                OnmsNode targetNode = targetLink.getNode();
                LldpElement targetLldpElement = targetNode.getLldpElement();
                boolean bool1 = sourceLink.getLldpRemPortId().equals(targetLink.getLldpPortId()) && targetLink.getLldpRemPortId().equals(sourceLink.getLldpPortId());
                boolean bool2 = sourceLink.getLldpRemPortDescr().equals(targetLink.getLldpPortDescr()) && targetLink.getLldpRemPortDescr().equals(sourceLink.getLldpPortDescr());
                boolean bool3 = sourceLink.getLldpRemChassisId().equals(targetLldpElement.getLldpChassisId()) && targetLink.getLldpRemChassisId().equals(sourceElement.getLldpChassisId());
                boolean bool4 = sourceLink.getLldpRemSysname().equals(targetLldpElement.getLldpSysname()) && targetLink.getLldpRemSysname().equals(sourceElement.getLldpSysname());
                boolean bl = bool5 = sourceLink.getLldpRemPortIdSubType() == targetLink.getLldpPortIdSubType() && targetLink.getLldpRemPortIdSubType() == sourceLink.getLldpPortIdSubType();
                if (!bool1 || !bool2 || !bool3 || !bool4 || !bool5) continue;
                Vertex target = this.getVertex(this.getVertexNamespace(), targetNode.getNodeId());
                if (target == null) {
                    target = this.getVertex(targetNode);
                }
                LldpLinkDetail linkDetail = new LldpLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink);
                combinedLinkDetails.add(linkDetail);
            }
        }
        for (LldpLinkDetail linkDetail : combinedLinkDetails) {
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), LLDP_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getCdpLinks() {
        List cdpLinks = this.m_cdpLinkDao.findLinksForTopology();
        for (CdpTopologyLink link : cdpLinks) {
            String id = Math.min(link.getSourceId(), link.getTargetId()) + "|" + Math.max(link.getSourceId(), link.getTargetId());
            CdpLinkDetail linkDetail = new CdpLinkDetail(id, (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)link.getSrcNodeId())), link.getSrcIfIndex(), link.getSrcIfName(), (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)link.getTargetNodeId())), link.getTargetIfName());
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), CDP_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getIsIsLinks() {
        List isislinks = this.m_isisLinkDao.getLinksForTopology();
        for (Object[] linkObj : isislinks) {
            Integer link1Id = (Integer)linkObj[1];
            Integer link1Nodeid = (Integer)linkObj[2];
            Integer link1IfIndex = (Integer)linkObj[3];
            Integer link2Id = (Integer)linkObj[4];
            Integer link2Nodeid = (Integer)linkObj[5];
            Integer link2IfIndex = (Integer)linkObj[6];
            IsIsLinkDetail linkDetail = new IsIsLinkDetail(Math.min(link1Id, link2Id) + "|" + Math.max(link1Id, link2Id), (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)link1Nodeid)), link1Id, link1IfIndex, (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)link2Nodeid)), link2Id, link2IfIndex);
            AbstractEdge edge = this.connectVertices(linkDetail.getId(), (VertexRef)linkDetail.getSource(), (VertexRef)linkDetail.getTarget(), ISIS_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail));
        }
    }

    private void getBridgeLinks() {
        List bridgeMacLinks = this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes();
        HashMultimap multimap = HashMultimap.create();
        for (BridgeMacTopologyLink macLink : bridgeMacLinks) {
            multimap.put((Object)(String.valueOf(macLink.getNodeId()) + "|" + String.valueOf(macLink.getBridgePort())), (Object)macLink);
        }
        for (String key : multimap.keySet()) {
            Collection links = multimap.get((Object)key);
            if (links.size() > 1) {
                this.processMultipleBridgeLinks(key, links);
                continue;
            }
            BridgeMacTopologyLink topoLink = (BridgeMacTopologyLink)links.iterator().next();
            String id = Math.min(topoLink.getNodeId(), topoLink.getTargetNodeId()) + "|" + Math.max(topoLink.getNodeId(), topoLink.getTargetNodeId());
            BridgeLinkDetail detail = new BridgeLinkDetail(id, "nodes", (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)topoLink.getNodeId())), topoLink.getId(), (Vertex)this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)topoLink.getTargetNodeId())), topoLink.getId());
            AbstractEdge edge = this.connectVertices(detail.getId(), (VertexRef)detail.getSource(), (VertexRef)detail.getTarget(), BRIDGE_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(detail));
        }
    }

    private void processMultipleBridgeLinks(String bridgeLinkKey, Collection<BridgeMacTopologyLink> topoLinks) {
        String[] keyParts = bridgeLinkKey.split("\\|");
        int parentNodeId = Integer.parseInt(keyParts[0]);
        String bridgePort = keyParts[1];
        AbstractVertex parentVertex = this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(parentNodeId)));
        AbstractVertex cloudVertex = this.addVertex(bridgeLinkKey, 0, 0);
        cloudVertex.setLabel("");
        cloudVertex.setIconKey("cloud");
        cloudVertex.setTooltipText(parentVertex.getLabel() + " bridge port: " + bridgePort);
        for (BridgeMacTopologyLink topoLink : topoLinks) {
            if (topoLink.getTargetNodeId() == null) continue;
            if (this.getEdgeIdsForVertex((VertexRef)cloudVertex).length == 0) {
                AbstractEdge edge = this.connectVertices(bridgeLinkKey, (VertexRef)cloudVertex, (VertexRef)parentVertex, BRIDGE_EDGE_NAMESPACE);
                edge.setTooltipText(this.getBridgeCloudTooltip((Vertex)parentVertex, bridgePort));
            }
            String edgeId = Math.min(topoLink.getNodeId(), topoLink.getTargetNodeId()) + "|" + Math.max(topoLink.getNodeId(), topoLink.getTargetNodeId());
            AbstractVertex target = this.getVertex((OnmsNode)this.m_nodeDao.get((Serializable)topoLink.getTargetNodeId()));
            AbstractEdge edge = this.connectVertices(edgeId, (VertexRef)cloudVertex, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
            SimpleLeafVertex tooltipCloudVertex = new SimpleLeafVertex("nodes", null, Integer.valueOf(0), Integer.valueOf(0));
            tooltipCloudVertex.setLabel(parentVertex.getLabel() + " bridge port: " + bridgePort);
            tooltipCloudVertex.setIpAddress("");
            BridgeLinkDetail detail = new BridgeLinkDetail(edgeId, "nodes", (Vertex)tooltipCloudVertex, topoLink.getId(), (Vertex)target, topoLink.getId());
            edge.setTooltipText(this.getEdgeTooltipText(detail));
        }
    }

    public void refresh() {
        try {
            this.load(null);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getBridgeCloudTooltip(Vertex parentVertex, String bridgePort) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append("<p>");
        tooltipText.append("Type of Link: Bridge Layer 2");
        tooltipText.append("<p>");
        tooltipText.append("<p>");
        tooltipText.append("Name: &lt;endpoint1 " + parentVertex.getLabel() + " bridge port: " + bridgePort);
        tooltipText.append(" ---- endpoint2 " + parentVertex.getLabel() + "&gt;");
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 1: " + parentVertex.getLabel() + " bridge port: " + bridgePort);
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 2: " + parentVertex.getLabel() + ", " + parentVertex.getIpAddress());
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    private String getEdgeTooltipText(LinkDetail linkDetail) {
        StringBuffer tooltipText = new StringBuffer();
        Vertex source = linkDetail.getSource();
        Vertex target = linkDetail.getTarget();
        OnmsSnmpInterface sourceInterface = this.getByNodeIdAndIfIndex(linkDetail.getSourceIfIndex(), source);
        OnmsSnmpInterface targetInterface = this.getByNodeIdAndIfIndex(linkDetail.getTargetIfIndex(), target);
        tooltipText.append("<p>");
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append("Type of Link: " + linkDetail.getType() + " Layer3/Layer2");
        } else {
            tooltipText.append("Type of Link: " + linkDetail.getType() + " Layer2");
        }
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("Name: &lt;endpoint1 " + source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append(":" + sourceInterface.getIfName());
        }
        tooltipText.append(" ---- endpoint2 " + target.getLabel());
        if (targetInterface != null) {
            tooltipText.append(":" + targetInterface.getIfName());
        }
        tooltipText.append("&gt;");
        tooltipText.append("</p>");
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append("<p>");
                tooltipText.append("Bandwidth: " + EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append("</p>");
            }
        } else if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append("<p>");
            tooltipText.append("Bandwidth: " + EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append("</p>");
        }
        tooltipText.append("<p>");
        tooltipText.append("End Point 1: " + source.getLabel() + ", " + source.getIpAddress());
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append("End Point 2: " + target.getLabel() + ", " + target.getIpAddress());
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    private OnmsSnmpInterface getByNodeIdAndIfIndex(Integer ifIndex, Vertex source) {
        if (source.getId() != null && StringUtils.isNumeric((String)source.getId()) && ifIndex != null) {
            return this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(source.getId())), ifIndex);
        }
        return null;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public String getSearchProviderNamespace() {
        return "nodes";
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List<Vertex> vertices = this.getFilteredVertices();
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopGraphProvider.VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.VertexHopCriteria criterion = LinkdHopCriteriaFactory.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    private Criteria findCriterion(String resultId, GraphContainer container) {
        Criteria[] criteria;
        for (Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (criterion instanceof LinkdHopCriteria && (id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) {
                return criterion;
            }
            if (!(criterion instanceof VertexHopGraphProvider.FocusNodeHopCriteria) || !(id = ((VertexHopGraphProvider.FocusNodeHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    private void logCriteriaInContainer(GraphContainer container) {
        Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }

    private static interface LinkState {
        public void setParentInterfaces(OnmsSnmpInterface var1, OnmsSnmpInterface var2);

        public String getLinkStatus();
    }

    public class CdpLinkDetail
    extends LinkDetail<Integer> {
        private final Integer m_sourceIfIndex;
        private final String m_sourceIfName;
        private final String m_targetIfName;

        public CdpLinkDetail(String id, Vertex source, Integer sourceIfIndex, String sourceIfName, Vertex target, String targetIfName) {
            super(id, source, null, target, null);
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_sourceIfName = sourceIfName;
            this.m_targetIfName = targetIfName;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CdpLinkDetail) {
                CdpLinkDetail objDetail = (CdpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfIndex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return null;
        }

        @Override
        public String getType() {
            return "CDP";
        }
    }

    public class BridgeLinkDetail
    extends LinkDetail<Integer> {
        private final String m_vertexNamespace;

        public BridgeLinkDetail(String id, String vertexNamespace, Vertex source, Integer sourceLink, Vertex target, Integer targetLink) {
            super(id, source, sourceLink, target, targetLink);
            this.m_vertexNamespace = vertexNamespace;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (this.getVertexNamespace() == null ? 0 : this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BridgeLinkDetail) {
                BridgeLinkDetail objDetail = (BridgeLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return 0;
        }

        @Override
        public Integer getTargetIfIndex() {
            return 0;
        }

        @Override
        public String getType() {
            return "Bridge";
        }

        public String getVertexNamespace() {
            return this.m_vertexNamespace;
        }
    }

    private class IsIsLinkDetail
    extends LinkDetail<Integer> {
        private final int m_sourceIfindex;
        private final int m_targetIfindex;
        private final int m_sourceLinkId;
        private final int m_targetLinkId;

        public IsIsLinkDetail(String id, Vertex source, int sourceLinkId, Integer sourceIfIndex, Vertex target, int targetLinkId, Integer targetIfIndex) {
            super(id, source, null, target, null);
            this.m_sourceLinkId = sourceLinkId;
            this.m_targetLinkId = targetLinkId;
            this.m_sourceIfindex = sourceIfIndex;
            this.m_targetIfindex = targetIfIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.m_sourceLinkId) + (this.getTargetLink() == null ? 0 : this.m_targetLinkId);
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsIsLinkDetail) {
                IsIsLinkDetail objDetail = (IsIsLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfindex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return this.m_targetIfindex;
        }

        @Override
        public String getType() {
            return "IsIs";
        }
    }

    private class OspfLinkDetail
    extends LinkDetail<OspfLink> {
        public OspfLinkDetail(String id, Vertex source, OspfLink sourceLink, Vertex target, OspfLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((OspfLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((OspfLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OspfLinkDetail) {
                OspfLinkDetail objDetail = (OspfLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((OspfLink)this.getSourceLink()).getOspfIfIndex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((OspfLink)this.getTargetLink()).getOspfIfIndex();
        }

        @Override
        public String getType() {
            return "OSPF";
        }
    }

    private class LldpLinkDetail
    extends LinkDetail<LldpLink> {
        public LldpLinkDetail(String id, Vertex source, LldpLink sourceLink, Vertex target, LldpLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((LldpLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((LldpLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getVertexNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof LldpLinkDetail) {
                LldpLinkDetail objDetail = (LldpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((LldpLink)this.getSourceLink()).getLldpPortIfindex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((LldpLink)this.getTargetLink()).getLldpPortIfindex();
        }

        @Override
        public String getType() {
            return "LLDP";
        }
    }

    private abstract class LinkDetail<K> {
        private final String m_id;
        private final Vertex m_source;
        private final K m_sourceLink;
        private final Vertex m_target;
        private final K m_targetLink;

        public LinkDetail(String id, Vertex source, K sourceLink, Vertex target, K targetLink) {
            this.m_id = id;
            this.m_source = source;
            this.m_sourceLink = sourceLink;
            this.m_target = target;
            this.m_targetLink = targetLink;
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract Integer getSourceIfIndex();

        public abstract Integer getTargetIfIndex();

        public abstract String getType();

        public String getId() {
            return this.m_id;
        }

        public Vertex getSource() {
            return this.m_source;
        }

        public Vertex getTarget() {
            return this.m_target;
        }

        public K getSourceLink() {
            return this.m_sourceLink;
        }

        public K getTargetLink() {
            return this.m_targetLink;
        }
    }
}

