/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkStatusProvider;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.topology.CdpTopologyLink;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class CdpLinkStatusProvider
extends AbstractLinkStatusProvider {
    private CdpLinkDao m_cdpLinkDao;

    @Override
    public String getNameSpace() {
        return "nodes::CDP";
    }

    @Override
    protected List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> linkIds) {
        List cdpLinks = this.getCdpLinkDao().findLinksForTopologyByIds(linkIds.toArray(new Integer[0]));
        HashMultimap summaryMap = HashMultimap.create();
        for (CdpTopologyLink link : cdpLinks) {
            summaryMap.put((Object)(link.getSrcNodeId() + ":" + link.getSrcIfIndex()), (Object)new EdgeAlarmStatusSummary(link.getSourceId().intValue(), link.getTargetId().intValue(), null));
        }
        List<OnmsAlarm> alarms = this.getLinkDownAlarms();
        for (OnmsAlarm alarm : alarms) {
            String key = alarm.getNodeId() + ":" + alarm.getIfIndex();
            if (!summaryMap.containsKey((Object)key)) continue;
            Collection summaries = summaryMap.get((Object)key);
            for (EdgeAlarmStatusSummary summary : summaries) {
                summary.setEventUEI(alarm.getUei());
            }
        }
        return new ArrayList<EdgeAlarmStatusSummary>(summaryMap.values());
    }

    @Override
    protected Set<Integer> getLinkIds(Map<String, EdgeRef> mappedRefs) {
        HashSet<Integer> linkIds = new HashSet<Integer>();
        for (String edgeRefId : mappedRefs.keySet()) {
            if (!edgeRefId.contains("|")) continue;
            int charIndex = edgeRefId.indexOf(124);
            int sourceId = Integer.parseInt(edgeRefId.substring(0, charIndex));
            int targetId = Integer.parseInt(edgeRefId.substring(charIndex + 1, edgeRefId.length()));
            linkIds.add(sourceId);
            linkIds.add(targetId);
        }
        return linkIds;
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }
}

