/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedEdge;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedGroup;
import org.opennms.features.topology.api.topo.WrappedLeafVertex;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.TopologyDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public abstract class AbstractLinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider,
SearchProvider {
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    protected static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    protected static final String HTML_TOOLTIP_TAG_END = "</p>";
    protected static final DecimalFormat s_oneDigitAfterDecimal = new DecimalFormat("0.0##");
    protected static final DecimalFormat s_noDigitsAfterDecimal = new DecimalFormat("0");
    protected static final EnumMap<OnmsNode.NodeType, String> m_nodeStatusMap = new EnumMap(OnmsNode.NodeType.class);
    static final String[] OPER_ADMIN_STATUS;
    protected final boolean m_aclEnabled;
    protected String m_configurationFile;
    protected NodeDao m_nodeDao;
    protected SnmpInterfaceDao m_snmpInterfaceDao;
    protected IpInterfaceDao m_ipInterfaceDao;
    protected TopologyDao m_topologyDao;
    protected FilterManager m_filterManager;
    protected boolean m_addNodeWithoutLink = false;
    protected LinkdHopCriteriaFactory m_criteriaHopFactory;

    protected AbstractLinkdTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_LINKD);
        String aclsProp = System.getProperty("org.opennms.web.aclsEnabled");
        this.m_aclEnabled = aclsProp != null ? aclsProp.equals("true") : false;
    }

    protected static String getHumanReadableIfSpeed(long ifSpeed) {
        String units;
        double displaySpeed;
        DecimalFormat formatter;
        if (ifSpeed >= 1000000000L) {
            formatter = ifSpeed % 1000000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1.0E9;
            units = "Gbps";
        } else if (ifSpeed >= 1000000L) {
            formatter = ifSpeed % 1000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000000.0;
            units = "Mbps";
        } else if (ifSpeed >= 1000L) {
            formatter = ifSpeed % 1000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000.0;
            units = "kbps";
        } else {
            formatter = s_noDigitsAfterDecimal;
            displaySpeed = ifSpeed;
            units = "bps";
        }
        return formatter.format(displaySpeed) + " " + units;
    }

    protected static WrappedGraph getGraphFromFile(File file) throws JAXBException, MalformedURLException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WrappedGraph.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (WrappedGraph)u.unmarshal(file.toURI().toURL());
    }

    public static String getIconName(OnmsNode node) {
        return node.getSysObjectId() == null ? "linkd:system" : "linkd:system:snmp:" + node.getSysObjectId();
    }

    protected static String getNodeStatusString(OnmsNode.NodeType c) {
        return m_nodeStatusMap.get(c);
    }

    protected static String getNodeTooltipText(OnmsNode node, AbstractVertex vertex, OnmsIpInterface ip) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Management IP and Name: " + vertex.getIpAddress() + " (" + vertex.getLabel() + ")");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (node.getSysLocation() != null && node.getSysLocation().length() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append("Location: " + node.getSysLocation());
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Status: " + AbstractLinkdTopologyProvider.getNodeStatusString(node.getType()));
        if (ip != null && ip.isManaged()) {
            tooltipText.append(" / Managed");
        } else {
            tooltipText.append(" / Unmanaged");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        return tooltipText.toString();
    }

    public String getConfigurationFile() {
        return this.m_configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    protected List<Vertex> getFilteredVertices() {
        if (this.isAclEnabled()) {
            List onmsNodes = this.getNodeDao().findAll();
            final List nodes = Lists.transform((List)onmsNodes, (Function)new Function<OnmsNode, Integer>(){

                public Integer apply(OnmsNode node) {
                    return node.getId();
                }
            });
            return Lists.newArrayList((Iterable)Collections2.filter((Collection)this.m_vertexProvider.getVertices(new Criteria[0]), (Predicate)new Predicate<Vertex>(){

                public boolean apply(Vertex vertex) {
                    return nodes.contains(vertex.getNodeID());
                }
            }));
        }
        return this.m_vertexProvider.getVertices(new Criteria[0]);
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setTopologyDao(TopologyDao topologyDao) {
        this.m_topologyDao = topologyDao;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public void setAddNodeWithoutLink(boolean addNodeWithoutLink) {
        this.m_addNodeWithoutLink = addNodeWithoutLink;
    }

    public boolean isAddNodeWithoutLink() {
        return this.m_addNodeWithoutLink;
    }

    public boolean isAclEnabled() {
        return this.m_aclEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OnmsNode> getAllNodesNoACL() {
        if (this.getFilterManager().isEnabled()) {
            String[] userGroups = this.getFilterManager().getAuthorizationGroups();
            List<OnmsNode> nodeList = null;
            try {
                this.getFilterManager().disableAuthorizationFilter();
                nodeList = this.getNodeDao().findAll();
            }
            finally {
                if (userGroups != null) {
                    this.getFilterManager().enableAuthorizationFilter(userGroups);
                }
            }
            return nodeList != null ? nodeList : Collections.emptyList();
        }
        return this.getNodeDao().findAll();
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void save() {
        ArrayList<Object> vertices = new ArrayList<Object>();
        for (Vertex vertex : this.getVertices(new Criteria[0])) {
            if (vertex.isGroup()) {
                vertices.add(new WrappedGroup(vertex));
                continue;
            }
            vertices.add(new WrappedLeafVertex(vertex));
        }
        ArrayList<WrappedEdge> edges = new ArrayList<WrappedEdge>();
        for (Edge edge : this.getEdges(new Criteria[0])) {
            WrappedEdge newEdge = new WrappedEdge(edge, (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getSource().getVertex(), new Criteria[0])), (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getTarget().getVertex(), new Criteria[0])));
            edges.add(newEdge);
        }
        WrappedGraph graph = new WrappedGraph(this.getEdgeNamespace(), vertices, edges);
        JAXB.marshal((Object)graph, (File)new File(this.getConfigurationFile()));
    }

    public LinkdHopCriteriaFactory getLinkdHopCriteriaFactory() {
        return this.m_criteriaHopFactory;
    }

    public void setLinkdHopCriteriaFactory(LinkdHopCriteriaFactory criteriaHopFactory) {
        this.m_criteriaHopFactory = criteriaHopFactory;
    }

    protected OnmsIpInterface getAddress(OnmsNode node) {
        OnmsIpInterface ip;
        block0: {
            OnmsIpInterface iterip;
            Iterator i$;
            ip = this.getIpInterfaceDao().findPrimaryInterfaceByNodeId(node.getId());
            if (ip != null || !(i$ = this.getIpInterfaceDao().findByNodeId(node.getId()).iterator()).hasNext()) break block0;
            ip = iterip = (OnmsIpInterface)i$.next();
        }
        return ip;
    }

    protected AbstractVertex getVertex(OnmsNode onmsnode) {
        OnmsIpInterface ip = this.getAddress(onmsnode);
        SimpleLeafVertex vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_LINKD, onmsnode.getNodeId(), Integer.valueOf(0), Integer.valueOf(0));
        vertex.setIconKey(AbstractLinkdTopologyProvider.getIconName(onmsnode));
        vertex.setLabel(onmsnode.getLabel());
        vertex.setIpAddress(ip == null ? null : ip.getIpAddress().getHostAddress());
        vertex.setNodeID(Integer.valueOf(Integer.parseInt(onmsnode.getNodeId())));
        vertex.setTooltipText(AbstractLinkdTopologyProvider.getNodeTooltipText(onmsnode, (AbstractVertex)vertex, ip));
        return vertex;
    }

    protected String getEdgeTooltipText(DataLinkInterface link, Vertex source, Vertex target) {
        StringBuffer tooltipText = new StringBuffer();
        OnmsSnmpInterface sourceInterface = this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(source.getId())), link.getIfIndex());
        OnmsSnmpInterface targetInterface = this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(target.getId())), link.getParentIfIndex());
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append("Type of Link: Layer3/Layer2");
        } else {
            tooltipText.append("Type of Link: Layer2");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Name: &lt;endpoint1 " + source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append(":" + sourceInterface.getIfName());
        }
        tooltipText.append(" ---- endpoint2 " + target.getLabel());
        if (targetInterface != null) {
            tooltipText.append(":" + targetInterface.getIfName());
        }
        tooltipText.append("&gt;");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        LinkStateMachine stateMachine = new LinkStateMachine();
        stateMachine.setParentInterfaces(sourceInterface, targetInterface);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Link status: " + stateMachine.getLinkStatus());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Bandwidth: " + AbstractLinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
        } else if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append("Bandwidth: " + AbstractLinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 1: " + source.getLabel() + ", " + source.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 2: " + target.getLabel() + ", " + target.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        return tooltipText.toString();
    }

    public abstract void load(String var1) throws MalformedURLException, JAXBException;

    public VertexHopGraphProvider.VertexHopCriteria getDefaultCriteria() {
        AbstractVertex defaultVertex;
        OnmsNode node = this.m_topologyDao.getDefaultFocusPoint();
        VertexHopGraphProvider.VertexHopCriteria criterion = null;
        if (node != null && (defaultVertex = this.getVertex(node)) != null) {
            VertexHopGraphProvider.FocusNodeHopCriteria hopCriteria = new VertexHopGraphProvider.FocusNodeHopCriteria();
            hopCriteria.add((VertexRef)defaultVertex);
            return hopCriteria;
        }
        return criterion;
    }

    static {
        m_nodeStatusMap.put(OnmsNode.NodeType.ACTIVE, "Active");
        m_nodeStatusMap.put(OnmsNode.NodeType.UNKNOWN, "Unknown");
        m_nodeStatusMap.put(OnmsNode.NodeType.DELETED, "Deleted");
        OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    }

    private class LinkUnknownState
    extends AbstractLinkState {
        public LinkUnknownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && sourceInterface != null) {
                if (sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                } else {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
                }
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[4];
        }
    }

    private class LinkDownState
    extends AbstractLinkState {
        public LinkDownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null) {
                if (sourceInterface != null && sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                }
            } else if (sourceInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[2];
        }
    }

    private class LinkUpState
    extends AbstractLinkState {
        public LinkUpState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (sourceInterface != null && sourceInterface.getIfOperStatus() != null && sourceInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && targetInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (sourceInterface == null && targetInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[1];
        }
    }

    private abstract class AbstractLinkState
    implements LinkState {
        private LinkStateMachine m_linkStateMachine;

        public AbstractLinkState(LinkStateMachine linkStateMachine) {
            this.m_linkStateMachine = linkStateMachine;
        }

        protected LinkStateMachine getLinkStateMachine() {
            return this.m_linkStateMachine;
        }
    }

    protected class LinkStateMachine {
        LinkState m_upState;
        LinkState m_downState;
        LinkState m_unknownState;
        LinkState m_state;

        public LinkStateMachine() {
            this.m_upState = new LinkUpState(this);
            this.m_downState = new LinkDownState(this);
            this.m_unknownState = new LinkUnknownState(this);
            this.m_state = this.m_upState;
        }

        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            this.m_state.setParentInterfaces(sourceInterface, targetInterface);
        }

        public String getLinkStatus() {
            return this.m_state.getLinkStatus();
        }

        public LinkState getUpState() {
            return this.m_upState;
        }

        public LinkState getDownState() {
            return this.m_downState;
        }

        public LinkState getUnknownState() {
            return this.m_unknownState;
        }

        public void setState(LinkState state) {
            this.m_state = state;
        }
    }

    private static interface LinkState {
        public void setParentInterfaces(OnmsSnmpInterface var1, OnmsSnmpInterface var2);

        public String getLinkStatus();
    }
}

