/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public abstract class AbstractLinkStatusProvider
implements EdgeStatusProvider {
    private AlarmDao m_alarmDao;

    public String getNameSpace() {
        return "nodes";
    }

    public boolean contributesTo(String namespace) {
        return namespace.equals("nodes");
    }

    protected abstract List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> var1);

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, org.opennms.features.topology.api.topo.Criteria[] criteria) {
        Map<String, EdgeRef> mappedRefs = this.mapRefs(edges);
        Map<EdgeRef, Status> returnMap = this.initializeMap(edges);
        Set<Integer> linkIds = this.getLinkIds(mappedRefs);
        if (linkIds.size() > 0) {
            List<EdgeAlarmStatusSummary> edgeAlarmSummaries = this.getEdgeAlarmSummaries(new ArrayList<Integer>(linkIds));
            for (EdgeAlarmStatusSummary eSum : edgeAlarmSummaries) {
                String linkId = eSum.getId();
                EdgeRef edge = mappedRefs.get(linkId);
                if (returnMap.size() <= 0 || edge == null) continue;
                returnMap.put(edge, this.getLinkStatusForSummary(eSum));
            }
        }
        return returnMap;
    }

    protected LinkStatus getLinkStatusForSummary(EdgeAlarmStatusSummary summary) {
        return new LinkStatus(summary);
    }

    protected abstract Set<Integer> getLinkIds(Map<String, EdgeRef> var1);

    protected Map<String, EdgeRef> mapRefs(Collection<EdgeRef> edges) {
        HashMap<String, EdgeRef> retVal = new HashMap<String, EdgeRef>();
        for (EdgeRef edge : edges) {
            String nameSpace = this.getNameSpace();
            if (!edge.getNamespace().equals(nameSpace)) continue;
            retVal.put(edge.getId(), edge);
        }
        return retVal;
    }

    protected Map<EdgeRef, Status> initializeMap(Collection<EdgeRef> edges) {
        HashMap<EdgeRef, Status> retVal = new HashMap<EdgeRef, Status>();
        for (EdgeRef edge : edges) {
            String nameSpace = this.getNameSpace();
            if (!edge.getNamespace().equals(nameSpace)) continue;
            retVal.put(edge, new LinkStatus("unknown"));
        }
        return retVal;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    protected List<OnmsAlarm> getLinkDownAlarms() {
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.addRestriction((Restriction)new EqRestriction("uei", (Object)"uei.opennms.org/internal/topology/linkDown"));
        criteria.addRestriction((Restriction)new NeRestriction("severity", (Object)OnmsSeverity.CLEARED));
        return this.getAlarmDao().findMatching(criteria);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public static class LinkStatus
    implements Status {
        private final String m_status;

        public LinkStatus(String status) {
            this.m_status = status;
        }

        public LinkStatus(EdgeAlarmStatusSummary summary) {
            this.m_status = summary.getEventUEI().equals("uei.opennms.org/internal/topology/linkDown") ? "down" : "up";
        }

        public String computeStatus() {
            return this.m_status.toLowerCase();
        }

        public Map<String, String> getStatusProperties() {
            HashMap<String, String> statusMap = new HashMap<String, String>();
            statusMap.put("status", this.m_status);
            return statusMap;
        }
    }
}

