/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.opennms.features.topology.api.support.AbstractHistoryManager;
import org.opennms.features.topology.api.support.SavedHistory;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class BundleContextHistoryManager
extends AbstractHistoryManager {
    private final BundleContext m_bundleContext;
    public static final String DATA_FILE_NAME = BundleContextHistoryManager.class.getName() + ".properties";

    public BundleContextHistoryManager(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
    }

    protected synchronized void saveHistory(String userId, SavedHistory hist) {
        Properties props = BundleContextHistoryManager.loadProperties(this.m_bundleContext);
        String historyXml = this.toXML(hist);
        props.put(hist.getFragment(), historyXml);
        props.put(userId, hist.getFragment());
        BundleContextHistoryManager.storeProperties(this.m_bundleContext, props);
    }

    protected synchronized SavedHistory getHistory(String userId, String fragmentId) {
        if (fragmentId != null) {
            Properties props = BundleContextHistoryManager.loadProperties(this.m_bundleContext);
            String xml = props.getProperty(fragmentId);
            if (xml == null || "".equals(xml)) {
                return null;
            }
            return (SavedHistory)JAXB.unmarshal((Reader)new StringReader(xml), SavedHistory.class);
        }
        return null;
    }

    public synchronized String getHistoryHash(String userId) {
        return BundleContextHistoryManager.loadProperties(this.m_bundleContext).getProperty(userId);
    }

    private void cleanUp(String userId, Properties properties) {
        if (properties.containsKey(userId)) {
            String historyHash = properties.getProperty(userId);
            int usageCount = 0;
            for (Object eachKey : properties.keySet()) {
                String eachValue = properties.getProperty((String)eachKey);
                if (eachValue == null || !eachValue.equals(historyHash)) continue;
                ++usageCount;
            }
            if (usageCount == 1) {
                properties.remove(historyHash);
            }
        }
    }

    private String toXML(SavedHistory hist) {
        StringWriter writer = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SavedHistory.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            marshaller.marshal((Object)hist, (Writer)writer);
        }
        catch (JAXBException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not marshall SavedHistory object to String", (Throwable)e);
        }
        return writer.toString();
    }

    private static Properties loadProperties(BundleContext context) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(context.getDataFile(DATA_FILE_NAME)));
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("BundleContextHistoryManager data file does not exist yet");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("IOException when reading BundleContextHistoryManager data file", (Throwable)e);
        }
        return props;
    }

    private static void storeProperties(BundleContext context, Properties props) {
        try {
            props.store(new FileOutputStream(context.getDataFile(DATA_FILE_NAME)), BundleContextHistoryManager.class.getName() + " History Data");
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("BundleContextHistoryManager data file does not exist");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("IOException when writing to BundleContextHistoryManager data file", (Throwable)e);
        }
    }
}

