/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.ScriptEngineManager;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.features.osgi.script.OSGiScriptEngineManager;
import org.opennms.features.topology.api.IconRepository;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLMetaTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLSearchProvider;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLIconRepository;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLDefaultVertexStatusProvider;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLEdgeStatusProvider;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLPropagateVertexStatusProvider;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLScriptVertexStatusProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLMetaTopologyFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLMetaTopologyFactory.class);
    private static final String TOPOLOGY_LOCATION = "topologyLocation";
    private static final String LABEL = "label";
    private final GraphMLServiceAccessor m_serviceAccessor;
    private final BundleContext m_bundleContext;
    private final Map<String, List<ServiceRegistration<?>>> m_serviceRegistration = Maps.newHashMap();

    public GraphMLMetaTopologyFactory(BundleContext bundleContext, GraphMLServiceAccessor serviceAccessor) {
        this.m_bundleContext = Objects.requireNonNull(bundleContext);
        this.m_serviceAccessor = Objects.requireNonNull(serviceAccessor);
    }

    public String getName() {
        return "This Factory creates GraphML Topology Providers";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        LOG.debug("updated(String, Dictionary) invoked");
        String location = (String)properties.get(TOPOLOGY_LOCATION);
        if (!this.m_serviceRegistration.containsKey(pid)) {
            LOG.debug("Service with pid '{}' is new. Register {}", (Object)pid, (Object)GraphMLMetaTopologyProvider.class.getSimpleName());
            Hashtable<String, Object> metaData = new Hashtable<String, Object>();
            ((Dictionary)metaData).put("service.pid", pid);
            if (properties.get(LABEL) != null) {
                ((Dictionary)metaData).put(LABEL, properties.get(LABEL));
            }
            try {
                GraphMLMetaTopologyProvider metaTopologyProvider = new GraphMLMetaTopologyProvider(this.m_serviceAccessor);
                metaTopologyProvider.setTopologyLocation(location);
                metaTopologyProvider.reload();
                this.registerService(pid, MetaTopologyProvider.class, metaTopologyProvider, metaData);
                Set<String> iconKeys = metaTopologyProvider.getGraphProviders().stream().map(GraphProvider::getNamespace).flatMap(eachNamespace -> metaTopologyProvider.getGraphProvider((String)eachNamespace).getCurrentGraph().getVertices(new Criteria[0]).stream()).map(Vertex::getIconKey).filter(Objects::nonNull).collect(Collectors.toSet());
                this.registerService(pid, IconRepository.class, new GraphMLIconRepository(iconKeys));
                OSGiScriptEngineManager scriptEngineManager = new OSGiScriptEngineManager(this.m_bundleContext);
                metaTopologyProvider.getGraphProviders().forEach(arg_0 -> this.lambda$updated$2(metaTopologyProvider, pid, (ScriptEngineManager)scriptEngineManager, arg_0));
            }
            catch (IOException | InvalidGraphException e) {
                LOG.error("An error occurred while loading GraphMLTopology from file {}. Ignoring...", (Object)location, (Object)e);
            }
        } else {
            LOG.warn("Service with pid '{}' updated. Updating is not supported. Ignoring...", (Object)pid);
        }
    }

    public void deleted(String pid) {
        LOG.debug("deleted(String) invoked");
        List<ServiceRegistration<?>> serviceRegistrations = this.m_serviceRegistration.get(pid);
        if (serviceRegistrations != null) {
            LOG.debug("Unregister services for pid '{}'", (Object)pid);
            serviceRegistrations.forEach(ServiceRegistration::unregister);
            this.m_serviceRegistration.remove(pid);
        }
    }

    private <T> void registerService(String pid, Class<T> serviceType, T serviceImpl) {
        this.registerService(pid, serviceType, serviceImpl, new Hashtable<String, Object>());
    }

    private <T> void registerService(String pid, Class<T> serviceType, T serviceImpl, Dictionary<String, Object> serviceProperties) {
        ServiceRegistration serviceRegistration = this.m_bundleContext.registerService(serviceType, serviceImpl, serviceProperties);
        this.m_serviceRegistration.putIfAbsent(pid, Lists.newArrayList());
        this.m_serviceRegistration.get(pid).add(serviceRegistration);
    }

    private Optional<StatusProvider> buildStatusProvider(GraphMLMetaTopologyProvider metaTopologyProvider, ScriptEngineManager scriptEngineManager, GraphMLTopologyProvider rawTopologyProvider) {
        switch (rawTopologyProvider.getVertexStatusProviderType()) {
            case NO_STATUS_PROVIDER: {
                return Optional.empty();
            }
            case DEFAULT_STATUS_PROVIDER: {
                return Optional.of(new GraphMLDefaultVertexStatusProvider(rawTopologyProvider.getNamespace(), nodeIds -> this.m_serviceAccessor.getAlarmDao().getNodeAlarmSummariesIncludeAcknowledgedOnes(nodeIds)));
            }
            case SCRIPT_STATUS_PROVIDER: {
                return Optional.of(new GraphMLScriptVertexStatusProvider(rawTopologyProvider.getNamespace(), nodeIds -> this.m_serviceAccessor.getAlarmDao().getNodeAlarmSummariesIncludeAcknowledgedOnes(nodeIds), scriptEngineManager, this.m_serviceAccessor));
            }
            case PROPAGATE_STATUS_PROVIDER: {
                return Optional.of(new GraphMLPropagateVertexStatusProvider(rawTopologyProvider.getNamespace(), metaTopologyProvider, this.m_bundleContext));
            }
        }
        throw null;
    }

    private /* synthetic */ void lambda$updated$2(GraphMLMetaTopologyProvider metaTopologyProvider, String pid, ScriptEngineManager scriptEngineManager, GraphProvider it) {
        GraphMLTopologyProvider rawTopologyProvider = metaTopologyProvider.getGraphProvider(it.getNamespace());
        this.registerService(pid, EdgeStatusProvider.class, new GraphMLEdgeStatusProvider(rawTopologyProvider, scriptEngineManager, this.m_serviceAccessor));
        this.registerService(pid, SearchProvider.class, new GraphMLSearchProvider(rawTopologyProvider));
        this.buildStatusProvider(metaTopologyProvider, scriptEngineManager, rawTopologyProvider).ifPresent(statusProvider -> this.registerService(pid, StatusProvider.class, statusProvider));
    }
}

