/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLEdge;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.features.graphml.model.GraphMLNode;
import org.opennms.features.graphml.model.GraphMLReader;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbStrategy;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLMetaTopologyProvider
implements MetaTopologyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLTopologyProvider.class);
    private final GraphMLServiceAccessor m_serviceAccessor;
    private File graphMLFile;
    private final Map<String, GraphMLTopologyProvider> graphProvidersByNamespace = Maps.newLinkedHashMap();
    private final Map<VertexRef, List<VertexRef>> oppositeVertices = Maps.newLinkedHashMap();
    private BreadcrumbStrategy breadcrumbStrategy;

    public GraphMLMetaTopologyProvider(GraphMLServiceAccessor serviceAccessor) {
        this.m_serviceAccessor = Objects.requireNonNull(serviceAccessor);
    }

    private VertexRef getVertex(GraphMLNode node) {
        return this.graphProvidersByNamespace.values().stream().map(provider -> provider.getCurrentGraph().getVertex(provider.getNamespace(), node.getId())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getId() {
        return this.getGraphProviders().stream().sorted(Comparator.comparing(GraphProvider::getNamespace)).map(GraphProvider::getNamespace).collect(Collectors.joining(":"));
    }

    public void reload() throws IOException, InvalidGraphException {
        this.graphProvidersByNamespace.clear();
        this.oppositeVertices.clear();
        if (this.graphMLFile == null) {
            LOG.warn("No graph defined");
            return;
        }
        if (!this.graphMLFile.exists()) {
            LOG.warn("No graph found at location " + this.graphMLFile.toString());
            return;
        }
        try (FileInputStream input = new FileInputStream(this.graphMLFile);){
            GraphML graphML = GraphMLReader.read((InputStream)input);
            this.validate(graphML);
            for (GraphMLGraph eachGraph : graphML.getGraphs()) {
                GraphMLTopologyProvider topoProvider = new GraphMLTopologyProvider(eachGraph, this.m_serviceAccessor);
                this.graphProvidersByNamespace.put(topoProvider.getNamespace(), topoProvider);
            }
            for (GraphMLGraph eachGraph : graphML.getGraphs()) {
                for (GraphMLEdge eachEdge : eachGraph.getEdges()) {
                    VertexRef sourceVertex = this.getVertex(eachEdge.getSource());
                    VertexRef targetVertex = this.getVertex(eachEdge.getTarget());
                    if (sourceVertex.getNamespace().equals(targetVertex.getNamespace())) continue;
                    ArrayList opposites = this.oppositeVertices.get(sourceVertex);
                    if (opposites == null) {
                        opposites = Lists.newArrayList();
                        this.oppositeVertices.put(sourceVertex, opposites);
                    }
                    opposites.add(targetVertex);
                }
            }
            this.breadcrumbStrategy = GraphMLMetaTopologyProvider.getBreadcrumbStrategy(graphML);
        }
    }

    public GraphProvider getDefaultGraphProvider() {
        return (GraphProvider)Iterables.getFirst(this.graphProvidersByNamespace.values(), null);
    }

    public Collection<GraphProvider> getGraphProviders() {
        return Collections.unmodifiableCollection(this.graphProvidersByNamespace.values());
    }

    public Collection<VertexRef> getOppositeVertices(VertexRef vertexRef) {
        return this.oppositeVertices.getOrDefault(vertexRef, Collections.emptyList());
    }

    public GraphProvider getGraphProviderBy(String namespace) {
        return this.graphProvidersByNamespace.get(namespace);
    }

    public BreadcrumbStrategy getBreadcrumbStrategy() {
        return this.breadcrumbStrategy == null ? BreadcrumbStrategy.NONE : this.breadcrumbStrategy;
    }

    public void setTopologyLocation(String filename) {
        this.graphMLFile = filename != null ? new File(filename) : null;
    }

    private void validate(GraphML graphML) throws InvalidGraphException {
        HashSet<String> graphIds = new HashSet<String>();
        HashMap nodeIdsByNamespace = new HashMap();
        HashMap edgeIdsByNamespace = new HashMap();
        for (GraphMLGraph eachGraph : graphML.getGraphs()) {
            String ns = (String)eachGraph.getProperty("namespace");
            if (Strings.isNullOrEmpty((String)ns)) {
                throw new InvalidGraphException("No namespace defined on graph with id " + eachGraph.getId());
            }
            if (graphIds.contains(eachGraph.getId())) {
                throw new InvalidGraphException("There already exists a graph with id " + eachGraph.getId());
            }
            graphIds.add(eachGraph.getId());
            for (GraphMLNode eachNode : eachGraph.getNodes()) {
                HashSet<String> nodeIdsInNs = (HashSet<String>)nodeIdsByNamespace.get(ns);
                if (nodeIdsInNs == null) {
                    nodeIdsInNs = new HashSet<String>();
                    nodeIdsByNamespace.put(ns, nodeIdsInNs);
                }
                if (nodeIdsInNs.contains(eachNode.getId())) {
                    throw new InvalidGraphException("There already exists a node with id " + eachNode.getId() + " in namespace " + ns);
                }
                nodeIdsInNs.add(eachNode.getId());
            }
            for (GraphMLEdge eachEdge : eachGraph.getEdges()) {
                HashSet<String> edgeIdsInNs = (HashSet<String>)edgeIdsByNamespace.get(ns);
                if (edgeIdsInNs == null) {
                    edgeIdsInNs = new HashSet<String>();
                    edgeIdsByNamespace.put(ns, edgeIdsInNs);
                }
                if (edgeIdsInNs.contains(eachEdge.getId())) {
                    throw new InvalidGraphException("There already exists an edge with id " + eachEdge.getId() + " in namespace " + ns);
                }
                edgeIdsInNs.add(eachEdge.getId());
            }
        }
    }

    public GraphMLTopologyProvider getGraphProvider(String vertexNamespace) {
        return this.graphProvidersByNamespace.get(vertexNamespace);
    }

    private static BreadcrumbStrategy getBreadcrumbStrategy(GraphML graphML) {
        Objects.requireNonNull(graphML);
        return GraphMLMetaTopologyProvider.getBreadcrumbStrategy((String)graphML.getProperty("breadcrumb-strategy"));
    }

    static BreadcrumbStrategy getBreadcrumbStrategy(String property) {
        if (Strings.isNullOrEmpty((String)property)) {
            return null;
        }
        try {
            return BreadcrumbStrategy.valueOf((String)property.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("No breadcrumb-strategy found for value '{}'", (Object)property, (Object)ex);
            return null;
        }
    }
}

