/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.features.graphml.model.GraphMLNode;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.FocusStrategy;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.DefaultTopologyProviderInfo;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLEdge;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLMetaTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLVertex;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    protected static final String DEFAULT_DESCRIPTION = "This Topology Provider visualizes a predefined GraphML graph.";
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLTopologyProvider.class);
    private final GraphMLServiceAccessor m_serviceAccessor;
    private final GraphMLMetaTopologyProvider metaTopologyProvider;
    private final int defaultSzl;
    private final String preferredLayout;
    private final FocusStrategy focusStrategy;
    private final List<String> focusIds;
    private final VertexStatusProviderType vertexStatusProviderType;

    private static TopologyProviderInfo createTopologyProviderInfo(GraphMLGraph graph) {
        String name = (String)graph.getProperty("label", (Object)graph.getId());
        String description = (String)graph.getProperty("description", (Object)DEFAULT_DESCRIPTION);
        return new DefaultTopologyProviderInfo(name, description, null, true);
    }

    public GraphMLTopologyProvider(GraphMLMetaTopologyProvider metaTopologyProvider, GraphMLGraph graph, GraphMLServiceAccessor serviceAccessor) {
        super((String)graph.getProperty("namespace"));
        this.metaTopologyProvider = metaTopologyProvider;
        this.m_serviceAccessor = serviceAccessor;
        for (GraphMLNode graphMLNode : graph.getNodes()) {
            GraphMLVertex newVertex = new GraphMLVertex(this.getNamespace(), graphMLNode);
            this.setNodeIdForVertex(newVertex);
            this.addVertices(new Vertex[]{newVertex});
        }
        for (org.opennms.features.graphml.model.GraphMLEdge eachEdge : graph.getEdges()) {
            GraphMLVertex sourceVertex = (GraphMLVertex)this.getVertex(this.getNamespace(), eachEdge.getSource().getId());
            GraphMLVertex targetVertex = (GraphMLVertex)this.getVertex(this.getNamespace(), eachEdge.getTarget().getId());
            if (sourceVertex == null || targetVertex == null) continue;
            GraphMLEdge newEdge = new GraphMLEdge(this.getNamespace(), eachEdge, sourceVertex, targetVertex);
            this.addEdges(new Edge[]{newEdge});
        }
        this.setTopologyProviderInfo(GraphMLTopologyProvider.createTopologyProviderInfo(graph));
        this.defaultSzl = GraphMLTopologyProvider.getDefaultSzl(graph);
        this.focusStrategy = GraphMLTopologyProvider.getFocusStrategy(graph);
        this.focusIds = GraphMLTopologyProvider.getFocusIds(graph);
        this.preferredLayout = (String)graph.getProperty("preferred-layout");
        this.vertexStatusProviderType = GraphMLTopologyProvider.getVertexProviderTypeFromGraph(graph);
        if (this.focusStrategy != FocusStrategy.SPECIFIC && !this.focusIds.isEmpty()) {
            LOG.warn("Focus ids is defined, but strategy is {}. Did you mean to specify {}={}. Ignoring focusIds.", (Object)"focus-strategy", (Object)FocusStrategy.SPECIFIC.name());
        }
    }

    private void setNodeIdForVertex(GraphMLVertex vertex) {
        if (vertex == null) {
            return;
        }
        if (vertex.getNodeID() == null) {
            String foreignSource = (String)vertex.getProperties().get("foreignSource");
            String foreignId = (String)vertex.getProperties().get("foreignID");
            if (!Strings.isNullOrEmpty((String)foreignSource) && !Strings.isNullOrEmpty((String)foreignId)) {
                OnmsNode onmsNode = this.m_serviceAccessor.getNodeDao().findByForeignId(foreignSource, foreignId);
                if (onmsNode != null) {
                    vertex.setNodeID(onmsNode.getId());
                } else {
                    LOG.warn("No node found for the given foreignSource ({}) and foreignId ({}).", (Object)foreignSource, (Object)foreignId);
                }
            }
        }
    }

    private static FocusStrategy getFocusStrategy(GraphMLGraph graph) {
        String strategy = (String)graph.getProperty("focus-strategy");
        if (strategy != null) {
            return FocusStrategy.getStrategy((String)strategy, (FocusStrategy)FocusStrategy.FIRST);
        }
        return FocusStrategy.FIRST;
    }

    private static List<String> getFocusIds(GraphMLGraph graph) {
        String property = (String)graph.getProperty("focus-ids");
        if (property != null) {
            Object[] split = property.split(",");
            return Lists.newArrayList((Object[])split);
        }
        return Lists.newArrayList();
    }

    private static int getDefaultSzl(GraphMLGraph graph) {
        Integer szl = (Integer)graph.getProperty("semantic-zoom-level");
        if (szl != null) {
            return szl;
        }
        return 1;
    }

    public void refresh() {
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(this.defaultSzl).withPreferredLayout(this.preferredLayout).withCriteria(() -> {
            List focusCriteria = this.focusStrategy.getFocusCriteria((GraphProvider)this, this.focusIds.toArray(new String[this.focusIds.size()]));
            return Lists.newArrayList((Iterable)focusCriteria);
        });
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType contentType) {
        Set nodeIds = selectedVertices.stream().filter(eachVertex -> eachVertex.getNamespace().equals(this.getNamespace()) && eachVertex instanceof GraphMLVertex).map(eachVertex -> (GraphMLVertex)((Object)eachVertex)).filter(eachVertex -> eachVertex.getNodeID() != null).map(eachVertex -> eachVertex.getNodeID()).collect(Collectors.toSet());
        if (contentType == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (contentType == ContentType.Node) {
            return new SelectionChangedListener.IdSelection(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }

    public VertexStatusProviderType getVertexStatusProviderType() {
        return this.vertexStatusProviderType;
    }

    private static VertexStatusProviderType getVertexProviderTypeFromGraph(GraphMLGraph graph) {
        Object vertexStatusProviderType = graph.getProperty("vertex-status-provider", (Object)Boolean.FALSE);
        if (vertexStatusProviderType instanceof Boolean) {
            if (vertexStatusProviderType == Boolean.TRUE) {
                return VertexStatusProviderType.DEFAULT_STATUS_PROVIDER;
            }
            return VertexStatusProviderType.NO_STATUS_PROVIDER;
        }
        if (vertexStatusProviderType instanceof String) {
            if ("default".equalsIgnoreCase((String)vertexStatusProviderType)) {
                return VertexStatusProviderType.DEFAULT_STATUS_PROVIDER;
            }
            if ("script".equalsIgnoreCase((String)vertexStatusProviderType)) {
                return VertexStatusProviderType.SCRIPT_STATUS_PROVIDER;
            }
            if ("propagate".equalsIgnoreCase((String)vertexStatusProviderType)) {
                return VertexStatusProviderType.PROPAGATE_STATUS_PROVIDER;
            }
            LOG.warn("Unknown GraphML vertex status provider type: {}", vertexStatusProviderType);
            return VertexStatusProviderType.NO_STATUS_PROVIDER;
        }
        return VertexStatusProviderType.NO_STATUS_PROVIDER;
    }

    public static enum VertexStatusProviderType {
        NO_STATUS_PROVIDER,
        DEFAULT_STATUS_PROVIDER,
        SCRIPT_STATUS_PROVIDER,
        PROPAGATE_STATUS_PROVIDER;

    }
}

