/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.SimpleSearchProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLVertex;

public class GraphMLSearchProvider
extends SimpleSearchProvider {
    private final GraphMLTopologyProvider graphMLTopologyProvider;

    public GraphMLSearchProvider(GraphMLTopologyProvider graphMLTopologyProvider) {
        this.graphMLTopologyProvider = Objects.requireNonNull(graphMLTopologyProvider);
    }

    public boolean contributesTo(String namespace) {
        boolean contributes = super.contributesTo(namespace);
        if (!contributes && namespace.contains(":")) {
            String prefix = namespace.substring(0, namespace.indexOf(":"));
            return this.getSearchProviderNamespace().startsWith(prefix);
        }
        return contributes;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        Optional<GraphProvider> first;
        GraphContainer graphContainer = operationContext.getGraphContainer();
        DefaultVertexRef vertexRef = new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel());
        if (graphContainer.getBaseTopology().getVertex((VertexRef)vertexRef, new Criteria[0]) == null && (first = graphContainer.getMetaTopologyProvider().getGraphProviders().stream().filter(eachProvider -> eachProvider.getVertexNamespace().equals(searchResult.getNamespace())).findFirst()).isPresent() && first.get().getVertex((VertexRef)vertexRef, new Criteria[0]) != null) {
            graphContainer.selectTopologyProvider(first.get(), new GraphContainer.Callback[0]);
            graphContainer.clearCriteria();
        }
        super.onFocusSearchResult(searchResult, operationContext);
    }

    public String getSearchProviderNamespace() {
        return this.graphMLTopologyProvider.getVertexNamespace();
    }

    public List<? extends VertexRef> queryVertices(SearchQuery searchQuery, GraphContainer container) {
        ArrayList matchingVertices = new ArrayList();
        this.graphMLTopologyProvider.getVertices(new Criteria[0]).stream().map(v -> (GraphMLVertex)((Object)v)).filter(v -> GraphMLSearchProvider.matches(searchQuery, v)).sorted((v1, v2) -> v1.getId().compareTo(v2.getId())).forEach(v -> matchingVertices.add(v));
        return matchingVertices;
    }

    private static boolean matches(SearchQuery searchQuery, GraphMLVertex graphMLVertex) {
        String qs = searchQuery.getQueryString().toLowerCase();
        for (Object propValue : graphMLVertex.getProperties().values()) {
            String value = propValue != null ? propValue.toString() : "";
            if (!value.toLowerCase().contains(qs)) continue;
            return true;
        }
        return graphMLVertex.getId().toLowerCase().contains(qs);
    }
}

