/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.opennms.features.topology.api.info.MeasurementsWrapper;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLEdge;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLEdgeStatus;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLEdgeStatusProvider
implements EdgeStatusProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLEdgeStatusProvider.class);
    private final Path scriptPath;
    private final GraphMLTopologyProvider provider;
    private final ScriptEngineManager scriptEngineManager;
    private final GraphMLServiceAccessor serviceAccessor;

    public GraphMLEdgeStatusProvider(GraphMLTopologyProvider provider, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor, Path scriptPath) {
        this.provider = Objects.requireNonNull(provider);
        this.scriptEngineManager = Objects.requireNonNull(scriptEngineManager);
        this.serviceAccessor = Objects.requireNonNull(serviceAccessor);
        this.scriptPath = Objects.requireNonNull(scriptPath);
    }

    public GraphMLEdgeStatusProvider(GraphMLTopologyProvider provider, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor) {
        this(provider, scriptEngineManager, serviceAccessor, Paths.get(System.getProperty("opennms.home"), "etc", "graphml-edge-status"));
    }

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, Criteria[] criteria) {
        ArrayList scripts = Lists.newArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getScriptPath());){
            for (Path path : stream) {
                String extension = FilenameUtils.getExtension((String)path.toString());
                ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension(extension);
                if (scriptEngine == null) {
                    LOG.warn("No script engine found for extension '{}'", (Object)extension);
                    continue;
                }
                LOG.debug("Found script: path={}, extension={}, engine={}", new Object[]{path, extension, scriptEngine});
                Stream<String> lines = Files.lines(path, Charset.defaultCharset());
                Throwable throwable = null;
                try {
                    String source = lines.collect(Collectors.joining("\n"));
                    scripts.add(new StatusScript(scriptEngine, source));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lines == null) continue;
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lines.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to walk template directory: {}", (Object)this.getScriptPath());
            return Collections.emptyMap();
        }
        return (Map)this.serviceAccessor.getTransactionOperations().execute(transactionStatus -> edges.stream().filter(eachEdge -> eachEdge instanceof GraphMLEdge).map(edge -> (GraphMLEdge)((Object)((Object)edge))).map(edge -> new AbstractMap.SimpleEntry<GraphMLEdge, GraphMLEdgeStatus>((GraphMLEdge)((Object)((Object)edge)), this.computeEdgeStatus(scripts, (GraphMLEdge)((Object)((Object)edge))))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public String getNamespace() {
        return this.provider.getVertexNamespace();
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    private GraphMLEdgeStatus computeEdgeStatus(List<StatusScript> scripts, GraphMLEdge edge) {
        return scripts.stream().flatMap(script -> {
            SimpleBindings bindings = this.createBindings(edge);
            StringWriter writer = new StringWriter();
            SimpleScriptContext context = new SimpleScriptContext();
            context.setWriter(writer);
            context.setBindings(bindings, 200);
            try {
                LOG.debug("Executing script: {}", script);
                GraphMLEdgeStatus status = script.eval(context);
                if (status != null) {
                    Stream<GraphMLEdgeStatus> stream = Stream.of(status);
                    return stream;
                }
                Stream stream = Stream.empty();
                return stream;
            }
            catch (ScriptException e) {
                LOG.error("Failed to execute script: {}", (Throwable)e);
                Stream stream = Stream.empty();
                return stream;
            }
            finally {
                LOG.info(writer.toString());
            }
        }).reduce(GraphMLEdgeStatus::merge).orElse(null);
    }

    private SimpleBindings createBindings(GraphMLEdge edge) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("edge", (Object)edge);
        bindings.put("sourceNode", (Object)this.getNodeForEdgeVertexConnector(edge.getSource()));
        bindings.put("targetNode", (Object)this.getNodeForEdgeVertexConnector(edge.getTarget()));
        bindings.put("measurements", (Object)new MeasurementsWrapper(this.serviceAccessor.getMeasurementsService()));
        bindings.put("nodeDao", (Object)this.serviceAccessor.getNodeDao());
        bindings.put("snmpInterfaceDao", (Object)this.serviceAccessor.getSnmpInterfaceDao());
        return bindings;
    }

    private OnmsNode getNodeForEdgeVertexConnector(SimpleConnector simpleConnector) {
        AbstractVertex abstractVertex;
        if (simpleConnector != null && simpleConnector.getVertex() instanceof AbstractVertex && (abstractVertex = (AbstractVertex)simpleConnector.getVertex()).getNodeID() != null) {
            return (OnmsNode)this.serviceAccessor.getNodeDao().get((Serializable)abstractVertex.getNodeID());
        }
        return null;
    }

    private class StatusScript {
        private final ScriptEngine engine;
        private final String source;
        private Optional<CompiledScript> compiledScript = null;

        private StatusScript(ScriptEngine engine, String source) {
            this.engine = Objects.requireNonNull(engine);
            this.source = Objects.requireNonNull(source);
        }

        public GraphMLEdgeStatus eval(ScriptContext context) throws ScriptException {
            if (this.compiledScript == null) {
                this.compiledScript = this.engine instanceof Compilable ? Optional.of(((Compilable)((Object)this.engine)).compile(this.source)) : Optional.empty();
            }
            if (this.compiledScript.isPresent()) {
                return (GraphMLEdgeStatus)this.compiledScript.get().eval(context);
            }
            return (GraphMLEdgeStatus)this.engine.eval(this.source, context);
        }
    }
}

