/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.status.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmStatusProvider
implements StatusProvider {
    private AlarmDao m_alarmDao;
    private VertexProvider m_vertexProvider;

    public VertexProvider getVertexProvider() {
        return this.m_vertexProvider;
    }

    public void setVertexProvider(VertexProvider vertexProvider) {
        this.m_vertexProvider = vertexProvider;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public Status getStatusForVertex(VertexRef vertexRef) {
        if (vertexRef.getNamespace().equals("nodes")) {
            if (this.isGroup(vertexRef) && this.getVertexProvider() != null) {
                return this.getStatusForGroup(vertexRef);
            }
            try {
                int nodeId = Integer.valueOf(vertexRef.getId());
                CriteriaBuilder builder = new CriteriaBuilder(OnmsAlarm.class);
                builder.alias("node", "node");
                builder.eq("node.id", (Object)nodeId);
                builder.ge("severity", (Object)OnmsSeverity.WARNING);
                builder.orderBy("severity").desc();
                builder.limit(Integer.valueOf(1));
                return this.getStatusForCriteria(builder);
            }
            catch (NumberFormatException e) {
                return this.createIndeterminateStatus();
            }
        }
        return this.createIndeterminateStatus();
    }

    private Status getStatusForCriteria(CriteriaBuilder builder) {
        List alarms = this.m_alarmDao.findMatching(builder.toCriteria());
        if (alarms != null && alarms.size() == 1) {
            OnmsAlarm alarm = (OnmsAlarm)alarms.get(0);
            OnmsSeverity severity = alarm.getSeverity();
            AlarmStatus vertexStatus = new AlarmStatus(severity.getId(), severity.getLabel());
            return vertexStatus;
        }
        return this.createIndeterminateStatus();
    }

    private Status getStatusForGroup(VertexRef groupRef) {
        List vertices = this.getVertexProvider().getChildren(groupRef);
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (Vertex vertex : vertices) {
            if (vertex.isGroup()) continue;
            nodeIds.add(vertex.getNodeID());
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAlarm.class);
        builder.alias("node", "node");
        builder.in("node.id", nodeIds);
        builder.ge("severity", (Object)OnmsSeverity.WARNING);
        builder.orderBy("severity").desc();
        builder.limit(Integer.valueOf(1));
        return this.getStatusForCriteria(builder);
    }

    private boolean isGroup(VertexRef vertexRef) {
        if (vertexRef instanceof Vertex) {
            return ((Vertex)vertexRef).isGroup();
        }
        return false;
    }

    private Status createIndeterminateStatus() {
        return new AlarmStatus(OnmsSeverity.INDETERMINATE.getId(), OnmsSeverity.INDETERMINATE.getLabel());
    }

    public Collection<Status> getStatusForVertices(Collection<VertexRef> vertices) {
        ArrayList<Status> verticesStatus = new ArrayList<Status>();
        for (VertexRef vert : vertices) {
            verticesStatus.add(this.getStatusForVertex(vert));
        }
        return verticesStatus;
    }

    public String getNamespace() {
        return "node-alarm-status";
    }

    public class AlarmStatus
    implements Status {
        private int m_statusId;
        private String m_label;

        public AlarmStatus(int id, String label) {
            this.m_statusId = id;
            this.m_label = label;
        }

        public String computeStatus() {
            return this.m_label.toLowerCase();
        }
    }
}

