/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.SelectionManager;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSServiceContainer;
import org.opennms.features.topology.plugins.ncs.internal.NCSCriteriaServiceManager;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;

public class NCSSearchProvider
extends AbstractSearchProvider
implements SearchProvider {
    private static final String NAMESPACE = "ncs";
    private NCSComponentRepository m_ncsComponentRepository;
    private NCSEdgeProvider m_ncsEdgeProvider;
    private NCSCriteriaServiceManager m_serviceManager;
    NCSServiceContainer m_container;

    public void setNcsComponentRepository(NCSComponentRepository ncsComponentRepository) {
        this.m_ncsComponentRepository = ncsComponentRepository;
        this.m_container = new NCSServiceContainer(this.m_ncsComponentRepository);
    }

    protected static void selectVerticesForEdge(NCSEdgeProvider provider, Criteria criteria, SelectionManager selectionManager) {
        selectionManager.setSelectedVertexRefs(NCSSearchProvider.getVertexRefsForEdges(provider, criteria));
    }

    protected static void deselectVerticesForEdge(NCSEdgeProvider provider, Criteria criteria, SelectionManager selectionManager) {
        selectionManager.deselectVertexRefs(NCSSearchProvider.getVertexRefsForEdges(provider, criteria));
    }

    public static Set<VertexRef> getVertexRefsForEdges(NCSEdgeProvider provider, Criteria criteria) {
        TreeSet<VertexRef> vertexRefs = new TreeSet<VertexRef>((Comparator<VertexRef>)new RefComparator());
        List<Edge> edges = provider.getEdges(criteria);
        for (Edge ncsEdge : edges) {
            vertexRefs.add(ncsEdge.getSource().getVertex());
            vertexRefs.add(ncsEdge.getTarget().getVertex());
        }
        return vertexRefs;
    }

    public void setNcsEdgeProvider(NCSEdgeProvider ncsEdgeProvider) {
        this.m_ncsEdgeProvider = ncsEdgeProvider;
    }

    public void setNcsCriteriaServiceManager(NCSCriteriaServiceManager manager) {
        this.m_serviceManager = manager;
    }

    public String getSearchProviderNamespace() {
        return NAMESPACE;
    }

    public boolean contributesTo(String namespace) {
        return "nodes".equals(namespace);
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        List components = this.m_ncsComponentRepository.findByType("Service");
        for (NCSComponent component : components) {
            if (!searchQuery.matches(component.getName())) continue;
            searchResults.add(new SearchResult(NAMESPACE, String.valueOf(component.getId()), component.getName(), searchQuery.getQueryString()));
        }
        return searchResults;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(Long.parseLong(searchResult.getId())));
        if (this.m_serviceManager.isCriteriaRegistered(NAMESPACE, operationContext.getGraphContainer().getSessionId())) {
            this.m_serviceManager.unregisterCriteria(NAMESPACE, operationContext.getGraphContainer().getSessionId());
        }
        this.m_serviceManager.registerCriteria(criteria, operationContext.getGraphContainer().getSessionId());
        NCSSearchProvider.selectVerticesForEdge(this.m_ncsEdgeProvider, criteria, operationContext.getGraphContainer().getSelectionManager());
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        if (this.m_serviceManager.isCriteriaRegistered(NAMESPACE, operationContext.getGraphContainer().getSessionId())) {
            this.m_serviceManager.unregisterCriteria(NAMESPACE, operationContext.getGraphContainer().getSessionId());
        }
    }

    public boolean supportsPrefix(String searchPrefix) {
        return NCSSearchProvider.supportsPrefix((String)"ncs=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(Long.parseLong(searchResult.getId())));
        return NCSSearchProvider.getVertexRefsForEdges(this.m_ncsEdgeProvider, criteria);
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(Long.parseLong(searchResult.getId())));
        container.addCriteria((Criteria)new NCSHopCriteria(searchResult.getId(), new HashSet<VertexRef>(NCSSearchProvider.getVertexRefsForEdges(this.m_ncsEdgeProvider, criteria)), searchResult.getLabel()));
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(Long.parseLong(searchResult.getId())));
        container.removeCriteria((Criteria)new NCSHopCriteria(searchResult.getId(), new HashSet<VertexRef>(NCSSearchProvider.getVertexRefsForEdges(this.m_ncsEdgeProvider, criteria)), searchResult.getLabel()));
        if (this.m_serviceManager.isCriteriaRegistered(NAMESPACE, container.getSessionId())) {
            this.m_serviceManager.unregisterCriteria(NAMESPACE, container.getSessionId());
        }
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(Long.parseLong(searchResult.getId())));
        if (this.m_serviceManager.isCriteriaRegistered(NAMESPACE, graphContainer.getSessionId())) {
            this.m_serviceManager.unregisterCriteria(NAMESPACE, graphContainer.getSessionId());
        }
        this.m_serviceManager.registerCriteria(criteria, graphContainer.getSessionId());
    }

    public static class NCSHopCriteria
    extends VertexHopGraphProvider.VertexHopCriteria {
        private final Set<VertexRef> m_vertices;

        public NCSHopCriteria(String id, Set<VertexRef> vertexRefs, String label) {
            super(label);
            this.setId(id);
            this.m_vertices = vertexRefs;
        }

        public Set<VertexRef> getVertices() {
            return this.m_vertices;
        }

        public String getNamespace() {
            return NCSSearchProvider.NAMESPACE;
        }

        public int hashCode() {
            return ((Object)this.m_vertices).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NCSHopCriteria) {
                NCSHopCriteria c = (NCSHopCriteria)((Object)obj);
                return ((Object)c.m_vertices).equals(this.m_vertices);
            }
            return false;
        }
    }
}

