/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.HistoryOperation;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSSearchProvider;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.springframework.util.StringUtils;

public class NCSHopCriteriaHistoryOperation
implements HistoryOperation {
    private static final String DELIMITER = ",";
    private NCSComponentRepository m_ncsComponentRepository;
    private NCSEdgeProvider m_ncsEdgeProvider;

    public void setNcsComponentRepository(NCSComponentRepository ncsComponentRepository) {
        this.m_ncsComponentRepository = ncsComponentRepository;
    }

    public void setNcsEdgeProvider(NCSEdgeProvider ncsEdgeProvider) {
        this.m_ncsEdgeProvider = ncsEdgeProvider;
    }

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
        Set oldCriteria = Criteria.getCriteriaForGraphContainer((GraphContainer)container, NCSSearchProvider.NCSHopCriteria.class);
        for (NCSSearchProvider.NCSHopCriteria criterium : oldCriteria) {
            container.removeCriteria((Criteria)criterium);
        }
        String setting = settings.get(this.getClass().getName());
        if (setting != null && setting.length() > 0) {
            for (String idString : setting.split(DELIMITER)) {
                Long id = Long.parseLong(idString);
                Criteria criteria = NCSEdgeProvider.createCriteria(Collections.singletonList(id));
                container.addCriteria((Criteria)new NCSSearchProvider.NCSHopCriteria(idString, NCSSearchProvider.getVertexRefsForEdges(this.m_ncsEdgeProvider, criteria), this.m_ncsComponentRepository.get(id).getName()));
            }
        }
    }

    public Map<String, String> createHistory(GraphContainer graphContainer) {
        Set criteria = Criteria.getCriteriaForGraphContainer((GraphContainer)graphContainer, NCSSearchProvider.NCSHopCriteria.class);
        if (criteria.size() > 0) {
            TreeSet<String> retval = new TreeSet<String>();
            for (NCSSearchProvider.NCSHopCriteria criterium : criteria) {
                retval.add(criterium.getId());
            }
            return Collections.singletonMap(this.getClass().getName(), StringUtils.collectionToDelimitedString(retval, (String)DELIMITER));
        }
        return Collections.emptyMap();
    }
}

