/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSPathEdgeProvider;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NCSServicePath {
    private NCSComponentRepository m_dao;
    private NodeDao m_nodeDao;
    private String m_nodeForeignSource;
    private LinkedList<NCSEdgeProvider.NCSVertex> m_vertices = new LinkedList();
    private String m_serviceForeignSource;
    private String m_deviceAForeignID;
    private String m_deviceZForeignID;
    private String m_serviceName;
    private int m_statusCode;

    public NCSServicePath(Node data, NCSComponentRepository dao, NodeDao nodeDao, String nodeForeignSource, String serviceForeignSource, String deviceAID, String deviceZID, String serviceName) {
        this.m_dao = dao;
        this.m_nodeDao = nodeDao;
        this.m_nodeForeignSource = nodeForeignSource;
        this.m_serviceForeignSource = serviceForeignSource;
        this.m_deviceAForeignID = deviceAID;
        this.m_deviceZForeignID = deviceZID;
        this.m_serviceName = serviceName;
        this.setStatusCode(data);
        this.m_vertices.add(this.getVertexRefForForeignId(this.m_deviceAForeignID, this.m_nodeForeignSource));
        NodeList childNodes = this.getServicePath(data);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals("LSPPath")) continue;
            this.parsePath(item);
        }
        this.m_vertices.add(this.getVertexRefForForeignId(this.m_deviceZForeignID, this.m_nodeForeignSource));
    }

    private NodeList getServicePath(Node data) {
        NodeList servicePath = data.getOwnerDocument().getElementsByTagName("ServicePath");
        return servicePath.item(0).getChildNodes();
    }

    private void setStatusCode(Node data) {
        NodeList childNodes = data.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals("Status")) continue;
            Node firstChild = item.getFirstChild();
            String nodeValue = firstChild.getFirstChild().getNodeValue();
            this.m_statusCode = Integer.valueOf(nodeValue);
        }
    }

    public int getStatusCode() {
        return this.m_statusCode;
    }

    private void parsePath(Node item) {
        NodeList lspNode = item.getChildNodes();
        for (int i = 0; i < lspNode.getLength(); ++i) {
            NCSEdgeProvider.NCSVertex vertex;
            String nodeForeignId;
            Node node = lspNode.item(i);
            if (!node.getNodeName().equals("LSPNode") || this.m_deviceAForeignID.equals(nodeForeignId = node.getLastChild().getLastChild().getTextContent()) || this.m_deviceZForeignID.equals(nodeForeignId) || (vertex = this.getVertexRefForForeignId(nodeForeignId, this.m_nodeForeignSource)) == null) continue;
            this.m_vertices.add(vertex);
        }
    }

    private NCSEdgeProvider.NCSVertex getVertexRefForForeignId(String nodeForeignId, String nodeForeignSource) {
        OnmsNode node = this.m_nodeDao.findByForeignId(nodeForeignSource, nodeForeignId);
        if (node != null) {
            NCSEdgeProvider.NCSVertex vertex = new NCSEdgeProvider.NCSVertex(String.valueOf(node.getId()), node.getLabel());
            return vertex;
        }
        return null;
    }

    public Collection<NCSEdgeProvider.NCSVertex> getVertices() {
        return this.m_vertices;
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        if (this.m_vertices.size() >= 2) {
            String deviceA = this.m_vertices.get(0).getLabel();
            String deviceZ = this.m_vertices.get(this.m_vertices.size() - 1).getLabel();
            ListIterator iterator = this.m_vertices.listIterator();
            while (iterator.hasNext()) {
                NCSEdgeProvider.NCSVertex sourceRef = (NCSEdgeProvider.NCSVertex)((Object)iterator.next());
                if (!iterator.hasNext()) continue;
                NCSEdgeProvider.NCSVertex targetRef = this.m_vertices.get(iterator.nextIndex());
                NCSPathEdgeProvider.NCSPathEdge ncsPathEdge = new NCSPathEdgeProvider.NCSPathEdge(this.m_serviceName, deviceA, deviceZ, sourceRef, targetRef);
                ncsPathEdge.setStyleName("ncs edge direct");
                edges.add((Edge)ncsPathEdge);
            }
        }
        return edges;
    }
}

