/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;

public class EdgeProviderMapImpl
implements EdgeProvider {
    private Map<String, Edge> m_edges = new HashMap<String, Edge>();
    final Set<EdgeListener> m_listeners = new CopyOnWriteArraySet<EdgeListener>();

    public void addEdgeListener(EdgeListener edgeListener) {
        this.m_listeners.add(edgeListener);
    }

    private Edge getEdge(String id) {
        return this.m_edges.get(id);
    }

    public Edge getEdge(String namespace, String id) {
        return this.getEdge(id);
    }

    public Edge getEdge(EdgeRef reference) {
        return this.getEdge(reference.getId());
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        ArrayList<Edge> retval = new ArrayList<Edge>();
        for (EdgeRef edgeRef : references) {
            Edge edge = this.getEdge(edgeRef);
            if (edge == null) continue;
            retval.add(edge);
        }
        return Collections.unmodifiableList(retval);
    }

    public String getEdgeNamespace() {
        return "ncs";
    }

    public boolean contributesTo(String namespace) {
        return "nodes".equals(namespace);
    }

    public void removeEdgeListener(EdgeListener vertexListener) {
        throw new UnsupportedOperationException();
    }

    public List<Edge> getEdges(Criteria ... criteria) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : this.m_edges.values()) {
            edges.add(edge.clone());
        }
        return Collections.unmodifiableList(edges);
    }

    public void clearEdges() {
        ArrayList<Edge> all = new ArrayList<Edge>(this.m_edges.size());
        all.addAll(this.getEdges(new Criteria[0]));
        this.m_edges.clear();
        this.fireEdgesRemoved(all);
    }

    private void fireEdgesRemoved(List<Edge> edges) {
        ArrayList<String> ids = new ArrayList<String>(edges.size());
        for (Edge e : edges) {
            ids.add(e.getId());
        }
        for (EdgeListener listener : this.m_listeners) {
            listener.edgeSetChanged((EdgeProvider)this, null, null, ids);
        }
    }
}

