/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opennms.features.topology.api.support.HierarchicalBeanContainer;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;

public class NCSServiceContainer
extends HierarchicalBeanContainer<Long, NCSComponent> {
    private static final long serialVersionUID = 3245953234720320852L;
    private final NCSComponentRepository m_dao;

    public NCSServiceContainer(NCSComponentRepository dao) {
        super(NCSComponent.class);
        this.m_dao = dao;
        this.setBeanIdProperty("id");
        this.addAll(this.m_dao.findByType("Service"));
        this.addAll(this.m_dao.findByType("ServiceElement"));
    }

    public boolean areChildrenAllowed(Object itemId) {
        Long id = (Long)itemId;
        NCSComponent component = this.m_dao.load(id);
        return "Service".equals(component.getType());
    }

    public Collection<Long> getChildren(Object itemId) {
        Long id = (Long)itemId;
        NCSComponent component = this.m_dao.load(id);
        ArrayList<Long> retval = new ArrayList<Long>();
        for (NCSComponent sub : component.getSubcomponents()) {
            if (!"ServiceElement".equals(component.getType())) continue;
            retval.add(sub.getId());
        }
        return retval;
    }

    public Long getParent(Object itemId) {
        Long id = (Long)itemId;
        NCSComponent component = this.m_dao.load(id);
        return ((NCSComponent)component.getParentComponents().iterator().next()).getId();
    }

    public Collection<Long> rootItemIds() {
        ArrayList<Long> retval = new ArrayList<Long>();
        for (NCSComponent sub : this.m_dao.findByType("Service")) {
            retval.add(sub.getId());
        }
        return retval;
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot setChildredAllowed() on NCSComponent type");
    }

    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        Long id = (Long)itemId;
        Long parentId = (Long)newParentId;
        NCSComponent component = this.m_dao.load(id);
        HashSet<NCSComponent> parent = new HashSet<NCSComponent>();
        parent.add(this.m_dao.load(parentId));
        component.setParentComponents(parent);
        return true;
    }
}

