/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.slf4j.LoggerFactory;

public class NCSEdgeProvider
implements EdgeProvider {
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private NCSComponentRepository m_dao;
    private NodeDao m_nodeDao;

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public NCSComponentRepository getNcsComponentRepository() {
        return this.m_dao;
    }

    public void setNcsComponentRepository(NCSComponentRepository dao) {
        this.m_dao = dao;
    }

    public void addEdgeListener(EdgeListener vertexListener) {
    }

    public Edge getEdge(String namespace, String id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Edge getEdge(EdgeRef reference) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Edge> getEdges(Criteria criteria) {
        ArrayList<Edge> retval = new ArrayList<Edge>();
        NCSServiceCriteria crit = (NCSServiceCriteria)criteria;
        for (Long id : crit) {
            NCSComponent service = this.m_dao.get(id);
            if (service == null) {
                LoggerFactory.getLogger(this.getClass()).warn("NCSComponent not found for ID {}", (Object)id);
                continue;
            }
            NCSComponent[] subs = service.getSubcomponents().toArray(new NCSComponent[0]);
            for (int i = 0; i < subs.length; ++i) {
                for (int j = i + 1; j < subs.length; ++j) {
                    String foreignSource = null;
                    String foreignId = null;
                    OnmsNode sourceNode = null;
                    OnmsNode targetNode = null;
                    NCSComponent.NodeIdentification ident = subs[i].getNodeIdentification();
                    String sourceLabel = subs[i].getName();
                    if (ident != null) {
                        foreignSource = ident.getForeignSource();
                        sourceNode = this.m_nodeDao.findByForeignId(foreignSource, foreignId = ident.getForeignId());
                        if (sourceNode == null) continue;
                        if (sourceLabel == null) {
                            sourceLabel = sourceNode.getLabel();
                        }
                    }
                    ident = subs[j].getNodeIdentification();
                    String targetLabel = subs[j].getName();
                    if (ident != null) {
                        foreignSource = ident.getForeignSource();
                        targetNode = this.m_nodeDao.findByForeignId(foreignSource, foreignId = ident.getForeignId());
                        if (targetNode == null) continue;
                        if (targetLabel == null) {
                            targetLabel = targetNode.getLabel();
                        }
                    }
                    retval.add((Edge)new NCSEdge(service.getName(), new NCSVertex(String.valueOf(sourceNode.getId()), sourceLabel), new NCSVertex(String.valueOf(targetNode.getId()), targetLabel)));
                }
            }
        }
        return retval;
    }

    public List<Edge> getEdges() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getEdgeNamespace() {
        return "ncs";
    }

    public boolean contributesTo(String namespace) {
        return "nodes".equals(namespace);
    }

    public void removeEdgeListener(EdgeListener vertexListener) {
    }

    public boolean matches(EdgeRef edgeRef, Criteria criteria) {
        throw new UnsupportedOperationException("EdgeProvider.matches is not yet implemented.");
    }

    public static Criteria createCriteria(Collection<Long> selectedIds) {
        return new NCSServiceCriteria(selectedIds);
    }

    public void clearEdges() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static class NCSServiceCriteria
    extends ArrayList<Long>
    implements Criteria {
        private static final long serialVersionUID = 5833460704861282509L;

        public NCSServiceCriteria(Collection<Long> serviceIds) {
            super(serviceIds);
        }

        public String getNamespace() {
            return "ncs";
        }

        public Criteria.ElementType getType() {
            return Criteria.ElementType.EDGE;
        }
    }

    public static class NCSVertex
    extends AbstractVertex {
        public NCSVertex(String id, String label) {
            super("nodes", id);
            this.setLabel(label);
        }
    }

    public static class NCSEdge
    extends AbstractEdge {
        private final String m_serviceName;

        public NCSEdge(String serviceName, NCSVertex source, NCSVertex target) {
            super("ncs", source.getId() + ":::" + target.getId(), (Vertex)source, (Vertex)target);
            this.m_serviceName = serviceName;
            this.setStyleName("ncs edge");
        }

        public String getTooltipText() {
            StringBuffer toolTip = new StringBuffer();
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Service: " + this.m_serviceName);
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Source: " + this.getSource().getVertex().getLabel());
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Target: " + this.getTarget().getVertex().getLabel());
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            return toolTip.toString();
        }

        public Item getItem() {
            return new BeanItem((Object)this);
        }
    }
}

