/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;
import java.util.Collection;
import org.opennms.features.topology.api.IViewContribution;
import org.opennms.features.topology.api.WidgetContext;
import org.opennms.features.topology.api.support.FilterableHierarchicalContainer;
import org.opennms.features.topology.api.support.HierarchicalBeanContainer;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSServiceContainer;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;

public class NCSViewContribution
implements IViewContribution {
    private NCSComponentRepository m_ncsComponentRepository;

    public void setNcsComponentRepository(NCSComponentRepository ncsComponentRepository) {
        this.m_ncsComponentRepository = ncsComponentRepository;
    }

    public Component getView(final WidgetContext widgetContext) {
        Tree tree = new Tree("Services", (Container)new FilterableHierarchicalContainer((HierarchicalBeanContainer)new NCSServiceContainer(this.m_ncsComponentRepository)));
        tree.setMultiSelect(true);
        tree.setImmediate(true);
        tree.setItemCaptionMode(6);
        tree.setItemCaptionPropertyId((Object)"name");
        tree.addListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                Collection selectedIds = (Collection)event.getProperty().getValue();
                Criteria criteria = NCSEdgeProvider.createCriteria(selectedIds);
                widgetContext.getGraphContainer().setCriteria(criteria);
            }
        });
        return tree;
    }

    public String getTitle() {
        return "Services";
    }

    public Resource getIcon() {
        return null;
    }
}

