/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.osgi.EventConsumer;

public class NodeDaoContainer
extends OnmsDaoContainer<OnmsNode, Integer> {
    private static final long serialVersionUID = -5697472655705494537L;

    public NodeDaoContainer(NodeDao dao) {
        super(OnmsNode.class, dao);
        this.addBeanToHibernatePropertyMapping("primaryInterface", "ipInterfaces.ipAddress");
    }

    @Override
    protected Integer getId(OnmsNode bean) {
        return bean == null ? null : bean.getId();
    }

    @Override
    protected void addAdditionalCriteriaOptions(Criteria criteria, OnmsDaoContainer.Page page, boolean doOrder) {
        if (!doOrder) {
            return;
        }
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN, (Restriction)new EqRestriction("ipInterfaces.isSnmpPrimary", (Object)PrimaryType.PRIMARY))));
    }

    @Override
    protected List<OnmsNode> getItemsForCache(OnmsDao<OnmsNode, Integer> dao, OnmsDaoContainer.Page page) {
        List<OnmsNode> itemsForCache = super.getItemsForCache(dao, page);
        return new ArrayList<OnmsNode>(new LinkedHashSet<OnmsNode>(itemsForCache));
    }

    @Override
    protected void doItemAddedCallBack(int rowNumber, Integer id, OnmsNode eachBean) {
        eachBean.getPrimaryInterface();
    }

    @EventConsumer
    public void verticesUpdated(VerticesUpdateManager.VerticesUpdateEvent event) {
        ArrayList<Restriction> newRestrictions = new ArrayList<Restriction>();
        List<Integer> nodeIds = this.extractNodeIds(event.getVertexRefs());
        if (nodeIds.size() > 0) {
            newRestrictions.add((Restriction)Restrictions.in((String)"id", nodeIds));
        }
        if (!this.getRestrictions().equals(newRestrictions)) {
            this.setRestrictions(newRestrictions);
            this.getCache().reload(this.getPage());
            this.fireItemSetChangedEvent();
        }
    }
}

