/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.topo.GroupRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.LoggerFactory;

abstract class NodeIdFocusToRestrictionsConverter {
    NodeIdFocusToRestrictionsConverter() {
    }

    public List<Restriction> getRestrictions(Collection<VertexRef> vertices) {
        if (vertices.isEmpty()) {
            ArrayList<Integer> nodeIdList = new ArrayList<Integer>();
            nodeIdList.add(-1);
            return this.getRestrictions((List<Integer>)nodeIdList);
        }
        return this.getRestrictions(this.extractNodeIds(vertices));
    }

    protected abstract Restriction createRestriction(Integer var1);

    private List<Restriction> getRestrictions(List<Integer> nodeIdFocus) {
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        restrictions.add((Restriction)this.getAnyRestriction(nodeIdFocus));
        return restrictions;
    }

    private AnyRestriction getAnyRestriction(List<Integer> nodeIdFocus) {
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        for (Integer eachNodeId : nodeIdFocus) {
            restrictions.add(this.createRestriction(eachNodeId));
        }
        return new AnyRestriction(restrictions.toArray(new Restriction[restrictions.size()]));
    }

    private List<Integer> extractNodeIds(Collection<VertexRef> vertices) {
        ArrayList<Integer> nodeIdList = new ArrayList<Integer>();
        for (VertexRef eachRef : vertices) {
            if ("nodes".equals(eachRef.getNamespace())) {
                try {
                    nodeIdList.add(Integer.valueOf(eachRef.getId()));
                }
                catch (NumberFormatException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot filter nodes with ID: {}", (Object)eachRef.getId());
                }
                continue;
            }
            if (!((Vertex)eachRef).isGroup() || !"category".equals(eachRef.getNamespace())) continue;
            try {
                GroupRef group = (GroupRef)eachRef;
                nodeIdList.addAll(Collections2.transform((Collection)group.getChildren(), (Function)new Function<VertexRef, Integer>(){

                    public Integer apply(VertexRef input) {
                        return Integer.valueOf(input.getId());
                    }
                }));
            }
            catch (ClassCastException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Cannot filter category with ID: {} children: {}", (Object)eachRef.getId(), (Object)((GroupRef)eachRef).getChildren());
            }
        }
        return nodeIdList;
    }
}

