/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.features.topology.api.SelectionContext;
import org.opennms.features.topology.api.SelectionListener;
import org.opennms.features.topology.api.SelectionNotifier;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.features.topology.plugins.browsers.TableAware;

public class SelectionAwareTable
extends Table
implements SelectionListener,
SelectionNotifier {
    private static final long serialVersionUID = 2761774077365441249L;
    private final OnmsDaoContainer<?, ? extends Serializable> m_container;
    private final Set<SelectionNotifier> m_selectionNotifiers = new CopyOnWriteArraySet<SelectionNotifier>();

    public SelectionAwareTable(String caption, OnmsDaoContainer container) {
        super(caption, (Container)container);
        this.m_container = container;
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.refreshRowCache();
        super.containerItemSetChange(event);
    }

    public void selectionChanged(SelectionContext selectionManager) {
        this.m_container.selectionChanged(selectionManager);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_container.addSelectionListener(listener);
        for (SelectionNotifier notifier : this.m_selectionNotifiers) {
            notifier.addSelectionListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_container.removeSelectionListener(listener);
        for (SelectionNotifier notifier : this.m_selectionNotifiers) {
            notifier.removeSelectionListener(listener);
        }
    }

    public void setSelectionListeners(Set<SelectionListener> listeners) {
        this.m_container.setSelectionListeners(listeners);
        for (SelectionNotifier notifier : this.m_selectionNotifiers) {
            notifier.setSelectionListeners(listeners);
        }
    }

    public void setColumnGenerators(Map generators) {
        for (Object key : generators.keySet()) {
            super.addGeneratedColumn(key, (Table.ColumnGenerator)generators.get(key));
            try {
                this.m_selectionNotifiers.add((SelectionNotifier)generators.get(key));
            }
            catch (ClassCastException e) {}
        }
    }

    public void setCellStyleGenerator(Table.CellStyleGenerator generator) {
        try {
            ((TableAware)generator).setTable(this);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        super.setCellStyleGenerator(generator);
    }
}

