/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opennms.features.topology.api.DefaultSelectionContext;
import org.opennms.features.topology.api.SelectionContext;
import org.opennms.features.topology.api.SelectionListener;
import org.opennms.features.topology.api.SelectionNotifier;
import org.opennms.features.topology.api.topo.AbstractVertexRef;
import org.opennms.features.topology.plugins.browsers.ToStringColumnGenerator;

public class NodeSelectionLinkGenerator
implements Table.ColumnGenerator,
SelectionNotifier {
    private static final long serialVersionUID = -1072007643387089006L;
    private final String m_nodeIdProperty;
    private final Table.ColumnGenerator m_generator;
    private Collection<SelectionListener> m_selectionListeners = new HashSet<SelectionListener>();

    public NodeSelectionLinkGenerator(String nodeIdProperty) {
        this(nodeIdProperty, new ToStringColumnGenerator());
    }

    public NodeSelectionLinkGenerator(String nodeIdProperty, Table.ColumnGenerator generator) {
        this.m_nodeIdProperty = nodeIdProperty;
        this.m_generator = generator;
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        final Property nodeIdProperty = source.getContainerProperty(itemId, (Object)this.m_nodeIdProperty);
        Object cellValue = this.m_generator.generateCell(source, itemId, columnId);
        if (cellValue == null) {
            return null;
        }
        if (nodeIdProperty.getValue() == null) {
            return cellValue;
        }
        Button button = new Button((String)cellValue);
        button.setStyleName("link");
        button.setDescription(nodeIdProperty.getValue().toString());
        button.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                DefaultSelectionContext context = new DefaultSelectionContext();
                context.selectVertexRefs(Collections.singleton(new AbstractVertexRef("nodes", nodeIdProperty.getValue().toString(), nodeIdProperty.getValue().toString())));
                NodeSelectionLinkGenerator.this.fireSelectionChangedEvent((SelectionContext)context);
            }
        });
        return button;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.add(listener);
    }

    public void setSelectionListeners(Set<SelectionListener> listeners) {
        this.m_selectionListeners = listeners;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.remove(listener);
    }

    protected void fireSelectionChangedEvent(SelectionContext context) {
        for (SelectionListener listener : this.m_selectionListeners) {
            listener.selectionChanged(context);
        }
    }
}

