/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.data.util.BeanItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.SelectionContext;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;

public class NodeDaoContainer
extends OnmsDaoContainer<OnmsNode, Integer> {
    private static final long serialVersionUID = -5697472655705494537L;
    private Map<Object, Class<?>> m_properties;

    public NodeDaoContainer(NodeDao dao) {
        super(dao);
    }

    @Override
    public Class<OnmsNode> getItemClass() {
        return OnmsNode.class;
    }

    private synchronized void loadPropertiesIfNull() {
        if (this.m_properties == null) {
            this.m_properties = new TreeMap();
            BeanItem item = new BeanItem((Object)new OnmsNode());
            for (Object key : item.getItemPropertyIds()) {
                this.m_properties.put(key, item.getItemProperty(key).getType());
            }
        }
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        this.loadPropertiesIfNull();
        return Collections.unmodifiableCollection(this.m_properties.keySet());
    }

    @Override
    protected Integer getId(OnmsNode bean) {
        return bean == null ? null : bean.getId();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.m_properties.get(propertyId);
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        this.loadPropertiesIfNull();
        HashSet<Object> propertyIds = new HashSet<Object>();
        propertyIds.addAll(this.m_properties.keySet());
        propertyIds.remove("primaryInterface");
        return Collections.unmodifiableCollection(propertyIds);
    }

    @Override
    public void selectionChanged(SelectionContext selectionContext) {
        Collection oldOrders = this.m_criteria.getOrders();
        HashSet<EqRestriction> restrictions = new HashSet<EqRestriction>();
        for (VertexRef ref : selectionContext.getSelectedVertexRefs()) {
            if (!"nodes".equals(ref.getNamespace())) continue;
            restrictions.add(new EqRestriction("id", (Object)Integer.valueOf(ref.getId())));
        }
        this.m_criteria = new Criteria(this.getItemClass());
        if (restrictions.size() > 0) {
            AnyRestriction any = new AnyRestriction(restrictions.toArray(new Restriction[0]));
            this.m_criteria.addRestriction((Restriction)any);
        }
        this.m_criteria.setOrders(oldOrders);
        this.fireItemSetChangedEvent();
    }
}

