/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import javax.xml.bind.annotation.XmlID;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.Connector;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.VertexRef;

public class SimpleConnector
implements Connector {
    private String m_namespace;
    private String m_id;
    private String m_label;
    private VertexRef m_vertex;
    private AbstractEdge m_edge;

    public SimpleConnector() {
    }

    public SimpleConnector(String namespace, String id, String label, VertexRef vertex) {
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("ID is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        if (vertex == null) {
            throw new IllegalArgumentException("Vertex is null");
        }
        this.m_namespace = namespace;
        this.m_id = id;
        this.m_label = label;
        this.m_vertex = vertex;
    }

    public SimpleConnector(String namespace, String id, VertexRef vertex) {
        this(namespace, id, namespace + ":" + id, vertex);
    }

    @Override
    public SimpleConnector clone() {
        SimpleConnector retval = new SimpleConnector(this.getNamespace(), this.getId(), this.getLabel(), this.getVertex());
        return retval;
    }

    public SimpleConnector(String namespace, String id, String label, VertexRef vertex, AbstractEdge edge) {
        this(namespace, id, label, vertex);
        this.m_edge = edge;
    }

    public SimpleConnector(String namespace, String id, VertexRef vertex, AbstractEdge edge) {
        this(namespace, id, namespace + ":" + id, vertex, edge);
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    @XmlID
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public AbstractEdge getEdge() {
        return this.m_edge;
    }

    public void setEdge(AbstractEdge edgeRef) {
        this.m_edge = edgeRef;
    }

    @Override
    public VertexRef getVertex() {
        return this.m_vertex;
    }

    @Override
    public void setVertex(VertexRef vertex) {
        this.m_vertex = vertex;
    }

    @Override
    public int compareTo(Ref o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getNamespace().equals(o.getNamespace())) {
            if (this.getId().equals(o.getId())) {
                throw new IllegalStateException("equals() was inaccurate in " + this.getClass().getName());
            }
            return this.getId().compareTo(o.getId());
        }
        return this.getNamespace().compareTo(o.getNamespace());
    }
}

