/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.SimpleGraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;

public class SimpleGraphBuilder {
    private final GraphProvider m_graphProvider;
    private AbstractVertex m_currentVertex;
    private AbstractEdge m_currentEdge;

    public SimpleGraphBuilder(String namespace) {
        this.m_graphProvider = new SimpleGraphProvider(namespace);
    }

    public SimpleGraphBuilder vertex(String id) {
        this.m_currentVertex = new AbstractVertex(this.ns(), id);
        this.m_graphProvider.addVertices(this.m_currentVertex);
        return this;
    }

    public SimpleGraphBuilder parent(String parentId) {
        Vertex parent = this.m_graphProvider.getVertex(this.ns(), parentId);
        this.m_graphProvider.setParent(this.m_currentVertex, parent);
        return this;
    }

    public SimpleGraphBuilder vLabel(String label) {
        this.m_currentVertex.setLabel(label);
        return this;
    }

    public SimpleGraphBuilder vTooltip(String tooltipText) {
        this.m_currentVertex.setTooltipText(tooltipText);
        return this;
    }

    public SimpleGraphBuilder vIconKey(String iconKey) {
        this.m_currentVertex.setIconKey(iconKey);
        return this;
    }

    public SimpleGraphBuilder vStyleName(String styleName) {
        this.m_currentVertex.setStyleName(styleName);
        return this;
    }

    public SimpleGraphBuilder vX(int x) {
        this.m_currentVertex.setX(x);
        return this;
    }

    public SimpleGraphBuilder vY(int y) {
        this.m_currentVertex.setY(y);
        return this;
    }

    public SimpleGraphBuilder edge(String id, String srcId, String tgtId) {
        VertexRef tgtVertex;
        VertexRef srcVertex = this.m_graphProvider.getVertex(this.ns(), srcId);
        if (srcVertex == null) {
            srcVertex = new DefaultVertexRef(this.ns(), srcId);
        }
        if ((tgtVertex = this.m_graphProvider.getVertex(this.ns(), tgtId)) == null) {
            tgtVertex = new DefaultVertexRef(this.ns(), tgtId);
        }
        SimpleConnector source = new SimpleConnector(this.ns(), srcId + "-" + id + "-connector", srcVertex);
        SimpleConnector target = new SimpleConnector(this.ns(), tgtId + "-" + id + "-connector", tgtVertex);
        this.m_currentEdge = new AbstractEdge(this.ns(), id, source, target);
        source.setEdge(this.m_currentEdge);
        target.setEdge(this.m_currentEdge);
        this.m_graphProvider.addEdges(this.m_currentEdge);
        return this;
    }

    public SimpleGraphBuilder eLabel(String label) {
        this.m_currentEdge.setLabel(label);
        return this;
    }

    public SimpleGraphBuilder eTooltip(String tooltipText) {
        this.m_currentEdge.setTooltipText(tooltipText);
        return this;
    }

    public SimpleGraphBuilder eStyleName(String styleName) {
        this.m_currentEdge.setStyleName(styleName);
        return this;
    }

    public GraphProvider get() {
        return this.m_graphProvider;
    }

    private String ns() {
        return this.m_graphProvider.getNamespace();
    }
}

