/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.IgnoreHopCriteria;
import org.opennms.features.topology.api.support.SemanticZoomLevelCriteria;
import org.opennms.features.topology.api.topo.CollapsibleCriteria;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexListener;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexHopGraphProvider
implements GraphProvider,
SelectionAware {
    private static final Logger LOG = LoggerFactory.getLogger(VertexHopGraphProvider.class);
    private final GraphProvider m_delegate;
    private final Map<VertexRef, Integer> m_semanticZoomLevels = new LinkedHashMap<VertexRef, Integer>();

    public static WrappedVertexHopCriteria getWrappedVertexHopCriteria(GraphContainer graphContainer) {
        Set<VertexHopCriteria> vertexHopCriterias = Criteria.getCriteriaForGraphContainer(graphContainer, VertexHopCriteria.class);
        return new WrappedVertexHopCriteria(vertexHopCriterias);
    }

    public static CollapsibleCriteria[] getCollapsedCriteriaForContainer(GraphContainer graphContainer) {
        return VertexHopGraphProvider.getCollapsedCriteria(graphContainer.getCriteria());
    }

    public static CollapsibleCriteria[] getCollapsedCriteria(Criteria[] criteria) {
        return VertexHopGraphProvider.getCollapsibleCriteria(criteria, true);
    }

    public static CollapsibleCriteria[] getCollapsibleCriteriaForContainer(GraphContainer graphContainer) {
        return VertexHopGraphProvider.getCollapsibleCriteria(graphContainer.getCriteria());
    }

    public static CollapsibleCriteria[] getCollapsibleCriteria(Criteria[] criteria) {
        return VertexHopGraphProvider.getCollapsibleCriteria(criteria, false);
    }

    public static CollapsibleCriteria[] getCollapsibleCriteria(Criteria[] criteria, boolean onlyCollapsed) {
        ArrayList<CollapsibleCriteria> retval = new ArrayList<CollapsibleCriteria>();
        if (criteria != null) {
            for (Criteria criterium : criteria) {
                try {
                    CollapsibleCriteria hopCriteria = (CollapsibleCriteria)((Object)criterium);
                    if (onlyCollapsed) {
                        if (!hopCriteria.isCollapsed()) continue;
                        retval.add(hopCriteria);
                        continue;
                    }
                    retval.add(hopCriteria);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return retval.toArray(new CollapsibleCriteria[0]);
    }

    public VertexHopGraphProvider(GraphProvider delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public void refresh() {
        this.m_delegate.refresh();
    }

    @Override
    public String getNamespace() {
        return this.m_delegate.getNamespace();
    }

    @Override
    public boolean contributesTo(String namespace) {
        return this.m_delegate.contributesTo(namespace);
    }

    @Override
    @Deprecated
    public boolean containsVertexId(String id) {
        return this.containsVertexId(new DefaultVertexRef(this.getNamespace(), id), new Criteria[0]);
    }

    @Override
    public boolean containsVertexId(VertexRef id, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : VertexHopGraphProvider.getCollapsedCriteria(criteria)) {
            Vertex collapsed = criterium.getCollapsedRepresentation();
            if (new RefComparator().compare(collapsed, id) != 0) continue;
            return true;
        }
        return this.m_delegate.containsVertexId(id, criteria);
    }

    @Override
    public Vertex getVertex(String namespace, String id) {
        return this.m_delegate.getVertex(namespace, id);
    }

    @Override
    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : VertexHopGraphProvider.getCollapsedCriteria(criteria)) {
            Vertex collapsed = criterium.getCollapsedRepresentation();
            if (new RefComparator().compare(collapsed, reference) != 0) continue;
            return collapsed;
        }
        return this.m_delegate.getVertex(reference, criteria);
    }

    @Override
    public int getSemanticZoomLevel(VertexRef vertex) {
        Integer szl = this.m_semanticZoomLevels.get(vertex);
        return szl == null ? 0 : szl;
    }

    public Set<VertexRef> getFocusNodes(Criteria ... criteria) {
        HashSet<VertexRef> focusNodes = new HashSet<VertexRef>();
        for (Criteria criterium : criteria) {
            try {
                VertexHopCriteria hopCriterium = (VertexHopCriteria)criterium;
                focusNodes.addAll(hopCriterium.getVertices());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return focusNodes;
    }

    public int getMaxSemanticZoomLevel(Criteria ... criteria) {
        for (Criteria criterium : criteria) {
            try {
                SemanticZoomLevelCriteria szlCriteria = (SemanticZoomLevelCriteria)criterium;
                return szlCriteria.getSemanticZoomLevel();
            }
            catch (ClassCastException classCastException) {
            }
        }
        return 100;
    }

    @Override
    public List<Vertex> getVertices(Criteria ... criteria) {
        for (Criteria criterium : criteria) {
            try {
                IgnoreHopCriteria ignoreHopCriteria = (IgnoreHopCriteria)criterium;
                return this.m_delegate.getVertices(new Criteria[0]);
            }
            catch (ClassCastException ignoreHopCriteria) {
            }
        }
        Set<VertexRef> focusNodes = this.getFocusNodes(criteria);
        int maxSemanticZoomLevel = this.getMaxSemanticZoomLevel(criteria);
        this.m_semanticZoomLevels.clear();
        int semanticZoomLevel = 0;
        if (focusNodes.size() < 1) {
            VertexHopGraphProvider.collapseVertices(Collections.emptySet(), VertexHopGraphProvider.getCollapsibleCriteria(criteria, false));
        }
        HashMap<VertexRef, HashSet<VertexRef>> neighborMap = new HashMap<VertexRef, HashSet<VertexRef>>();
        List<Edge> edges = this.m_delegate.getEdges(criteria);
        for (Edge edge : edges) {
            VertexRef src = edge.getSource().getVertex();
            VertexRef tgt = edge.getTarget().getVertex();
            HashSet<VertexRef> srcNeighbors = (HashSet<VertexRef>)neighborMap.get(src);
            if (srcNeighbors == null) {
                srcNeighbors = new HashSet<VertexRef>();
                neighborMap.put(src, srcNeighbors);
            }
            srcNeighbors.add(tgt);
            HashSet<VertexRef> tgtNeighbors = (HashSet<VertexRef>)neighborMap.get(tgt);
            if (tgtNeighbors == null) {
                tgtNeighbors = new HashSet<VertexRef>();
                neighborMap.put(tgt, tgtNeighbors);
            }
            tgtNeighbors.add(src);
        }
        Set<Vertex> processed = new HashSet<Vertex>();
        HashSet neighbors = new HashSet();
        HashSet<VertexRef> workingSet = new HashSet<VertexRef>(focusNodes);
        while (semanticZoomLevel <= maxSemanticZoomLevel && workingSet.size() > 0) {
            neighbors.clear();
            for (VertexRef vertexRef : workingSet) {
                Vertex vertex = this.getVertex(vertexRef, criteria);
                if (vertex == null) continue;
                if (this.m_semanticZoomLevels.containsKey(vertexRef)) {
                    throw new IllegalStateException("Calculating semantic zoom level for vertex that has already been calculated: " + vertexRef.toString());
                }
                this.m_semanticZoomLevels.put(vertexRef, semanticZoomLevel);
                Set refs = (Set)neighborMap.get(vertexRef);
                if (refs != null) {
                    neighbors.addAll(refs);
                }
                processed.add(vertex);
            }
            neighbors.removeAll(processed);
            workingSet.clear();
            workingSet.addAll(neighbors);
            ++semanticZoomLevel;
        }
        processed = VertexHopGraphProvider.collapseVertices(processed, VertexHopGraphProvider.getCollapsedCriteria(criteria));
        return new ArrayList<Vertex>(processed);
    }

    public static Set<Vertex> collapseVertices(Set<Vertex> vertices, CollapsibleCriteria[] criteria) {
        HashSet<Vertex> retval = new HashSet<Vertex>();
        HashSet<Vertex> verticesToProcess = new HashSet<Vertex>(vertices);
        for (CollapsibleCriteria collapsibleCriteria : criteria) {
            if (!collapsibleCriteria.isCollapsed()) continue;
            Set verticesRepresentedByCollapsible = collapsibleCriteria.getVertices().stream().filter(v -> vertices.contains(v)).collect(Collectors.toSet());
            verticesToProcess.removeAll(verticesRepresentedByCollapsible);
            retval.add(collapsibleCriteria.getCollapsedRepresentation());
        }
        retval.addAll(verticesToProcess);
        verticesToProcess.clear();
        return retval;
    }

    public static Map<VertexRef, Set<Vertex>> getMapOfVerticesToCollapsedVertices(CollapsibleCriteria[] criteria) {
        TreeMap<Ref, HashSet<Vertex>> vertexToCollapsedVertices = new TreeMap<Ref, HashSet<Vertex>>(new RefComparator());
        for (CollapsibleCriteria criterium : criteria) {
            Set<VertexRef> criteriaVertices = criterium.getVertices();
            if (criteriaVertices.size() <= 0) continue;
            Vertex collapsedVertex = criterium.getCollapsedRepresentation();
            for (VertexRef criteriaVertex : criteriaVertices) {
                HashSet<Vertex> collapsedVertices = (HashSet<Vertex>)vertexToCollapsedVertices.get(criteriaVertex);
                if (collapsedVertices == null) {
                    collapsedVertices = new HashSet<Vertex>();
                    vertexToCollapsedVertices.put(criteriaVertex, collapsedVertices);
                }
                collapsedVertices.add(collapsedVertex);
            }
        }
        return vertexToCollapsedVertices;
    }

    public static Set<Edge> collapseEdges(Set<Edge> edges, CollapsibleCriteria[] criteria) {
        Map<VertexRef, Set<Vertex>> vertexToCollapsedVertices = VertexHopGraphProvider.getMapOfVerticesToCollapsedVertices(criteria);
        if (vertexToCollapsedVertices.size() > 0) {
            HashSet<Edge> retval = new HashSet<Edge>();
            for (Edge edge : edges) {
                Set<Vertex> collapsedTargets;
                boolean addOriginalEdge = true;
                Set<Vertex> collapsedSources = vertexToCollapsedVertices.get(edge.getSource().getVertex());
                if (collapsedSources != null) {
                    for (VertexRef vertexRef : collapsedSources) {
                        Edge edge2 = edge.clone();
                        edge2.setId("collapsedSource-" + edge2.getId());
                        edge2.getSource().setVertex(vertexRef);
                        retval.add(edge2);
                    }
                    addOriginalEdge = false;
                }
                if ((collapsedTargets = vertexToCollapsedVertices.get(edge.getTarget().getVertex())) != null) {
                    for (VertexRef vertexRef : collapsedTargets) {
                        Edge newCollapsedEdge = edge.clone();
                        newCollapsedEdge.setId("collapsedTarget-" + newCollapsedEdge.getId());
                        newCollapsedEdge.getTarget().setVertex(vertexRef);
                        retval.add(newCollapsedEdge);
                    }
                    addOriginalEdge = false;
                }
                if (collapsedSources != null && collapsedTargets != null) {
                    for (VertexRef vertexRef : collapsedSources) {
                        for (VertexRef vertexRef2 : collapsedTargets) {
                            Edge newCollapsedEdge = edge.clone();
                            newCollapsedEdge.setId("collapsed-" + newCollapsedEdge.getId());
                            newCollapsedEdge.getSource().setVertex(vertexRef);
                            newCollapsedEdge.getTarget().setVertex(vertexRef2);
                            retval.add(newCollapsedEdge);
                        }
                    }
                    addOriginalEdge = false;
                }
                if (!addOriginalEdge) continue;
                retval.add(edge);
            }
            return retval;
        }
        return edges;
    }

    @Override
    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        return this.m_delegate.getVertices(references, criteria);
    }

    @Override
    public List<Vertex> getRootGroup() {
        return this.getVertices(new Criteria[0]);
    }

    @Override
    public boolean hasChildren(VertexRef group) {
        return false;
    }

    @Override
    public Vertex getParent(VertexRef vertex) {
        return null;
    }

    @Override
    public boolean setParent(VertexRef child, VertexRef parent) {
        return false;
    }

    @Override
    public List<Vertex> getChildren(VertexRef group, Criteria ... criteria) {
        for (CollapsibleCriteria criterium : VertexHopGraphProvider.getCollapsedCriteria(criteria)) {
            if (new RefComparator().compare(criterium.getCollapsedRepresentation(), group) != 0) continue;
            return this.getVertices(criterium.getVertices(), new Criteria[0]);
        }
        return Collections.emptyList();
    }

    @Override
    public void addVertexListener(VertexListener vertexListener) {
        this.m_delegate.addVertexListener(vertexListener);
    }

    @Override
    public void removeVertexListener(VertexListener vertexListener) {
        this.m_delegate.removeVertexListener(vertexListener);
    }

    @Override
    public void clearVertices() {
        this.m_delegate.clearVertices();
    }

    @Override
    public int getVertexTotalCount() {
        return this.m_delegate.getVertexTotalCount();
    }

    @Override
    public int getEdgeTotalCount() {
        return this.m_delegate.getEdgeTotalCount();
    }

    @Override
    public Edge getEdge(String namespace, String id) {
        return this.m_delegate.getEdge(namespace, id);
    }

    @Override
    public Edge getEdge(EdgeRef reference) {
        return this.m_delegate.getEdge(reference);
    }

    @Override
    public List<Edge> getEdges(Criteria ... criteria) {
        Set<Edge> retval = new HashSet<Edge>(this.m_delegate.getEdges(criteria));
        retval = VertexHopGraphProvider.collapseEdges(retval, VertexHopGraphProvider.getCollapsedCriteria(criteria));
        return new ArrayList<Edge>(retval);
    }

    @Override
    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        return this.m_delegate.getEdges(references);
    }

    @Override
    public void addEdgeListener(EdgeListener listener) {
        this.m_delegate.addEdgeListener(listener);
    }

    @Override
    public void removeEdgeListener(EdgeListener listener) {
        this.m_delegate.removeEdgeListener(listener);
    }

    @Override
    public void clearEdges() {
        this.m_delegate.clearEdges();
    }

    @Override
    public void resetContainer() {
        this.m_delegate.resetContainer();
    }

    @Override
    public void addVertices(Vertex ... vertices) {
        this.m_delegate.addVertices(vertices);
    }

    @Override
    public void removeVertex(VertexRef ... vertexId) {
        this.m_delegate.removeVertex(vertexId);
    }

    @Override
    public Vertex addVertex(int x, int y) {
        return this.m_delegate.addVertex(x, y);
    }

    @Override
    public Vertex addGroup(String label, String iconKey) {
        throw new UnsupportedOperationException("Grouping is unsupported by " + this.getClass().getName());
    }

    @Override
    public EdgeRef[] getEdgeIdsForVertex(VertexRef vertex) {
        return this.m_delegate.getEdgeIdsForVertex(vertex);
    }

    @Override
    public Map<VertexRef, Set<EdgeRef>> getEdgeIdsForVertices(VertexRef ... vertices) {
        return this.m_delegate.getEdgeIdsForVertices(vertices);
    }

    @Override
    public void addEdges(Edge ... edges) {
        this.m_delegate.addEdges(edges);
    }

    @Override
    public void removeEdges(EdgeRef ... edges) {
        this.m_delegate.removeEdges(edges);
    }

    @Override
    public Edge connectVertices(VertexRef sourceVertextId, VertexRef targetVertextId) {
        return this.m_delegate.connectVertices(sourceVertextId, targetVertextId);
    }

    @Override
    public Defaults getDefaults() {
        return this.m_delegate.getDefaults();
    }

    @Override
    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.m_delegate.getSelection(selectedVertices, type);
    }

    @Override
    public boolean contributesTo(ContentType type) {
        return this.m_delegate.contributesTo(type);
    }

    @Override
    public TopologyProviderInfo getTopologyProviderInfo() {
        return this.m_delegate.getTopologyProviderInfo();
    }

    public static class DefaultVertexHopCriteria
    extends VertexHopCriteria {
        private final VertexRef vertexRef;

        public DefaultVertexHopCriteria(VertexRef vertexRef) {
            super(vertexRef.getId(), vertexRef.getLabel());
            this.vertexRef = vertexRef;
        }

        @Override
        public Set<VertexRef> getVertices() {
            return Sets.newHashSet((Object[])new VertexRef[]{this.vertexRef});
        }

        @Override
        public String getNamespace() {
            return this.vertexRef.getNamespace();
        }

        @Override
        public int hashCode() {
            return this.vertexRef.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof DefaultVertexHopCriteria) {
                return Objects.equals(this.vertexRef, ((DefaultVertexHopCriteria)obj).vertexRef);
            }
            return false;
        }
    }

    public static class WrappedVertexHopCriteria
    extends VertexHopCriteria {
        private final Set<VertexHopCriteria> criteriaList;

        public WrappedVertexHopCriteria(Set<VertexHopCriteria> vertexHopCriterias) {
            super("Wrapped Vertex Hop Criteria for all VertexHopCriteria in the currently selected GraphProvider");
            this.criteriaList = Objects.requireNonNull(vertexHopCriterias);
        }

        public void addCriteria(VertexHopCriteria criteria) {
            this.criteriaList.add(criteria);
        }

        @Override
        public Set<VertexRef> getVertices() {
            Set<VertexRef> vertices = this.criteriaList.stream().flatMap(criteria -> criteria.getVertices().stream()).collect(Collectors.toSet());
            return vertices;
        }

        @Override
        public String getNamespace() {
            return "$wrapped$";
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.criteriaList);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof WrappedVertexHopCriteria) {
                WrappedVertexHopCriteria other = (WrappedVertexHopCriteria)obj;
                return Objects.equals(this.criteriaList, other.criteriaList);
            }
            return false;
        }

        public boolean contains(VertexRef vertexRef) {
            return this.getVertices().contains(vertexRef);
        }
    }

    public static abstract class VertexHopCriteria
    extends Criteria {
        private String m_label = "";
        private String m_id = "";

        public String toString() {
            return "Namespace:" + this.getNamespace() + ", ID:" + this.getId() + ", Label:" + this.getLabel();
        }

        public VertexHopCriteria(String label) {
            this.m_label = label;
        }

        public VertexHopCriteria(String id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        @Override
        public Criteria.ElementType getType() {
            return Criteria.ElementType.VERTEX;
        }

        public abstract Set<VertexRef> getVertices();

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public String getId() {
            return this.m_id;
        }

        public boolean isEmpty() {
            Set<VertexRef> vertices = this.getVertices();
            if (vertices == null) {
                return false;
            }
            return vertices.isEmpty();
        }
    }
}

