/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.NamespaceAware;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbStrategy;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public class SimpleMetaTopologyProvider
implements MetaTopologyProvider {
    private final GraphProvider graphProvider;
    private String preferredLayout;

    public SimpleMetaTopologyProvider(GraphProvider graphProvider) {
        this.graphProvider = Objects.requireNonNull(graphProvider);
    }

    @Override
    public String getId() {
        return this.getGraphProviders().stream().sorted(Comparator.comparing(NamespaceAware::getNamespace)).map(g -> g.getNamespace()).collect(Collectors.joining(":"));
    }

    @Override
    public GraphProvider getDefaultGraphProvider() {
        return this.graphProvider;
    }

    @Override
    public Collection<VertexRef> getOppositeVertices(VertexRef vertexRef) {
        return Collections.emptySet();
    }

    public List<GraphProvider> getGraphProviders() {
        return Lists.newArrayList((Object[])new GraphProvider[]{this.graphProvider});
    }

    @Override
    public GraphProvider getGraphProviderBy(String namespace) {
        return this.getGraphProviders().stream().filter(provider -> provider.getNamespace().equals(namespace)).findFirst().orElse(null);
    }

    @Override
    public BreadcrumbStrategy getBreadcrumbStrategy() {
        return BreadcrumbStrategy.NONE;
    }

    public void setPreferredLayout(String preferredLayout) {
        this.preferredLayout = preferredLayout;
    }

    public String getPreferredLayout() {
        return this.preferredLayout;
    }
}

