/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.topo;

import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItem;
import org.opennms.features.topology.api.topo.AbstractEdgeRef;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.VertexRef;

public class AbstractEdge
extends AbstractEdgeRef
implements Edge {
    private final SimpleConnector m_source;
    private final SimpleConnector m_target;
    private String m_tooltipText;
    private String m_styleName;

    public AbstractEdge(String namespace, String id, VertexRef source, VertexRef target) {
        super(namespace, id);
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target is null");
        }
        this.m_source = new SimpleConnector(namespace, id + "::" + source.getId(), source.getLabel() + " Connector", source, this);
        this.m_target = new SimpleConnector(namespace, id + "::" + target.getId(), target.getLabel() + " Connector", target, this);
        this.m_styleName = "edge";
    }

    public AbstractEdge(String namespace, String id, SimpleConnector source, SimpleConnector target) {
        super(namespace, id);
        this.m_source = source;
        this.m_target = target;
        this.m_styleName = "edge";
    }

    protected AbstractEdge(AbstractEdge edgeToClone) {
        this(edgeToClone.getNamespace(), edgeToClone.getId(), edgeToClone.getSource().clone(), edgeToClone.getTarget().clone());
        this.setLabel(edgeToClone.getLabel());
        this.setStyleName(edgeToClone.getStyleName());
        this.setTooltipText(edgeToClone.getTooltipText());
    }

    @Override
    public AbstractEdge clone() {
        return new AbstractEdge(this);
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public String getKey() {
        return this.getNamespace() + ":" + this.getId();
    }

    @Override
    public String getTooltipText() {
        return this.m_tooltipText;
    }

    @Override
    public final String getStyleName() {
        return this.m_styleName;
    }

    @Override
    public final void setTooltipText(String tooltipText) {
        this.m_tooltipText = tooltipText;
    }

    @Override
    public final void setStyleName(String styleName) {
        this.m_styleName = styleName;
    }

    @Override
    public Item getItem() {
        return new BeanItem((Object)this);
    }

    @Override
    public final SimpleConnector getSource() {
        return this.m_source;
    }

    @Override
    public final SimpleConnector getTarget() {
        return this.m_target;
    }

    @Override
    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("Edge:").append(this.getNamespace()).append(":").append(this.getId());
        retval.append("[");
        retval.append("label=").append(this.getLabel());
        retval.append(",");
        retval.append("styleName=").append(this.getStyleName());
        retval.append(",");
        retval.append("source=").append(this.getSource().getVertex().getLabel());
        retval.append(",");
        retval.append("target=").append(this.getTarget().getVertex().getLabel());
        retval.append("]");
        return retval.toString();
    }
}

