/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.features.topology.netutils.internal.service.PingRequest;
import org.opennms.features.topology.netutils.internal.service.PingResult;
import org.opennms.features.topology.netutils.internal.service.PingSequence;
import org.opennms.features.topology.netutils.internal.service.PingService;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;

public class PingServiceResponseCallback
implements PingResponseCallback {
    private final PingResult result;
    private final PingService.Callback uiCallback;

    PingServiceResponseCallback(PingRequest request, PingService.Callback uiCallback) {
        this.result = new PingResult(Objects.requireNonNull(request));
        this.uiCallback = Objects.requireNonNull(uiCallback);
        uiCallback.onUpdate(this.result);
    }

    public void handleResponse(InetAddress address, EchoPacket response) {
        this.result.addSequence(new PingSequence(response));
        this.notifyUI();
    }

    public void handleTimeout(InetAddress address, EchoPacket request) {
        PingSequence sequence = new PingSequence(request, true);
        if (!this.result.hasSequence(sequence.getSequenceNumber())) {
            this.result.addSequence(sequence);
            this.notifyUI();
        }
    }

    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        this.result.addSequence(new PingSequence(request, t));
        this.notifyUI();
    }

    protected boolean isDone() {
        return this.result.isComplete();
    }

    protected void notifyUI() {
        this.uiCallback.onUpdate(this.result);
    }
}

