/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.netutils.internal.service.PingRequest;
import org.opennms.features.topology.netutils.internal.service.PingResultSummary;
import org.opennms.features.topology.netutils.internal.service.PingSequence;

public class PingResult {
    private final List<PingSequence> sequences = Lists.newArrayList();
    private final PingRequest pingRequest;

    public PingResult(PingRequest pingRequest) {
        this.pingRequest = Objects.requireNonNull(pingRequest);
    }

    public void addSequence(PingSequence sequence) {
        Objects.requireNonNull(sequence);
        this.sequences.add(sequence);
    }

    public List<PingSequence> getSequences() {
        return this.sequences.stream().sorted((o1, o2) -> Integer.compare(o1.getSequenceNumber(), o2.getSequenceNumber())).collect(Collectors.toList());
    }

    public PingRequest getRequest() {
        return this.pingRequest;
    }

    public boolean hasSequence(int sequenceNumber) {
        return this.sequences.stream().filter(eachSequence -> sequenceNumber == eachSequence.getSequenceNumber()).findFirst().isPresent();
    }

    public boolean isComplete() {
        return this.pingRequest.getNumberRequests() == this.sequences.size();
    }

    public PingResultSummary getSummary() {
        return new PingResultSummary(this);
    }

    public String toDetailString() {
        String ipAddress = InetAddressUtils.toIpAddrString((InetAddress)this.getRequest().getInetAddress());
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("PING %s: %d data bytes", ipAddress, this.getRequest().getPackageSize() - 8));
        builder.append("\n");
        for (PingSequence eachSequence : this.getSequences()) {
            if (eachSequence.isTimeout()) {
                builder.append(String.format("Request timeout for icmp_seq %s", eachSequence.getSequenceNumber()));
            }
            if (eachSequence.isError()) {
                builder.append(String.format("Request error for icmp_seq %s: %s", eachSequence.getSequenceNumber(), eachSequence.getError().getMessage()));
            }
            if (eachSequence.isSuccess()) {
                builder.append(String.format("%s bytes from %s: icmp_seq=%d time=%d ms", this.getRequest().getPackageSize(), ipAddress, eachSequence.getResponse().getSequenceNumber(), eachSequence.getResponse().getReceivedTimeNanos() - eachSequence.getResponse().getSentTimeNanos()));
            }
            builder.append("\n");
        }
        if (this.isComplete()) {
            PingResultSummary summary = this.getSummary();
            builder.append("\n");
            builder.append(String.format("--- %s ping statistics ---", ipAddress));
            builder.append("\n");
            builder.append(String.format("%d packets transmitted, %d packets received, %.2f%% packet loss", summary.getPacketsTransmitted(), summary.getPacketsReceived(), summary.getPacketLoss()));
            builder.append("\n");
            builder.append(String.format("round-trip min/avg/max/stddev = %.2f/%.2f/%.2f/%.2f ms", summary.getMin(), summary.getAvg(), (double)summary.getMax(), summary.getStdDev()));
            builder.append("\n");
        }
        return builder.toString();
    }
}

