/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.service;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PingRequest {
    private long timeout;
    private int packageSize;
    private int retries;
    private InetAddress inetAddress;
    private int numberRequests;
    private long delay;

    public PingRequest withTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be > 0");
        Objects.requireNonNull(unit);
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public PingRequest withPackageSize(int packageSize) {
        Preconditions.checkArgument((packageSize > 0 ? 1 : 0) != 0, (Object)"packageSize must be > 0");
        this.packageSize = packageSize;
        return this;
    }

    public PingRequest withRetries(int retries) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"retries must be >= 0");
        this.retries = retries;
        return this;
    }

    public PingRequest withInetAddress(InetAddress inetAddress) {
        this.inetAddress = Objects.requireNonNull(inetAddress);
        return this;
    }

    public PingRequest withNumberRequests(int numberRequests) {
        Preconditions.checkArgument((numberRequests > 0 ? 1 : 0) != 0, (Object)"number of requests must be > 0");
        this.numberRequests = numberRequests;
        return this;
    }

    public PingRequest withDelay(int delay, TimeUnit unit) {
        Preconditions.checkArgument((delay > 0 ? 1 : 0) != 0, (Object)"delay must be > 0");
        Objects.requireNonNull(unit);
        this.delay = TimeUnit.MILLISECONDS.convert(delay, unit);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getPackageSize() {
        return this.packageSize;
    }

    public int getRetries() {
        return this.retries;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getNumberRequests() {
        return this.numberRequests;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPackageSize(int packageSize) {
        this.packageSize = packageSize;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setNumberRequests(int numberRequests) {
        this.numberRequests = numberRequests;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }
}

