/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal;

import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.netutils.internal.PingForm;
import org.opennms.features.topology.netutils.internal.service.PingRequest;
import org.opennms.features.topology.netutils.internal.service.PingService;

public class PingWindow
extends Window {
    public static final int POLL_INTERVAL = 1000;
    private final ProgressBar progressIndicator;
    private final Button cancelButton;
    private final Button pingButton;
    private final PingForm pingForm;

    public PingWindow(Vertex vertex, PingService pingService) {
        Objects.requireNonNull(vertex);
        Objects.requireNonNull(pingService);
        int initialPollInterval = UI.getCurrent().getPollInterval();
        this.pingForm = new PingForm(InetAddressUtils.getInetAddress((String)vertex.getIpAddress()));
        TextArea resultArea = new TextArea();
        resultArea.setRows(15);
        resultArea.setSizeFull();
        this.progressIndicator = new ProgressBar();
        this.progressIndicator.setIndeterminate(true);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addClickListener((Button.ClickListener & Serializable)event -> {
            pingService.cancel();
            resultArea.setValue((String)resultArea.getValue() + "\n" + "Ping cancelled by user");
            this.getUI().setPollInterval(initialPollInterval);
            this.setRunning(false);
        });
        this.pingButton = new Button("Ping");
        this.pingButton.addClickListener((Button.ClickListener & Serializable)event -> {
            try {
                PingRequest pingRequest = this.pingForm.getPingRequest();
                this.setRunning(true);
                this.getUI().setPollInterval(1000);
                resultArea.setValue("");
                pingService.ping(pingRequest, result -> {
                    this.setRunning(!result.isComplete());
                    resultArea.setValue(result.toDetailString());
                    if (result.isComplete()) {
                        this.getUI().setPollInterval(initialPollInterval);
                    }
                });
            }
            catch (FieldGroup.CommitException e) {
                Notification.show((String)"Validation errors", (String)"Please correct them. Make sure all required fields are set.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        });
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        buttonLayout.addComponent((Component)this.pingButton);
        buttonLayout.addComponent((Component)this.cancelButton);
        buttonLayout.addComponent((Component)this.progressIndicator);
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSpacing(true);
        rootLayout.setMargin(true);
        rootLayout.addComponent((Component)this.pingForm);
        rootLayout.addComponent((Component)buttonLayout);
        rootLayout.addComponent((Component)new Label("<b>Results</b>", ContentMode.HTML));
        rootLayout.addComponent((Component)resultArea);
        rootLayout.setExpandRatio((Component)resultArea, 1.0f);
        this.setCaption(String.format("Ping - %s (%s)", vertex.getLabel(), vertex.getIpAddress()));
        this.setResizable(false);
        this.setModal(true);
        this.setWidth(800.0f, Sizeable.Unit.PIXELS);
        this.setHeight(550.0f, Sizeable.Unit.PIXELS);
        this.setContent((Component)rootLayout);
        this.center();
        this.setRunning(false);
        this.addCloseListener((Window.CloseListener & Serializable)e -> {
            pingService.cancel();
            this.getUI().setPollInterval(initialPollInterval);
        });
    }

    private void setRunning(boolean running) {
        this.cancelButton.setEnabled(running);
        this.progressIndicator.setVisible(running);
        this.pingButton.setEnabled(!running);
        this.pingForm.setEnabled(!running);
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }
}

