/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal;

import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.util.converter.StringToLongConverter;
import com.vaadin.data.validator.NullValidator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.netutils.internal.service.PingRequest;

public class PingForm
extends FormLayout {
    private static final float FIELD_WIDTH = 150.0f;
    private final BeanItem<PingRequest> item;
    private final NativeSelect ipDropdown;
    private final NativeSelect packetSizeDropdown;
    private final TextField numberOfRequestsField;
    private final TextField timeoutField;
    private final FieldGroup binder;

    public PingForm(InetAddress host) {
        Objects.requireNonNull(host);
        PingRequest pingRequest = new PingRequest().withNumberRequests(4).withTimeout(1L, TimeUnit.SECONDS).withPackageSize(64).withInetAddress(host);
        this.ipDropdown = new NativeSelect();
        this.ipDropdown.setCaption("IP Address");
        this.ipDropdown.addItem((Object)pingRequest.getInetAddress());
        this.ipDropdown.setNullSelectionAllowed(false);
        this.ipDropdown.getItemIds().forEach(eachItemId -> this.ipDropdown.setItemCaption(eachItemId, InetAddressUtils.toIpAddrString((InetAddress)((InetAddress)eachItemId))));
        this.ipDropdown.setWidth(150.0f, Sizeable.Unit.PIXELS);
        this.packetSizeDropdown = new NativeSelect();
        this.packetSizeDropdown.setCaption("Packet Size");
        this.packetSizeDropdown.addItem((Object)64);
        this.packetSizeDropdown.addItem((Object)128);
        this.packetSizeDropdown.addItem((Object)256);
        this.packetSizeDropdown.addItem((Object)512);
        this.packetSizeDropdown.addItem((Object)1024);
        this.packetSizeDropdown.addItem((Object)2048);
        this.packetSizeDropdown.setNullSelectionAllowed(false);
        this.packetSizeDropdown.setWidth(150.0f, Sizeable.Unit.PIXELS);
        this.numberOfRequestsField = new TextField();
        this.numberOfRequestsField.setCaption("Number of Requests");
        this.numberOfRequestsField.setRequired(true);
        this.numberOfRequestsField.setRequiredError("Must be given");
        this.numberOfRequestsField.setNullRepresentation("");
        this.numberOfRequestsField.setWidth(150.0f, Sizeable.Unit.PIXELS);
        this.numberOfRequestsField.addValidator((Validator & Serializable)value -> {
            if (value != null && (Integer)value <= 0) {
                throw new Validator.InvalidValueException("must be > 0");
            }
        });
        this.timeoutField = new TextField();
        this.timeoutField.setCaption("Timeout (seconds)");
        this.timeoutField.setRequired(true);
        this.timeoutField.setRequiredError("Must be given");
        this.timeoutField.setWidth(150.0f, Sizeable.Unit.PIXELS);
        this.timeoutField.setConverter((Converter)new StringToLongConverter(){

            public Long convertToModel(String value, Class<? extends Long> targetType, Locale locale) throws Converter.ConversionException {
                Long longValue = super.convertToModel(value, targetType, locale);
                if (longValue != null) {
                    return TimeUnit.MILLISECONDS.convert(longValue, TimeUnit.SECONDS);
                }
                return longValue;
            }

            public String convertToPresentation(Long value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
                if (value != null) {
                    return super.convertToPresentation((Object)TimeUnit.SECONDS.convert(value, TimeUnit.MILLISECONDS), targetType, locale);
                }
                return super.convertToPresentation((Object)value, targetType, locale);
            }
        });
        this.timeoutField.addValidator((Validator)new NullValidator("Must be given", false));
        this.timeoutField.addValidator((Validator & Serializable)value -> {
            if (value != null && ((Long)value).intValue() <= 0) {
                throw new Validator.InvalidValueException("must be > 0");
            }
        });
        this.addComponent((Component)this.ipDropdown);
        this.addComponent((Component)this.numberOfRequestsField);
        this.addComponent((Component)this.timeoutField);
        this.addComponent((Component)this.packetSizeDropdown);
        this.item = new BeanItem((Object)pingRequest);
        this.binder = new FieldGroup(this.item);
        this.binder.bind((Field)this.ipDropdown, (Object)"inetAddress");
        this.binder.bind((Field)this.numberOfRequestsField, (Object)"numberRequests");
        this.binder.bind((Field)this.timeoutField, (Object)"timeout");
        this.binder.bind((Field)this.packetSizeDropdown, (Object)"packageSize");
        this.binder.setBuffered(true);
    }

    public PingRequest getPingRequest() throws FieldGroup.CommitException {
        this.binder.commit();
        return ((PingRequest)this.item.getBean()).withRetries(0).withDelay(1, TimeUnit.SECONDS);
    }
}

