/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.net.MalformedURLException;
import java.net.URL;
import org.opennms.features.topology.netutils.internal.Node;

public class EventsAlarmsWindow
extends Window {
    private static final double sizePercentage = 0.8;
    private static final int widthCushion = 50;
    private static final int heightCushion = 110;
    private Embedded eventsBrowser = null;
    private Embedded alarmsBrowser = null;
    private static final String noLabel = "no such label";
    private TabSheet m_tabSheet;

    private static String makeLabel(Node node) {
        String label = node == null ? "" : node.getLabel();
        label = label == null || label.equals("") || label.equalsIgnoreCase(noLabel) ? "" : " - " + label;
        return label;
    }

    public EventsAlarmsWindow(Node node, URL eventsURL, URL alarmsURL) throws MalformedURLException {
        super("Events & Alarms" + EventsAlarmsWindow.makeLabel(node));
        this.eventsBrowser = new Embedded("", (Resource)new ExternalResource(eventsURL));
        this.eventsBrowser.setSizeFull();
        this.alarmsBrowser = new Embedded("", (Resource)new ExternalResource(alarmsURL));
        this.alarmsBrowser.setSizeFull();
        this.setImmediate(true);
        this.setResizable(false);
        this.m_tabSheet = new TabSheet();
        this.m_tabSheet.setSizeFull();
        this.m_tabSheet.addTab((Component)this.eventsBrowser, "Events");
        this.m_tabSheet.addTab((Component)this.alarmsBrowser, "Alarms");
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.m_tabSheet);
        layout.setSizeFull();
        this.setContent((Component)layout);
    }

    public void attach() {
        super.attach();
        int width = this.getUI().getPage().getBrowserWindowWidth();
        int height = this.getUI().getPage().getBrowserWindowHeight();
        int browserWidth = (int)(0.8 * (double)width);
        int browserHeight = (int)(0.8 * (double)height);
        this.setWidth("" + browserWidth + "px");
        this.setHeight("" + browserHeight + "px");
        this.setPositionX((width - browserWidth) / 2);
        this.setPositionY((height - browserHeight) / 2);
        int viewHeight = browserHeight - 76;
        this.alarmsBrowser.setType(2);
        this.alarmsBrowser.setHeight(viewHeight + "px");
        this.eventsBrowser.setType(2);
        this.eventsBrowser.setHeight(viewHeight + "px");
    }
}

