/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTicketerServiceLayer
implements TicketerServiceLayer,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTicketerServiceLayer.class);
    @Autowired
    private AlarmDao m_alarmDao;
    private Plugin m_ticketerPlugin;
    private EventIpcManager m_eventIpcManager = EventIpcManagerFactory.getIpcManager();
    static final String COMMS_ERROR_UEI = "uei.opennms.org/troubleTicket/communicationError";

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.m_alarmDao, "alarmDao property must be set");
        Objects.requireNonNull(this.m_ticketerPlugin, "ticketerPlugin property must be set");
    }

    @Override
    public void cancelTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            LOG.error("No alarm with id {} was found. Ticket with id '{}' will not be canceled.", (Object)alarmId, (Object)ticketId);
            return;
        }
        try {
            this.setTicketState(ticketId, Ticket.State.CANCELLED);
            alarm.setTTicketState(TroubleTicketState.CANCELLED);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CANCEL_FAILED);
            LOG.error("Unable to cancel ticket for alarm: {}", (Object)e.getMessage(), (Object)e);
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private void setTicketState(String ticketId, Ticket.State state) throws PluginException {
        try {
            Ticket ticket = this.m_ticketerPlugin.get(ticketId);
            ticket.setState(state);
            this.m_ticketerPlugin.saveOrUpdate(ticket);
        }
        catch (PluginException e) {
            LOG.error("Unable to set ticket state");
            throw e;
        }
    }

    @Override
    public void closeTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            LOG.error("No alarm with id {} was found. Ticket with id '{}' will not be closed.", (Object)alarmId, (Object)ticketId);
            return;
        }
        try {
            this.setTicketState(ticketId, Ticket.State.CLOSED);
            alarm.setTTicketState(TroubleTicketState.CLOSED);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CLOSE_FAILED);
            LOG.error("Unable to close ticket for alarm: {}", (Object)e.getMessage(), (Object)e);
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    @Override
    public void createTicketForAlarm(int alarmId, Map<String, String> attributes) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            LOG.error("No alarm with id {} was found. No ticket will be created.", (Object)alarmId);
            return;
        }
        Ticket ticket = this.createTicketFromAlarm(alarm);
        if (attributes.containsKey("user")) {
            ticket.setUser(attributes.get("user"));
        }
        ticket.setAttributes(attributes);
        try {
            this.m_ticketerPlugin.saveOrUpdate(ticket);
            alarm.setTTicketId(ticket.getId());
            alarm.setTTicketState(TroubleTicketState.OPEN);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CREATE_FAILED);
            LOG.error("Unable to create ticket for alarm: {}", (Object)e.getMessage(), (Object)e);
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    protected Ticket createTicketFromAlarm(OnmsAlarm alarm) {
        Ticket ticket = new Ticket();
        ticket.setSummary(alarm.getLogMsg());
        ticket.setDetails(alarm.getDescription());
        ticket.setId(alarm.getTTicketId());
        ticket.setAlarmId(alarm.getId());
        ticket.setNodeId(alarm.getNodeId());
        ticket.setIpAddress(alarm.getIpAddr());
        return ticket;
    }

    @Override
    public void updateTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            LOG.error("No alarm with id {} was found. Ticket with id '{}' will not be updated.", (Object)alarmId, (Object)ticketId);
            return;
        }
        Ticket ticket = null;
        try {
            ticket = this.m_ticketerPlugin.get(ticketId);
            if (ticket.getState() == Ticket.State.CANCELLED) {
                alarm.setTTicketState(TroubleTicketState.CANCELLED);
            } else if (ticket.getState() == Ticket.State.CLOSED) {
                alarm.setTTicketState(TroubleTicketState.CLOSED);
            } else if (ticket.getState() == Ticket.State.OPEN) {
                alarm.setTTicketState(TroubleTicketState.OPEN);
            } else {
                alarm.setTTicketState(TroubleTicketState.OPEN);
            }
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.UPDATE_FAILED);
            LOG.error("Unable to update ticket for alarm: {}", (Object)e.getMessage());
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    @Override
    public void reloadTicketer() {
    }

    private Event createEvent(String reason) {
        EventBuilder bldr = new EventBuilder(COMMS_ERROR_UEI, "Ticketd");
        bldr.addParam("reason", reason);
        return bldr.getEvent();
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager ipcManager) {
        this.m_eventIpcManager = ipcManager;
    }

    @Override
    public void setTicketerPlugin(Plugin plugin) {
        this.m_ticketerPlugin = Objects.requireNonNull(plugin, "plugin cannot be null");
    }
}

