(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["onms-geoservice"],{

/***/ "./src/main/assets/js/apps/onms-elementList/lib/elementList.js":
/*!*********************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/lib/elementList.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! ../templates/angular-onms-elementList-editListInPlace.html */ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html"), __webpack_require__(/*! ../templates/angular-onms-elementList-editMapInPlace.html */ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, angular, jQuery, editListInPlaceTemplate, editMapInPlaceTemplate) {
	'use strict';

	var MODULE_NAME = 'onms.elementList';

	/**
  * ISO-8601 date format string.
  */
	window.ISO_8601_DATE_FORMAT = 'yyyy-MM-ddTHH:mm:ss.sssZ';
	window.ISO_8601_DATE_FORMAT_WITHOUT_MILLIS = 'yyyy-MM-ddTHH:mm:ssZ';

	/**
  * Function used to append an extra transformer to the default $http transforms.
  */
	var appendTransform = function appendTransform(defaultTransform, transform) {
		var t = angular.isArray(defaultTransform) ? defaultTransform : [defaultTransform];
		return t.concat(transform);
	};

	/**
  * Convert from a clause into a FIQL query string.
  */
	var toFiql = function toFiql(clauses) {
		var first = true;
		var fiql = '';
		for (var i = 0; i < clauses.length; i++) {
			if (!first) {
				fiql += ';';
			}
			fiql += clauses[i].property;

			switch (clauses[i].operator) {
				case 'EQ':
					fiql += '==';break;
				case 'NE':
					fiql += '!=';break;
				case 'LT':
					fiql += '=lt=';break;
				case 'LE':
					fiql += '=le=';break;
				case 'GT':
					fiql += '=gt=';break;
				case 'GE':
					fiql += '=ge=';break;
				default:
					// otherwise, do nothing
					break;
			}

			fiql += escapeSearchValue(clauses[i].value);

			first = false;
		}
		return fiql;
	};

	/**
  * Convert from a FIQL query string into separate clause objects.
  * This only works for simple queries composed of multiple AND (';')
  * clauses.
  * 
  * TODO: Expand this to cover more FIQL syntax
  */
	var fromFiql = function fromFiql(fiql) {
		var statements = fiql.split(';');
		var segments = [];
		var clauses = [];
		for (var i = 0; i < statements.length; i++) {
			if (statements[i].indexOf('==') > 0) {
				segments = statements[i].split('==');
				clauses.push({
					property: segments[0],
					operator: 'EQ',
					value: segments[1]
				});
			} else if (statements[i].indexOf('!=') > 0) {
				segments = statements[i].split('!=');
				clauses.push({
					property: segments[0],
					operator: 'NE',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=lt=') > 0) {
				segments = statements[i].split('=lt=');
				clauses.push({
					property: segments[0],
					operator: 'LT',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=le=') > 0) {
				segments = statements[i].split('=le=');
				clauses.push({
					property: segments[0],
					operator: 'LE',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=gt=') > 0) {
				segments = statements[i].split('=gt=');
				clauses.push({
					property: segments[0],
					operator: 'GT',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=ge=') > 0) {
				segments = statements[i].split('=ge=');
				clauses.push({
					property: segments[0],
					operator: 'GE',
					value: segments[1]
				});
			}
		}
		return clauses;
	};

	/**
  * Parse an HTTP Content-Range header into the start, end, and total fields.
  * The header should be in a format like: "items 0-14/28".
  * 
  * @param contentRange String from the Content-Range header
  */
	var parseContentRange = function parseContentRange(contentRange) {
		if (!contentRange) {
			return { start: 0, end: 0, total: 0 };
		}
		// Example: items 0-14/28
		var pattern = /items\s+?(\d+)\s*-\s*(\d+)\s*\/\s*(\d+)/;
		return {
			start: Number(contentRange.replace(pattern, '$1')),
			end: Number(contentRange.replace(pattern, '$2')),
			total: Number(contentRange.replace(pattern, '$3'))
		};
	};

	/**
  * Escape FIQL reserved characters by URL-encoding them. Reserved characters are:
  * <ul>
  * <li>!</li>
  * <li>$</li>
  * <li>'</li>
  * <li>(</li>
  * <li>)</li>
  * <li>*</li>
  * <li>+</li>
  * <li>,</li>
  * <li>;</li>
  * <li>=</li>
  * </ul>
  * @param value
  * @returns String with reserved characters URL-encoded
  */
	var escapeSearchValue = function escapeSearchValue(value) {
		if (typeof value === 'string') {
			return value.replace('!', '%21').replace('$', '%24').replace('\'', '%27').replace('(', '%28').replace(')', '%29')
			// People are going to type this in as a wildcard, so I
			// guess they'll have to type in '%2A' if they want to
			// match an asterisk...
			//.replace('*', '%2A')
			.replace('+', '%2B').replace(',', '%2C').replace(';', '%3B').replace('=', '%3D');
		}
		return value;
	};

	var normalizeOffset = function normalizeOffset(offset, maxOffset, limit) {
		var newOffset = offset;

		// Offset of the last page
		var lastPageOffset = void 0;
		if (maxOffset < 0) {
			newOffset = 0;
			lastPageOffset = 0;
		} else {
			lastPageOffset = Math.floor(maxOffset / limit) * limit;
		}

		// Bounds checking
		newOffset = newOffset < 0 ? 0 : newOffset;
		newOffset = newOffset > lastPageOffset ? lastPageOffset : newOffset;

		// Make sure that offset is a multiple of limit
		newOffset = Math.floor(newOffset / limit) * limit;

		return newOffset;
	};

	/* // BMR: this doesn't seem to actually be used anywhere
 String.prototype.endsWith = function(suffix) {
 	return this.indexOf(suffix, this.length - suffix.length) !== -1;
 };
 */

	// $filters that can be used to create human-readable versions of filter values
	angular.module('onmsListFilters', []).filter('operator', function () {
		return function (input, value) {
			// See if the string contains a wildcard
			var fuzzy = typeof value === 'string' && value.indexOf('*') > -1;

			switch (input) {
				case 'EQ':
					return fuzzy ? 'is like' : 'equals';
				case 'NE':
					return fuzzy ? 'is not like' : 'does not equal';
				case 'LT':
					return 'is less than';
				case 'LE':
					return 'is less than or equal';
				case 'GT':
					return 'is greater than';
				case 'GE':
					return 'is greater than or equal';
				default:
					// If no match, return the input
					return input;
			}
		};
	}).filter('isNotEmpty', function () {
		return function (input) {
			return input && (typeof input === 'string' ? input.trim() !== '' : true);
		};
	});

	// List module
	angular.module(MODULE_NAME, []).config(['$locationProvider', function ($locationProvider) {
		$locationProvider.html5Mode({
			// Use HTML5 
			enabled: true,
			// Don't rewrite all <a> links on the page
			rewriteLinks: false
		});
	}]).directive('onmsListEditInPlace', function () {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;
				$scope.originalValue = angular.copy($scope.value);

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					$scope.editing = false;
				};

				$scope.onKeyup = function ($event) {
					// If the user types ESC, then abort the edit
					if ($event.keyCode === 27) {
						$scope.cancel();
					}
				};

				$scope.submit = function () {
					$scope.onSubmit();
					// TODO: Handle update failures
					// Now that we've save a new value, use it as the original value
					$scope.originalValue = $scope.value;
					// Switch out of edit mode
					$scope.unedit();
				};

				$scope.cancel = function () {
					// Restore the original value
					$scope.value = $scope.originalValue;
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				item: '=',
				value: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onSubmit: '&onSubmit'
			},
			templateUrl: editListInPlaceTemplate,
			transclude: true
		};
	}).directive('onmsListEditListInPlace', ['$window', function ($window) {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					// Undo any edits
					$scope.newValue = null;
					$scope.editing = false;
				};

				$scope.onKeyup = function (event) {
					switch (event.keyCode) {
						// If the user types Enter, then submit the edit
						case 13:
							$scope.add($scope.values, $scope.newValue);break;
						// If the user types ESC, then abort the edit
						case 27:
							$scope.unedit();break;
						// otherwise, do nothing
						default:
							break;
					}
				};

				$scope.confirmAndRemove = function (items, item) {
					// Splice the value out of the array
					if ($window.confirm('Are you sure you want to remove "' + item + '"?')) {
						items.splice(items.indexOf(item), 1);
						$scope.onEdit();
					}
				};

				$scope.add = function (items, item) {
					items.push(item);
					items.sort();
					// TODO: Handle update failures
					$scope.onEdit();
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				values: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onEdit: '&onEdit'
			},
			templateUrl: editListInPlaceTemplate,
			transclude: true
		};
	}]).directive('onmsListEditMapInPlace', ['$window', function ($window) {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					// Undo any edits
					$scope.newKey = null;
					$scope.newValue = null;
					$scope.editing = false;
				};

				$scope.onKeyup = function (event) {
					switch (event.keyCode) {
						// If the user types Enter, then submit the edit
						case 13:
							$scope.add($scope.values, $scope.newKey, $scope.newValue);break;
						// If the user types ESC, then abort the edit
						case 27:
							$scope.unedit();break;
						// otherwise, do nothing
						default:
							break;
					}
				};

				$scope.confirmAndRemove = function (items, key) {
					// Splice the value out of the array
					if ($window.confirm('Are you sure you want to remove "' + key + '"?')) {
						delete items[key];
						$scope.onEdit();
					}
				};

				$scope.add = function (items, key, value) {
					items[key] = value;
					// TODO: Handle update failures
					$scope.onEdit();
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				values: '=',
				keyType: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onEdit: '&onEdit'
			},
			templateUrl: editMapInPlaceTemplate,
			transclude: true
		};
	}])

	/**
  * Generic list controller
  */
	.controller('ListCtrl', ['$scope', '$location', '$window', '$log', '$filter', function ($scope, $location, $window, $log, $filter) {
		$log.debug('ListCtrl initializing...');

		$scope.defaults = {
			_s: '',
			searchClauses: [],
			limit: 20,
			offset: 0,
			orderBy: '',
			order: 'asc'
		};

		var initialLimit = typeof $location.search().limit === 'undefined' ? $scope.defaults.limit : Number($location.search().limit) > 0 ? Number($location.search().limit) : $scope.defaults.limit;

		// Restore any query parameters that you can from the 
		// query string, blank out the rest
		$scope.query = {
			lastOffset: 0,
			maxOffset: 0,

			searchParam: typeof $location.search()._s === 'undefined' ? $scope.defaults._s : $location.search()._s,
			searchClauses: typeof $location.search()._s === 'undefined' ? $scope.defaults.searchClauses : fromFiql($location.search()._s),
			limit: initialLimit,
			newLimit: initialLimit,
			offset: typeof $location.search().offset === 'undefined' ? $scope.defaults.offset : Number($location.search().offset) > 0 ? normalizeOffset(Number($location.search().offset), Number.MAX_VALUE, initialLimit) : $scope.defaults.offset,

			// TODO: Validate that the orderBy is in a list of supported properties
			orderBy: typeof $location.search().orderBy === 'undefined' ? $scope.defaults.orderBy : $location.search().orderBy,
			order: typeof $location.search().order === 'undefined' ? $scope.defaults.order : $location.search().order === 'asc' ? 'asc' : 'desc'
		};

		// Sync the query hash with the $location query string
		$scope.$watch('query', function () {
			var queryParams = angular.copy($scope.query);

			// Delete derived values that we don't need in the query string
			delete queryParams.searchClauses;
			delete queryParams.newLimit;
			delete queryParams.lastOffset;
			delete queryParams.maxOffset;

			// Rename searchParam to _s
			queryParams._s = queryParams.searchParam === '' ? null : queryParams.searchParam;
			delete queryParams.searchParam;

			// Delete any parameters that have default or blank values
			if (queryParams.limit === $scope.defaults.limit || queryParams.limit === '') {
				delete queryParams.limit;
			}
			if (queryParams.offset === $scope.defaults.offset || queryParams.offset === '') {
				delete queryParams.offset;
			}
			if (queryParams.orderBy === $scope.defaults.orderBy || queryParams.orderBy === '') {
				delete queryParams.orderBy;
			}
			if (queryParams.order === $scope.defaults.order || queryParams.order === '') {
				delete queryParams.order;
			}
			if (queryParams._s === $scope.defaults._s || queryParams._s === '') {
				delete queryParams._s;
			}

			$location.search(queryParams);
		}, true // Use object equality because the reference doesn't change
		);

		// Add the search clause to the list of clauses
		$scope.addSearchClause = function (clause) {
			if (angular.isDate(clause.value)) {
				// Returns a value in yyyy-MM-ddTHH:mm:ss.sssZ format
				// Unfortunately, I don't think CXF will like this because
				// it includes the millisecond portion of the date.
				//clause.value = new Date(clause.value).toISOString();

				clause.value = $filter('date')(new Date(clause.value), ISO_8601_DATE_FORMAT);
			}

			// Make sure the clause isn't already in the list of search clauses
			if ($scope.getSearchClause(clause)) {
				return;
			}

			// TODO: Add validation?
			$scope.query.searchClauses.push(angular.copy(clause));
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		$scope.getSearchClause = function (clause) {
			for (var i = 0; i < $scope.query.searchClauses.length; i++) {
				if ($scope.clauseEquals(clause, $scope.query.searchClauses[i])) {
					return $scope.query.searchClauses[i];
				}
			}
			return null;
		};

		$scope.clauseEquals = function (a, b) {
			return a.property === b.property && a.operator === b.operator && a.value === b.value;
		};

		// Convert an epoch timestamp into String format before adding the search clause
		$scope.addEpochTimestampSearchClause = function (clause) {
			clause.value = $filter('date')(clause.value, ISO_8601_DATE_FORMAT);
			$scope.addSearchClause(clause);
		};

		// Remove a search clause from the list of clauses
		$scope.removeSearchClause = function (clause) {
			// TODO: Add validation?
			$scope.query.searchClauses.splice($scope.query.searchClauses.indexOf(clause), 1);
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		$scope.removeSearchClauses = function (clauses) {
			for (var i = 0; i < clauses.length; i++) {
				var index = $scope.query.searchClauses.indexOf(clauses[i]);
				if (index >= 0) {
					$scope.query.searchClauses.splice(index, 1);
				}
			}
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		// Replace a search clause with a new clause
		$scope.replaceSearchClause = function (oldClause, newClause) {
			if (angular.isDate(newClause.value)) {
				// Returns a value in yyyy-MM-ddTHH:mm:ss.sssZ format
				// Unfortunately, I don't think CXF will like this because
				// it includes the millisecond portion of the date.
				//clause.value = new Date(clause.value).toISOString();

				newClause.value = $filter('date')(new Date(newClause.value), ISO_8601_DATE_FORMAT);
			}

			// TODO: Add validation?
			var scopeOldClause = $scope.getSearchClause(oldClause);
			var scopeNewClause = $scope.getSearchClause(newClause);
			if (!scopeOldClause) {
				if (!scopeNewClause) {
					// If the old clause is not present, simply add the new clause
					$scope.addSearchClause(newClause);
				} else {
					// If the old clause is not present and the new clause is already
					// present, then do nothing
				}
			} else {
				if (!scopeNewClause) {
					// If the old clause is present and the new clause is not, replace
					// the values inside the old clause and then refresh
					scopeOldClause.property = newClause.property;
					scopeOldClause.operator = newClause.operator;
					scopeOldClause.value = newClause.value;

					$scope.query.searchParam = toFiql($scope.query.searchClauses);
					$scope.refresh();
				} else {
					// If the old clause is present and the new clause is present,
					// then just remove the old clause (as if it had been replaced by
					// the already-existing new clause)
					$scope.removeSearchClause(oldClause);
				}
			}
		};

		// Clear the current search
		$scope.clearSearch = function () {
			if ($scope.query.searchClauses.length > 0) {
				$scope.query.searchClauses = [];
				$scope.query.searchParam = '';
				$scope.refresh();
			}
		};

		// Change the sorting of the table
		$scope.changeOrderBy = function (property) {
			if ($scope.query.orderBy === property) {
				// TODO: Figure out if we should reset limit/offset here also
				// If the property is already selected then reverse the sorting
				$scope.query.order = $scope.query.order === 'asc' ? 'desc' : 'asc';
			} else {
				// TODO: Figure out if we should reset limit/offset here also
				$scope.query.orderBy = property;
				$scope.query.order = $scope.defaults.order;
			}
			$scope.refresh();
		};

		$scope.setOffset = function (offset) {
			var o = normalizeOffset(offset, $scope.query.maxOffset, $scope.query.limit);

			if ($scope.query.offset !== o) {
				$scope.query.offset = o;
				$scope.refresh();
			}
		};

		$scope.setLimit = function (limit) {
			if (limit < 1) {
				$scope.query.newLimit = $scope.query.limit;
				// TODO: Throw a validation error
				return;
			}
			if ($scope.query.limit !== limit) {
				$scope.query.limit = limit;
				$scope.query.offset = normalizeOffset($scope.query.offset, $scope.query.maxOffset, $scope.query.limit);
				$scope.refresh();
			}
		};

		// Override this to implement updates to an object
		$scope.refresh = function () {
			$log.warn('You need to override $scope.$parent.refresh() in your controller');
		};

		// Override this to implement updates to an object
		$scope.update = function () {
			$log.warn('You need to override $scope.$parent.update() in your controller');
		};

		// Override this to implement deletions
		$scope.deleteItem = function (item) {
			$log.warn('You need to override $scope.$parent.deleteItem() in your controller');
		};

		$log.debug('ListCtrl initialized');
	}]).run(['$rootScope', '$log', function ($rootScope, $log) {
		$log.debug('Finished initializing ' + MODULE_NAME);
	}]);

	/*
 angular.element(document).ready(function() {
 	console.log('Bootstrapping ' + MODULE_NAME);
 	angular.bootstrap(document, [MODULE_NAME]);
 });
 */

	module.exports = {
		appendTransform: appendTransform,
		toFiql: toFiql,
		fromFiql: fromFiql,
		parseContentRange: parseContentRange,
		escapeSearchValue: escapeSearchValue,
		normalizeOffset: normalizeOffset
	};
});

/***/ }),

/***/ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html":
/*!**********************************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html ***!
  \**********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html';
var html = "<!-- Show all of the current values -->\n<span ng-repeat=\"value in values\">\n\t<button class=\"btn btn-sm btn-secondary\" ng-click=\"confirmAndRemove(values, value)\" style=\"margin-bottom:3px;margin-right:3px;\">\n\t\t{{value}}&nbsp;<i class=\"fa fa-close\"/>\n\t</button>\n</span>\n\n<!-- Edit button -->\n<span style=\"line-height:24px;\" ng-hide=\"editing\">\n\t<a href style=\"text-decoration: none;\" ng-click=\"edit()\"><i class=\"fa fa-edit fa-lg\"/></a>&nbsp;\n</span>\n\n<!-- TODO: Add the ability to support select controls -->\n<!-- Input for new item -->\n<span ng-show=\"editing\" class=\"text-nowrap\">\n\t<input type=\"{{valueType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newValue\"/>\n\t<a href style=\"text-decoration: none;\" ng-click=\"add(values, newValue)\"><i class=\"fa fa-plus fa-lg\"/></a>\n\t<a href style=\"text-decoration: none;\" ng-click=\"unedit()\"><i class=\"fa fa-close fa-lg\"/></a>\n</span>\n\n<!-- Transclude any content inside the tag -->\n<span ng-transclude/>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html":
/*!*********************************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html ***!
  \*********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html';
var html = "<!-- Show all of the current values -->\n<span ng-repeat=\"(key,value) in values\">\n\t<button class=\"btn btn-sm btn-secondary\" ng-click=\"confirmAndRemove(values, key)\" style=\"margin-bottom:3px;margin-right:3px;\">\n\t\t<b>{{key}}:</b> {{value}}&nbsp;<i class=\"fa fa-close\"/>\n\t</button>\n</span>\n\n<!-- Edit button -->\n<span style=\"line-height:24px;\" ng-hide=\"editing\">\n\t<a href style=\"text-decoration: none;\" ng-click=\"edit()\"><i class=\"fa fa-edit fa-lg\"/></a>&nbsp;\n</span>\n\n<!-- TODO: Add the ability to support select controls -->\n<!-- Input for new item -->\n<span ng-show=\"editing\" class=\"text-nowrap\">\n\t<input type=\"{{keyType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newKey\"/>\n\t<input type=\"{{valueType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newValue\"/>\n\t<a href style=\"text-decoration: none;\" ng-click=\"add(values, newKey, newValue)\"><i class=\"fa fa-plus fa-lg\"/></a>\n\t<a href style=\"text-decoration: none;\" ng-click=\"unedit()\"><i class=\"fa fa-close fa-lg\"/></a>\n</span>\n\n<!-- Transclude any content inside the tag -->\n<span ng-transclude/>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/index.js":
/*!**********************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/index.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! ../onms-elementList/lib/elementList */ "./src/main/assets/js/apps/onms-elementList/lib/elementList.js"), __webpack_require__(/*! ./views/index.html */ "./src/main/assets/js/apps/onms-geoservice/views/index.html"), __webpack_require__(/*! ./views/config.html */ "./src/main/assets/js/apps/onms-geoservice/views/config.html"), __webpack_require__(/*! ./views/config/nominatim.html */ "./src/main/assets/js/apps/onms-geoservice/views/config/nominatim.html"), __webpack_require__(/*! ./views/config/google.html */ "./src/main/assets/js/apps/onms-geoservice/views/config/google.html"), __webpack_require__(/*! ./views/config/mapquest.html */ "./src/main/assets/js/apps/onms-geoservice/views/config/mapquest.html"), __webpack_require__(/*! ../../lib/onms-http */ "./src/main/assets/js/lib/onms-http/index.js"), __webpack_require__(/*! angular-bootstrap-toggle/dist/angular-bootstrap-toggle */ "./node_modules/angular-bootstrap-toggle/dist/angular-bootstrap-toggle.js"), __webpack_require__(/*! angular-bootstrap-toggle/dist/angular-bootstrap-toggle.css */ "./node_modules/angular-bootstrap-toggle/dist/angular-bootstrap-toggle.css"), __webpack_require__(/*! angular-ui-router */ "./node_modules/angular-ui-router/lib/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (angular, elementList, indexTemplate, configTemplate, nominatimTemplate, googleTemplate, mapquestTemplate) {
    'use strict';

    (function () {
        'use strict';

        var MODULE_NAME = 'onms.geoservice';

        angular.module(MODULE_NAME, ['angular-loading-bar', 'angular-growl', 'ngResource', 'ui.router', 'ui.toggle', 'onms.http', 'onms.elementList']).config(['$locationProvider', function ($locationProvider) {
            $locationProvider.hashPrefix('!');
            $locationProvider.html5Mode(false);
        }]).config(['growlProvider', function (growlProvider) {
            growlProvider.globalTimeToLive({ success: 2000, error: 5000, warning: 3000, info: 4000 });
            growlProvider.globalPosition('bottom-center');
        }]).config(['$stateProvider', '$urlRouterProvider', function ($stateProvider, $urlRouterProvider) {
            $stateProvider.state('geocoding', {
                url: '/geocoding',
                controller: 'GeocoderController',
                templateUrl: indexTemplate
            }).state('geocoding.config', {
                templateUrl: configTemplate,
                url: '/config',
                controller: 'GeocoderConfigController'
            }).state('geocoding.details', {
                templateUrl: function templateUrl($stateParams) {
                    return __webpack_require__("./src/main/assets/js/apps/onms-geoservice/views/config sync recursive ^\\.\\/.*\\.html$")("./" + $stateParams.id + '.html');
                },
                url: '/:id',
                controller: 'GeocoderDetailsController'
            });
            $urlRouterProvider.otherwise('/geocoding/config');
        }]).filter('capitalize', function () {
            return function (input) {
                return input ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
            };
        }).factory('GeocodingConfigService', ['$resource', function ($resource) {
            return $resource('api/v2/geocoding/config', {}, {
                'get': { method: 'GET' },
                'update': { method: 'POST' }
            });
        }]).factory('GeocodingGeocoderService', ['$resource', function ($resource) {
            return $resource('api/v2/geocoding/geocoders/:id', { id: '@id' }, {
                'list': { method: 'GET', isArray: true },
                'update': { method: 'POST' }
            });
        }]).controller('GeocoderController', ['$scope', '$http', '$sce', 'GeocodingConfigService', 'GeocodingGeocoderService', function ($scope, $http, $sce, GeocodingConfigService, GeocodingGeocoderService) {

            $scope.handleGlobalError = function (errorResponse) {
                $scope.globalError = "An unexpected error occurred: " + errorResponse.statusText;
                $scope.globalErrorDetails = JSON.stringify(errorResponse, null, 2);
            };

            $scope.refreshTabs = function () {
                $scope.config = {
                    enabled: false,
                    activeGeocoderId: undefined
                };
                $scope.geocoders = [];
                $scope.globalError = undefined;

                return GeocodingConfigService.get(function (configResponse) {
                    $scope.config = configResponse;
                }, function (errorResponse) {
                    $scope.handleGlobalError(errorResponse);
                }).$promise.then(function () {
                    return GeocodingGeocoderService.list(function (response) {
                        $scope.geocoders = response;
                        $scope.geocoders.forEach(function (item) {
                            item.name = item.id;
                            item.active = $scope.config.activeGeocoderId === item.id;
                        });
                        $scope.geocoders.sort(function (a, b) {
                            return a.name.localeCompare(b.name);
                        });
                    }, function (errorResponse) {
                        $scope.handleGlobalError(errorResponse);
                    }).$promise;
                });
            };
        }]).controller('GeocoderConfigController', ['$scope', 'growl', function ($scope, growl) {
            $scope.onGeocoderChange = function (selection) {
                $scope.config.activeGeocoderId = selection.active ? selection.id : undefined;
                $scope.config.$update(function (response) {
                    growl.success('Changes saved successfully');
                    $scope.geocoders.forEach(function (item) {
                        item.active = $scope.config.activeGeocoderId === item.id;
                    });
                }, function (response) {
                    $scope.handleGlobalError(response);
                });
            };

            $scope.refreshTabs();
        }]).controller('GeocoderDetailsController', ['$scope', '$stateParams', 'growl', function ($scope, $stateParams, growl) {
            $scope.geocoders = [];
            $scope.geocoder = undefined;
            $scope.configError = {};
            $scope.manualValidation = {
                'mapquest': function mapquest() {
                    return true;
                },
                'google': function google() {
                    return true;
                },
                'nominatim': function nominatim() {
                    // Ensure that either referer or userAgent are defined
                    $scope.configError['userAgent'] = undefined;
                    $scope.configError['referer'] = undefined;

                    if (!$scope.geocoder.config.userAgent && !$scope.geocoder.config.referer) {
                        $scope.configError['userAgent'] = 'User Agent or Referer must be set';
                        $scope.configError['referer'] = $scope.configError['userAgent'];
                        return false;
                    }
                    return true;
                }
            };

            $scope.handleGeocoderConfigErrors = function (errorObject) {
                if (errorObject.context && errorObject.message) {
                    $scope.configError[errorObject.context] = errorObject.message;
                } else if (errorObject.context) {
                    $scope.configError[errorObject.context] = 'Invalid value';
                } else {
                    growl.error('The configuration is not valid. Details were not provided');
                }
            };

            $scope.save = function () {
                if ($scope.geocoder) {
                    if (!$scope.validateFieldsManually()) {
                        return;
                    }
                    // Now update
                    $scope.configError = {};
                    $scope.geocoder.$update(function () {
                        growl.success('Changes saved successfully.');
                        $scope.form.$setPristine();

                        // The data cannot be reloaded from the backend as the bundles will be refreshed and the
                        // ReST service will most like not be available. To avoid 404s, we assume on success everything is fine
                        // as otherwise the response would be a 400 with information what exactly is not okay
                        $scope.geocoder.error = undefined;
                    }, function (response) {
                        if (response.status === 400 && response.data) {
                            $scope.handleGeocoderConfigErrors(response.data);
                        } else {
                            $scope.handleGlobalError(response);
                        }
                    });
                }
            };

            // Some fields need manual validation
            $scope.validateFieldsManually = function () {
                var manualValidation = $scope.manualValidation[$scope.geocoder.id];
                if (manualValidation) {
                    return manualValidation();
                }
                return true;
            };

            // Refresh data
            $scope.refreshTabs().then(function (geocoders) {
                var matchingGeocoders = geocoders.filter(function (item) {
                    return item.id === $stateParams.id;
                });
                if (matchingGeocoders.length > 0) {
                    $scope.geocoder = matchingGeocoders[0];
                    if ($scope.geocoder.error) {
                        $scope.handleGeocoderConfigErrors($scope.geocoder.error);
                    }
                }
            });
        }]);
    })();

    // Dynamically referenced
});

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/config sync recursive ^\\.\\/.*\\.html$":
/*!**********************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/config sync ^\.\/.*\.html$ ***!
  \**********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./google.html": "./src/main/assets/js/apps/onms-geoservice/views/config/google.html",
	"./mapquest.html": "./src/main/assets/js/apps/onms-geoservice/views/config/mapquest.html",
	"./nominatim.html": "./src/main/assets/js/apps/onms-geoservice/views/config/nominatim.html"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) { // check for number or string
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return id;
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./src/main/assets/js/apps/onms-geoservice/views/config sync recursive ^\\.\\/.*\\.html$";

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/config.html":
/*!*******************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/config.html ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-geoservice/views/config.html';
var html = "<div class=\"\">\n    <form class=\"form\" name=\"configForm\">\n        <div ng-repeat=\"geocoder in geocoders\">\n            <div class=\"mt-3 ml-2\">\n                <label style=\"width: 100px\">{{geocoder.id | capitalize}}</label>\n                <toggle id=\"{{geocoder.id}}-toggle\"\n                        class=\"mr-2\"\n                        ng-change=\"onGeocoderChange(geocoder)\"\n                        ng-model=\"geocoder.active\"\n                        size=\"btn-sm\"\n                />\n                <span class=\"text-muted\" ng-show=\"geocoder.active && geocoder.error\">\n                    <a ui-sref=\"geocoding.details({'id': geocoder.id})\">Please configure the Geocoder</a>\n                </span>\n            </div>\n        </div>\n    </form>\n</div>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/config/google.html":
/*!**************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/config/google.html ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-geoservice/views/config/google.html';
var html = "<div>\n    <form class=\"form\" name=\"form\">\n        <div class=\"jumbotron\">\n            <p>\n                The Google Geocoding API is a service that provides geocoding and reverse geocoding of addresses.\n            </p>\n            <p>\n                For more information refer to the <a href=\"https://developers.google.com/maps/documentation/geocoding/start\" target=\"_blank\">official documentation</a>.\n            </p>\n        </div>\n        <div class=\"form-group\">\n            <div class=\"form-check\">\n                <input\n                        class=\"form-check-input\"\n                        type=\"checkbox\"\n                        id=\"googleClientIdAuthentication\"\n                        name=\"googleClientIdAuthentication\"\n                        ng-model=\"geocoder.config.useEnterpriseCredentials\"\n                >\n                <label class=\"form-check-label\" for=\"googleClientIdAuthentication\">\n                    Use clientId and signature to authenticate\n                </label>\n            </div>\n        </div>\n\n        <div class=\"form-group\" ng-if=\"!geocoder.config.useEnterpriseCredentials\">\n            <label for=\"googleApiKey\">API Key</label>\n            <input id=\"googleApiKey\"\n                   name=\"googleApiKey\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-required=\"true\"\n                   ng-model=\"geocoder.config.apiKey\"\n                   ng-class=\"{ 'is-invalid' : form.googleApiKey.$invalid || configError.apiKey }\"\n            />\n            <p id=\"configError.apiKey\" class=\"invalid-feedback\">{{configError.apiKey || \"Please provide a value\"}}</p>\n        </div>\n        <div class=\"form-group\" ng-if=\"geocoder.config.useEnterpriseCredentials\">\n            <label for=\"googleClientId\">Client ID</label>\n            <input id=\"googleClientId\"\n                   name=\"googleClientId\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-required=\"true\"\n                   ng-model=\"geocoder.config.clientId\"\n                   ng-class=\"{ 'is-invalid' : form.googleClientId.$invalid || configError.clientId }\"\n            />\n            <p id=\"configError.clientId\" class=\"invalid-feedback\">{{configError.clientId || \"Please provide a value\"}}</p>\n        </div>\n        <div class=\"form-group\" ng-if=\"geocoder.config.useEnterpriseCredentials\">\n            <label for=\"googleClientKey\">Signature</label>\n            <input id=\"googleClientKey\"\n                   name=\"googleClientKey\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-required=\"true\"\n                   ng-model=\"geocoder.config.signature\"\n                   ng-class=\"{ 'is-invalid' : form.googleClientKey.$invalid || configError.signature }\"\n            />\n            <p id=\"configError.signature\" class=\"invalid-feedback\">{{configError.signature || \"Please provide a value\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"googleTimeout\">Timeout (ms)</label>\n            <input id=\"googleTimeout\"\n                   name=\"googleTimeout\"\n                   min=\"0\"\n                   class=\"form-control\"\n                   type=\"number\"\n                   ng-model=\"geocoder.config.timeout\"\n                   ng-class=\"{ 'is-invalid' : form.googleTimeout.$invalid || configError.timeout }\"\n            />\n            <p id=\"configError.timeout\" class=\"invalid-feedback\">{{configError.timeout || \"Timeout must be >= 0\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"mr-2\" for=\"googleSystemProxy\">Use System Proxy</label>\n            <toggle id=\"googleSystemProxy\" \n                    name=\"googleSystemProxy\"\n                    ng-model=\"geocoder.config.useSystemProxy\" \n                    on=\"Yes\" \n                    off=\"No\"\n                    size=\"btn-sm\"\n                    ng-class=\"{ 'is-invalid' : form.googleSystemProxy.$invalid || configError.useSystemProxy }\"\n            />\n            <p id=\"configError.useSystemProxy\" class=\"invalid-feedback\">{{configError.useSystemProxy}}</p>\n        </div>\n\n        <p class=\"text-warning\" ng-if=\"form.$dirty\">You have unsaved changes</p>\n        <button id=\"saveButton\" class=\"btn btn-primary\" type=\"button\" ng-click=\"save()\" ng-disabled=\"!form.$dirty || form.$invalid || validateFieldsManually() !== true\"><i class=\"fa fa-save\"></i> Save</button>\n    </form>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/config/mapquest.html":
/*!****************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/config/mapquest.html ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-geoservice/views/config/mapquest.html';
var html = "<div>\n\n    <div class=\"jumbotron\">\n        <p>\n            In order to use Mapquest, you must register and sign up for an API Key.\n        </p>\n        <p>\n            For more information visit the <a href=\"https://developer.mapquest.com/documentation/geocoding-api/\" target=\"_blank\">Mapquest Geocoding API Page</a>.\n        </p>\n    </div>\n\n    <form class=\"form\" name=\"form\">\n        <div class=\"form-group\">\n            <label for=\"mapquestApiKey\">API Key</label>\n            <input id=\"mapquestApiKey\"\n                   name=\"mapquestApiKey\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-required=\"true\"\n                   ng-model=\"geocoder.config.apiKey\"\n                   ng-class=\"{ 'is-invalid' : form.mapquestApiKey.$invalid || configError.apiKey }\"\n            />\n            <p id=\"configError.apiKey\" class=\"invalid-feedback\">{{configError.apiKey || \"Please provide a value\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"mapquestSystemProxy\" class=\"mr-2\">Use System Proxy</label>\n            <toggle id=\"mapquestSystemProxy\"\n                    name=\"mapquestSystemProxy\"\n                    ng-model=\"geocoder.config.useSystemProxy\"\n                    on=\"Yes\"\n                    off=\"No\"\n                    size=\"btn-sm\"\n                    ng-class=\"{ 'is-invalid' : form.mapquestSystemProxy.$invalid || configError.useSystemProxy }\"\n            />\n            <p id=\"configError.useSystemProxy\" class=\"invalid-feedback\">{{configError.useSystemProxy}}</p>\n        </div>\n\n        <p class=\"text-warning\" ng-if=\"form.$dirty\">You have unsaved changes</p>\n        <button id=\"saveButton\" class=\"btn btn-primary\" type=\"button\" ng-click=\"save()\" ng-disabled=\"!form.$dirty || form.$invalid || validateFieldsManually() !== true\"><i class=\"fa fa-save\"></i> Save</button>\n    </form>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/config/nominatim.html":
/*!*****************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/config/nominatim.html ***!
  \*****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-geoservice/views/config/nominatim.html';
var html = "<div>\n\n    <div class=\"jumbotron\">\n        <p>\n            Nominatim is a search engine for OpenStreetMap data.\n            It allows to look up the coordinates for a given address (forward search).\n        </p>\n        <p>\n            For more information visit the <a href=\"https://wiki.openstreetmap.org/wiki/Nominatim\" target=\"_blank\">Nominatim Wiki Page</a>.\n        </p>\n        <p>\n            Please note, that all usage of the Nominatim Service must follow the <a href=\"https://operations.osmfoundation.org/policies/nominatim/\" target=\"_blank\">Nominatim Usage Policy</a>.\n        </p>\n    </div>\n\n    <form class=\"form\" name=\"form\">\n        <div class=\"form-group\">\n            <label for=\"nominatimEmail\">Email</label>\n            <input id=\"nominatimEmail\"\n                   name=\"nominatimEmail\"\n                   class=\"form-control\"\n                   type=\"email\"\n                   ng-required=\"true\"\n                   ng-model=\"geocoder.config.email\"\n                   ng-class=\"{ 'is-invalid' : form.nominatimEmail.$invalid || configError.email }\"\n            />\n            <p id=\"configError.email\" class=\"invalid-feedback\">{{configError.email || \"Please provide a valid email address\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"nominatimUserAgent\">User Agent</label>\n            <input id=\"nominatimUserAgent\"\n                   name=\"nominatimUserAgent\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-model=\"geocoder.config.userAgent\"\n                   ng-change=\"validateFieldsManually()\"\n                   ng-class=\"{ 'is-invalid' : form.nominatimUserAgent.$invalid || configError.userAgent }\"\n            />\n            <p id=\"configError.userAgent\" class=\"invalid-feedback\">{{configError.userAgent || \"User Agent or Referer must be set\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"nominatimReferer\">Referer</label>\n            <input id=\"nominatimReferer\"\n                   name=\"nominatimReferer\"\n                   class=\"form-control\"\n                   type=\"text\"\n                   ng-model=\"geocoder.config.referer\"\n                   ng-change=\"validateFieldsManually()\"\n                   ng-class=\"{ 'is-invalid' : form.nominatimReferer.$invalid || configError.referer }\"\n            />\n            <p id=\"configError.referer\" class=\"invalid-feedback\">{{configError.referer || \"User Agent or Referer must be set\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label style=\"width: 180px\" for=\"nominatimAcceptUsageTerms\">Accept <a href=\"https://operations.osmfoundation.org/policies/nominatim/\" target=\"_blank\">Usage Terms <i class=\"fa fa-share-square-o\"/></a></label>\n            <toggle id=\"nominatimAcceptUsageTerms\"\n                    name=\"nominatimAcceptUsageTerms\"\n                    on=\"Yes\"\n                    off=\"No\"\n                    size=\"btn-sm\"\n                    ng-model=\"geocoder.config.acceptUsageTerms\"\n                    ng-class=\"{ 'is-invalid' : form.nominatimAcceptUsageTerms.$invalid || geocoder.config.acceptUsageTerms === false || configError.acceptUsageTerms }\"\n            />\n            <p id=\"configError.acceptUsageTerms\" class=\"invalid-feedback\">{{configError.acceptUsageTerms || \"Please accept the usage terms\"}}</p>\n        </div>\n        <div class=\"form-group\">\n            <label style=\"width: 180px\" for=\"nominatimSystemProxy\">Use System Proxy</label>\n            <toggle id=\"nominatimSystemProxy\"\n                    name=\"nominatimSystemProxy\"\n                    on=\"Yes\"\n                    off=\"No\"\n                    size=\"btn-sm\"\n                    ng-model=\"geocoder.config.useSystemProxy\"\n                    ng-class=\"{ 'is-invalid' : form.nominatimSystemProxy.$invalid || configError.useSystemProxy }\"\n            />\n            <p id=\"configError.useSystemProxy\" class=\"invalid-feedback\">{{configError.useSystemProxy}}</p>\n        </div>\n\n        <p class=\"text-warning\" ng-if=\"form.$dirty\">You have unsaved changes</p>\n        <button id=\"saveButton\" class=\"btn btn-primary\" type=\"button\" ng-click=\"save()\" ng-disabled=\"!form.$dirty || form.$invalid || validateFieldsManually() !== true\"><i class=\"fa fa-save\"></i> Save</button>\n    </form>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-geoservice/views/index.html":
/*!******************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-geoservice/views/index.html ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-geoservice/views/index.html';
var html = "<style type=\"text/css\">\n    toggle.is-invalid ~ .invalid-feedback {\n        display: block;\n    }\n</style>\n\n<div class=\"alert alert-danger\" ng-if=\"globalError\">\n    <span>{{globalError}}</span>\n    <pre ng-show=\"globalErrorDetails\">{{globalErrorDetails}}</pre>\n</div>\n\n<div class=\"\" class=\"w-100\" ng-if=\"!globalError\">\n    <ul id=\"tabs\" class=\"nav nav-tabs\">\n        <li role=\"presentation\" class=\"nav-item\">\n            <a ui-sref-active=\"active\" ui-sref=\"geocoding.config\" data-name=\"settings\" class=\"nav-link\">Settings</a>\n        </li>\n\n        <li role=\"presentation\" ng-repeat=\"geocoder in geocoders\" class=\"nav-item\">\n            <a ui-sref-active=\"active\" ui-sref=\"geocoding.details({'id': geocoder.id})\" title=\"{{geocoder.name | capitalize}}\" data-name={{geocoder.id}} class=\"nav-link\">\n                {{geocoder.name | capitalize}}\n                <span ng-if=\"geocoder.id === config.activeGeocoderId && !geocoder.error\" class=\"text-success\" title=\"Geocoder is enabled\"><i class=\"fa fa-circle\"></i></span>\n                <span ng-if=\"geocoder.id === config.activeGeocoderId && geocoder.error\" class=\"text-danger\" title=\"Geocoder is enabled but not configured properly\"><i class=\"fa fa-exclamation-triangle\"></i></span>\n            </a>\n        </li>\n    </ul>\n    <div growl></div>\n    <div class=\"card border-top-0\">\n        <div class=\"card-body\" ui-view>\n        </div>\n    </div>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/lib/onms-http/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/lib/onms-http/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (module, angular) {
    'use strict';

    angular.module('onms.http', []).config(['$httpProvider', function ($httpProvider) {
        $httpProvider.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
    }]);

    module.exports = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! ui-bootstrap4 */ "./node_modules/ui-bootstrap4/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  // angular-ui-boostrap for bootstrap 4

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/onms-geoservice/index.js","vendor"]]]);
});
//# sourceMappingURL=onms-geoservice.js.map