(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["onms-date-formatter"],{

/***/ "./src/main/assets/js/apps/onms-date-formatter/index.js":
/*!**************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-date-formatter/index.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! moment */ "./node_modules/moment/moment.js"), __webpack_require__(/*! js-joda */ "./node_modules/js-joda/dist/js-joda.esm.js"), __webpack_require__(/*! js-joda-timezone */ "./node_modules/js-joda-timezone/dist/js-joda-timezone.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, angular, moment, JSJoda) {
	'use strict';

	/* eslint no-console: 0 */

	function OnmsDateFormatter() {}

	OnmsDateFormatter.prototype.init = function init(readyCallback) {
		var self = this;
		var defaultFormat = "yyyy-MM-dd'T'HH:mm:ssxxx"; // eslint-disable-line quotes
		window._onmsZoneId = undefined;

		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function readystatechange() {
			try {
				if (xhr.readyState === XMLHttpRequest.DONE) {
					if (xhr.status === 200) {
						var config = JSON.parse(xhr.responseText);
						if (config.datetimeformatConfig && config.datetimeformatConfig.datetimeformat) {
							window._onmsDateTimeFormat = config.datetimeformatConfig.datetimeformat || defaultFormat;
							window._onmsZoneId = config.datetimeformatConfig.zoneId;
						} else {
							console.log('Error: datetimeformatConfig property not found:', config);
							window._onmsDateTimeFormat = defaultFormat;
						}
					} else {
						console.log('Error: failed to request format info: ' + xhr.status + ' ' + xhr.statusText);
						window._onmsDateTimeFormat = defaultFormat;
					}
					readyCallback(self, xhr.status);
				}
			} catch (e) {
				console.log('Error: failed to request format info: ', e);
				window._onmsDateTimeFormat = defaultFormat;
				readyCallback(self, xhr.status);
			}
		};
		xhr.open('GET', 'rest/info');
		xhr.setRequestHeader('Accept', 'application/json');
		xhr.send();
	};

	OnmsDateFormatter.prototype.assertInitialized = function assertInitialized() {
		if (!window._onmsDateTimeFormat) {
			console.log('OnmsDateFormatter.init() must complete before using!');
			throw new Error('OnmsDateFormatter.init() must complete before using!');
		}
	};

	OnmsDateFormatter.prototype.getFormatter = function getFormatter() {
		var self = this;
		self.assertInitialized();

		if (!self._formatter) {
			self._formatter = JSJoda.DateTimeFormatter.ofPattern(window._onmsDateTimeFormat);
		}
		return self._formatter;
	};

	OnmsDateFormatter.prototype.getZoneId = function getZoneId() {
		var self = this;
		self.assertInitialized();

		if (!self._zoneId) {
			if (window._onmsZoneId) {
				try {
					self._zoneId = JSJoda.ZoneId.of(window._onmsZoneId);
				} catch (err) {
					console.log('Unhandled zone ID ' + window._onmsZoneId + ': ' + err);
					console.log('Falling back to default browser zone.');
					self._zoneId = JSJoda.ZoneId.SYSTEM;
				}
			} else {
				self._zoneId = JSJoda.ZoneId.SYSTEM;
			}
		}
		return self._zoneId;
	};

	OnmsDateFormatter.prototype.format = function format(date) {
		var self = this;
		self.assertInitialized();

		if (date === undefined || date === null) {
			return date;
		}

		//console.log('Formatting "' + date + '" with formatter "' + window._onmsDateTimeFormat + '" and zone ID "' + window._onmsZoneId + '"');
		var jodaDate = JSJoda.ZonedDateTime.from(JSJoda.nativeJs(moment(date))).withZoneSameLocal(self.getZoneId());

		return self.getFormatter().format(jodaDate);
	};

	//window.OnmsDateFormatter = OnmsDateFormatter;

	(function () {
		'use strict';

		if (typeof jest === 'undefined') {
			var f = new OnmsDateFormatter();
			f.init(function () {
				window._onmsFormatter = f;
			});
		} else {
			console.log('Running in a test environment. Skipping automatic initialization.');
		}
	})();

	(function () {
		'use strict';

		if (window.angular) {
			angular.module('onmsDateFormatter', ['ng']).factory('DateFormatterService', ['$interval', '$q', function DateFormatterService($interval, $q) {
				console.log('Initializing DateFormatterService');

				var deferred = $q.defer();

				var count = 0;
				var i = $interval(function () {
					if (window._onmsFormatter) {
						console.log('Global formatter found: ' + window._onmsDateTimeFormat);
						deferred.resolve(window._onmsFormatter);
						$interval.cancel(i);
					}
					if (count++ > 300) {
						console.log('DateFormatterService: giving up waiting for global formatter.');
						$interval.cancel(i);
					}
				}, 100);

				return {
					raw: window._onmsFormatter,
					formatter: deferred.promise,
					format: function format(date) {
						return deferred.promise.then(function (f) {
							return f.format(date);
						});
					}
				};
			}]);

			angular.module('onmsDateFormatter').filter('onmsDate', ['$filter', 'DateFormatterService', function ($filter, DateFormatterService) {
				return function onmsDate(input, ifEmpty) {
					var ret;
					if (window._onmsFormatter) {
						// If the formatter has finished initializing, use it
						ret = window._onmsFormatter.format(input);
						//console.log('onmsDate: formatter returned: ' + ret);
					} else {
						// Otherwise, use ISO format
						ret = $filter('date')(input, 'yyyy-MM-ddTHH:mm:ss.sssZ');
						//console.log('onmsDate: $filter(date) returned: ' + ret);
					}
					if (ret !== undefined && ret !== null) {
						return ret;
					}
					return ifEmpty;
				};
			}]);

			angular.module('onmsDateFormatter').directive('onmsDate', ['DateFormatterService', function (dateFormatterService) {
				return {
					restrict: 'E',
					compile: function compile(element) {
						dateFormatterService.format(element.text()).then(function (formatted) {
							element.replaceWith(formatted);
						}).catch(function (e) {
							console.error('Failed to format ' + element.text(), e);
						});
					}
				};
			}]);
		} else {
			console.log('Angular not found.  Not initializing OnmsDateFormatter Angular components.');
		}
	})();

	module.exports = OnmsDateFormatter;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! ui-bootstrap4 */ "./node_modules/ui-bootstrap4/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  // angular-ui-boostrap for bootstrap 4

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/onms-date-formatter/index.js","vendor"]]]);
});
//# sourceMappingURL=onms-date-formatter.js.map