(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["notifications"],{

/***/ "./src/main/assets/js/apps/notifications/index.js":
/*!********************************************************!*\
  !*** ./src/main/assets/js/apps/notifications/index.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! ./src/main/assets/modules/lib/util */ "./src/main/assets/modules/lib/util/index.js"), __webpack_require__(/*! ./src/main/assets/js/vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (_util, _jqueryJs) {
    /**
     * @copyright 2016-2019 The OpenNMS Group, Inc.
     */

    'use strict';

    var _util2 = _interopRequireDefault(_util);

    var _jqueryJs2 = _interopRequireDefault(_jqueryJs);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    (0, _jqueryJs2.default)(function () {
        if ('Notification' in window) {
            var notificationSocket = null;

            var connect = function connect() {
                notificationSocket = new WebSocket((_util2.default.getBaseHref() + 'notification/stream').replace(/^http/, 'ws'));

                notificationSocket.onclose = function (event) {
                    notificationSocket.close();
                    notificationSocket = null;

                    setTimeout(connect, 1000);
                };

                notificationSocket.onmessage = function (event) {
                    var message = JSON.parse(event.data);
                    var notification = new Notification(message.head, {
                        body: message.body,
                        icon: _util2.default.getBaseHref() + 'images/o-512.png',
                        badge: _util2.default.getBaseHref() + 'favicon.ico',
                        tag: 'opennms:notification:' + message.id
                    });
                };
            };

            if (Notification.permission === 'granted') {
                connect();
            } else if (Notification.permission !== 'denied') {
                Notification.requestPermission().then(function (permission) {
                    if (permission === 'granted') {
                        connect();
                    }
                });
            }
        }
    });
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/modules/lib/util/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/modules/lib/util/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (exports) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	var Util = function () {
		function Util() {
			_classCallCheck(this, Util);
		}

		_createClass(Util, null, [{
			key: 'getBaseHref',
			value: function getBaseHref() {
				var base = document.getElementsByTagName('base')[0];
				if (base) {
					return base.href;
				}
				return '';
			}
		}, {
			key: 'setLocation',
			value: function setLocation(url) {
				if (window && window.location) {
					window.location.href = Util.getBaseHref() + url;
				}
			}
		}, {
			key: 'toggle',
			value: function toggle(booleanValue, elementName) {
				var checkboxes = document.getElementsByName(elementName);
				for (var index in checkboxes) {
					if (checkboxes.hasOwnProperty(index)) {
						checkboxes[index].checked = booleanValue;
					}
				}
			}
		}]);

		return Util;
	}();

	exports.default = Util;
});

/***/ })

},[["./src/main/assets/js/apps/notifications/index.js","vendor"]]]);
});
//# sourceMappingURL=notifications.js.map