(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["add-to-ksc"],{

/***/ "./src/main/assets/js/apps/add-to-ksc/add-to-ksc.html":
/*!************************************************************!*\
  !*** ./src/main/assets/js/apps/add-to-ksc/add-to-ksc.html ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/add-to-ksc/add-to-ksc.html';
var html = "<ng-form name=\"kscForm\">\n  <div class=\"modal-header\">\n    <h3 class=\"modal-title\">Add {{ graphTitle }} to KSC</h3>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"form-group\">\n      <label class=\"col-form-label\" for=\"resourceLabel\">Resource</label>\n      <input ng-disabled=\"true\" class=\"form-control\" type=\"text\" id=\"resourceLabel\" name=\"resourceLabel\" ng-model=\"resourceLabel\"\n             ng-class=\"{ 'is-invalid' : kscForm.graphTitle.$invalid }\"/>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-form-label\" for=\"graphTitle\">Graph Title</label>\n      <input required class=\"form-control\" type=\"text\" id=\"graphTitle\" name=\"graphTitle\" ng-model=\"graphTitle\" placeholder=\"Graph Title\"\n             ng-class=\"{ 'is-invalid' : kscForm.graphTitle.$invalid }\"/>\n      <p class=\"invalid-feedback\">Graph title is required.</p>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-form-label\" for=\"timespan\">Time Range</label>\n      <input required class=\"form-control\" type=\"text\" id=\"timespan\" name=\"timespan\" ng-model=\"timespan\"\n        placeholder=\"Choose the target time range here...\"\n        uib-typeahead=\"timespan as timespan for timespan in timespans | filter:$viewValue\"\n        typeahead-editable=\"false\"\n        typeahead-min-length=\"0\"\n        ng-class=\"{ 'is-invalid' : kscForm.timespan.$invalid }\"/>\n      <p class=\"invalid-feedback\">Time range is required.</p>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-form-label\" for=\"kscReport\">Target KSC Report</label>\n      <input required class=\"form-control\" type=\"text\" id=\"kscReport\" name=\"kscReport\" ng-model=\"kscReport\" \n        placeholder=\"Choose the target KSC Report by typing the name here...\"\n        uib-typeahead=\"ksc as ksc.label for ksc in kscReports | filter:$viewValue\"\n        typeahead-editable=\"false\"\n        typeahead-min-length=\"0\"\n        ng-class=\"{ 'is-invalid' : kscForm.kscReport.$invalid }\"/>\n      <p class=\"invalid-feedback\">Target KSC Report is required.</p>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button class=\"btn btn-primary\" type=\"button\" ng-click=\"ok()\" ng-disabled=\"kscForm.$invalid\">Add <span class=\"fa fa-save\"/></button>\n    <button class=\"btn btn-warning\" type=\"button\" ng-click=\"cancel()\">Cancel</button>\n  </div>\n</ng-form>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/add-to-ksc/index.js":
/*!*****************************************************!*\
  !*** ./src/main/assets/js/apps/add-to-ksc/index.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! ./add-to-ksc.html */ "./src/main/assets/js/apps/add-to-ksc/add-to-ksc.html"), __webpack_require__(/*! lib/onms-http */ "./src/main/assets/js/lib/onms-http/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (angular, templateUrl) {
  /**
  * @author Alejandro Galue <agalue@opennms.org>
  * @copyright 2016-2017 The OpenNMS Group, Inc.
  */

  'use strict';

  angular.module('onms-ksc', ['onms.http', 'ui.bootstrap', 'angular-growl']).config(['growlProvider', function (growlProvider) {
    growlProvider.globalTimeToLive(5000);
    growlProvider.globalPosition('bottom-center');
  }]).controller('AddToKscModalInstanceCtrl', ['$scope', '$http', '$uibModalInstance', 'resourceLabel', 'graphTitle', function ($scope, $http, $uibModalInstance, resourceLabel, graphTitle) {

    $scope.resourceLabel = resourceLabel;
    $scope.graphTitle = graphTitle;
    $scope.kscReports = [];
    $scope.timespan = '1_day';
    $scope.timespans = ['1_hour', '2_hour', '4_hour', '6_hour', '8_hour', '12_hour', '1_day', '2_day', '7_day', '1_month', '3_month', '6_month', '1_year', 'Today', 'Yesterday', 'Yesterday 9am-5pm', 'Yesterday 5pm-10pm', 'This Week', 'Last Week', 'This Month', 'Last Month', 'This Quarter', 'Last Quarter', 'This Year', 'Last Year'];

    $scope.ok = function () {
      $uibModalInstance.close({ report: $scope.kscReport, title: $scope.graphTitle, timespan: $scope.timespan });
    };

    $scope.cancel = function () {
      $uibModalInstance.dismiss('cancel');
    };

    $http.get('rest/ksc').then(function (response) {
      $scope.kscReports = response.data.kscReport;
    });
  }]).controller('AddToKscCtrl', ['$scope', '$http', '$uibModal', 'growl', function ($scope, $http, $uibModal, growl) {

    $scope.open = function (resourceId, _resourceLabel, graphName, _graphTitle) {
      $uibModal.open({
        animation: $scope.animationsEnabled,
        templateUrl: templateUrl,
        controller: 'AddToKscModalInstanceCtrl',
        resolve: {
          resourceLabel: function resourceLabel() {
            return _resourceLabel;
          },
          graphTitle: function graphTitle() {
            return _graphTitle;
          }
        }
      }).result.then(function (data) {
        $scope.updateReport(data.report, resourceId, _resourceLabel, graphName, data.title, data.timespan);
      });
    };

    $scope.updateReport = function (report, resourceId, resourceLabel, graphName, graphTitle, timespan) {
      var url = 'rest/ksc/' + report.id;
      $http.get(url).success(function (data) {
        var found = false;
        angular.forEach(data.kscGraph, function (r) {
          if (r.resourceId === resourceId && r.graphtype === graphName) {
            found = true;
          }
        });
        if (found) {
          growl.warning('The graph "' + graphTitle + '" for resource "' + resourceLabel + '" has been already added to "' + report.label + '"');
        } else {
          $http({
            url: url,
            method: 'PUT',
            params: {
              title: graphTitle,
              reportName: graphName,
              resourceId: resourceId,
              timespan: timespan
            }
          }).success(function () {
            growl.success('The graph "' + graphTitle + '" has been added to "' + report.label + '"');
          }).error(function (msg) {
            growl.error(msg);
          });
        }
      }).error(function (msg) {
        growl.error(msg);
      });
    };
  }]).factory('flowsRestFactory', ['$http', '$q', function ($http, $q) {
    var resources = {};

    resources.getFlowGraphUrl = function (nodeId, ifIndex, start, end) {
      var deferred = $q.defer();
      $http({
        url: 'rest/flows/flowGraphUrl',
        method: 'GET',
        params: { exporterNode: nodeId,
          ifIndex: ifIndex,
          start: start,
          end: end,
          limit: 0 }
      }).success(function (data) {
        deferred.resolve(data);
      });
      return deferred.promise;
    };

    return resources;
  }]).controller('checkFlowsCtrl', ['$scope', '$http', '$filter', 'flowsRestFactory', function ($scope, $http, $filter, flowsRestFactory) {

    $scope.flowCount = 0;
    $scope.flowsEnabled = false;
    $scope.hasFlows = false;
    $scope.flowGraphUrl = '';
    $scope.getFlowInfo = function (nodeId, ifIndex, start, end) {
      if (nodeId === 0 || ifIndex === 0) {
        return;
      }
      flowsRestFactory.getFlowGraphUrl(nodeId, ifIndex, start, end).then(function (data) {
        $scope.flowGraphUrl = data.flowGraphUrl;
        $scope.flowCount = data.flowCount;
        if ($scope.flowGraphUrl) {
          $scope.flowsEnabled = true;
          if ($scope.flowCount > 0) {
            $scope.hasFlows = true;
          } else {
            $scope.flowGraphUrl = null;
          }
        }
      });
    };
  }]);
});

/***/ }),

/***/ "./src/main/assets/js/lib/onms-http/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/lib/onms-http/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (module, angular) {
    'use strict';

    angular.module('onms.http', []).config(['$httpProvider', function ($httpProvider) {
        $httpProvider.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
    }]);

    module.exports = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! ui-bootstrap4 */ "./node_modules/ui-bootstrap4/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  // angular-ui-boostrap for bootstrap 4

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/add-to-ksc/index.js","vendor"]]]);
});
//# sourceMappingURL=add-to-ksc.js.map