(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["onms-resources"],{

/***/ "./src/main/assets/js/apps/onms-resources/index.js":
/*!*********************************************************!*\
  !*** ./src/main/assets/js/apps/onms-resources/index.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! underscore */ "./node_modules/underscore/underscore.js-exposed"), __webpack_require__(/*! lib/onms-http */ "./src/main/assets/js/lib/onms-http/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (angular, _) {
  /**
  * @author Alejandro Galue <agalue@opennms.org>
  * @copyright 2016 The OpenNMS Group, Inc.
  */

  'use strict';

  angular.module('onms-resources', ['onms.http', 'ui.bootstrap', 'angular-growl']).config(['growlProvider', function (growlProvider) {
    growlProvider.globalTimeToLive(3000);
    growlProvider.globalPosition('bottom-center');
  }]).filter('startFrom', function () {
    return function (input, _start) {
      var start = Number(_start);
      if (input) {
        return input.length < start ? input : input.slice(start);
      }
      return [];
    };
  }).controller('NodeListCtrl', ['$scope', '$filter', '$http', '$window', 'growl', function ($scope, $filter, $http, $window, growl) {

    $scope.endUrl = 'graph/results.htm';
    $scope.resources = [];
    $scope.filteredResources = [];
    $scope.pageSize = 10;
    $scope.maxSize = 5;
    $scope.totalItems = 0;
    $scope.hasResources = false;
    $scope.loaded = false;

    $scope.goTo = function (id) {
      $window.location.href = getBaseHref() + 'graph/chooseresource.jsp?reports=all&parentResourceId=' + id + '&endUrl=' + $scope.endUrl;
    };

    $scope.update = function () {
      $scope.currentPage = 1;
      $scope.totalItems = $scope.filteredResources.length;
      $scope.numPages = Math.ceil($scope.totalItems / $scope.pageSize);
    };

    $http.get('rest/resources?depth=0').then(function succeeded(response) {
      var data = response.data;
      $scope.loaded = true;
      $scope.hasResources = data.resource.length > 0;
      $scope.resources = data.resource;
      $scope.filteredResources = $scope.resources;
      $scope.update();
    }, function errorCallback(response) {
      $scope.loaded = true;
      growl.error('There was a problem in retrieving resources through ReST', { ttl: 10000 });
    });

    $scope.$watch('resourceFilter', function () {
      $scope.filteredResources = $filter('filter')($scope.resources, $scope.resourceFilter);
      $scope.update();
    });
  }]).controller('NodeResourcesCtrl', ['$scope', '$filter', '$http', '$window', 'growl', function ($scope, $filter, $http, $window, growl) {

    $scope.searchQuery = undefined;
    $scope.resources = {};
    $scope.hasResources = false;
    $scope.filteredResources = {};
    $scope.isCollapsed = {};
    $scope.nodeLink = undefined;
    $scope.nodeLabel = undefined;
    $scope.url = 'graph/results.htm';
    $scope.reports = 'all';
    $scope.loaded = false;

    $scope.init = function (nodeCriteria, reports, endUrl) {
      if (nodeCriteria === null || nodeCriteria === '') {
        return;
      }
      if (reports !== null && reports !== '') {
        $scope.reports = reports;
      }
      if (endUrl !== null && endUrl !== '') {
        $scope.url = endUrl;
      }

      $http.get('rest/resources/fornode/' + nodeCriteria).then(function succeeded(response) {
        var data = response.data;
        $scope.nodeLink = data.link;
        $scope.nodeLabel = data.label;
        $scope.loaded = true;
        $scope.hasResources = data.children.resource.length > 0;
        var reduced = _.map(data.children.resource, function (obj) {
          return { id: obj.id, label: obj.label, typeLabel: obj.typeLabel, checked: false };
        });
        $scope.resources = _.groupBy(_.sortBy(reduced, function (r) {
          var type = r['typeLabel'];
          return type === 'SNMP Node Data' || type === 'SNMP Interface Data' ? Infinity : type;
        }), 'typeLabel');
        angular.copy($scope.resources, $scope.filteredResources);
      }, function errorCallback(response) {
        $scope.loaded = true;
        growl.error('There was a problem in retrieving resources through ReST', { ttl: 10000 });
      });
    };

    $scope.checkAll = function (check) {
      for (var key in $scope.resources) {
        if ($scope.resources.hasOwnProperty(key)) {
          _.each($scope.filteredResources[key], function (r) {
            r.selected = check;
          });
        }
      }
    };

    $scope.graphSelected = function () {
      var selected = [];
      for (var key in $scope.resources) {
        if ($scope.resources.hasOwnProperty(key)) {
          _.each($scope.filteredResources[key], function (r) {
            if (r.selected) {
              selected.push('resourceId=' + r.id);
            }
          });
        }
      }
      $scope.doGraph(selected);
    };

    $scope.graphAll = function () {
      var selected = [];
      for (var key in $scope.filteredResources) {
        if ($scope.filteredResources.hasOwnProperty(key)) {
          _.each($scope.filteredResources[key], function (r) {
            selected.push('resourceId=' + r.id);
          });
        }
      }
      $scope.doGraph(selected);
    };

    $scope.doGraph = function (selected) {
      if (selected.length > 0) {
        $window.location.href = getBaseHref() + $scope.url + '?' + selected.join('&') + ($scope.reports ? '&reports=' + $scope.reports : '');
      } else {
        growl.error('Please select at least one resource.');
      }
    };

    $scope.$watch('searchQuery', function () {
      $scope.filteredResurces = {};
      for (var key in $scope.resources) {
        if ($scope.resources.hasOwnProperty(key)) {
          $scope.filteredResources[key] = $filter('filter')($scope.resources[key], $scope.searchQuery);
        }
      }
    });
  }]);
});

/***/ }),

/***/ "./src/main/assets/js/lib/onms-http/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/lib/onms-http/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (module, angular) {
    'use strict';

    angular.module('onms.http', []).config(['$httpProvider', function ($httpProvider) {
        $httpProvider.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
    }]);

    module.exports = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! angular-ui-bootstrap */ "./node_modules/angular-ui-bootstrap/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/npm */ "./node_modules/bootstrap/dist/js/npm.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/onms-resources/index.js","vendor"]]]);
});
//# sourceMappingURL=onms-resources.js.map