(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["onms-interfaces-config"],{

/***/ "./src/main/assets/js/apps/onms-interfaces/onms-interfaces-config/index.js":
/*!*********************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-interfaces/onms-interfaces-config/index.js ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! ../templates/template.config.html */ "./src/main/assets/js/apps/onms-interfaces/templates/template.config.html"), __webpack_require__(/*! ../templates/template.sort.html */ "./src/main/assets/js/apps/onms-interfaces/templates/template.sort.html"), __webpack_require__(/*! lib/onms-http */ "./src/main/assets/js/lib/onms-http/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (angular, configTemplate, sortTemplate) {
  /**
  * @author Alejandro Galue <agalue@opennms.org>
  * @copyright 2016 The OpenNMS Group, Inc.
  */

  'use strict';

  angular.module('onms-interfaces-config', ['onms.http', 'ui.bootstrap', 'angular-growl']).config(['growlProvider', function (growlProvider) {
    growlProvider.globalTimeToLive(5000);
    growlProvider.globalPosition('bottom-center');
  }]).filter('startFrom', function () {
    return function (input, start) {
      var s = parseInt(start, 10);
      if (input) {
        return input.length < s ? input : input.slice(s);
      }
      return [];
    };
  }).directive('onmsInterfacesConfig', function () {
    return {
      restrict: 'E',
      scope: {
        nodeId: '=node'
      },
      templateUrl: configTemplate,
      controller: 'NodeInterfacesConfigCtrl'
    };
  }).directive('sort', function () {
    return {
      restrict: 'A',
      transclude: true,
      templateUrl: sortTemplate,
      scope: {
        order: '=',
        by: '=',
        reverse: '='
      },
      link: function link(scope, element, attrs) {
        scope.onClick = function () {
          if (scope.order === scope.by) {
            scope.reverse = !scope.reverse;
          } else {
            scope.by = scope.order;
            scope.reverse = false;
          }
        };
      }
    };
  }).controller('NodeInterfacesConfigCtrl', ['$scope', '$http', '$filter', 'growl', function ($scope, $http, $filter, growl) {

    $scope.filters = { snmpInterface: null };
    $scope.snmpInterfaces = [];
    $scope.filteredSnmpInterfaces = [];
    $scope.snmpInterfacesPageSize = 10;
    $scope.snmpInterfacesMaxSize = 5;
    $scope.snmpInterfacesTotalItems = 0;
    $scope.snmpOrder = 'ifIndex';
    $scope.snmpReverse = false;

    $scope.loadSnmpInterfaces = function () {
      $http({
        url: 'rest/nodes/' + $scope.nodeId + '/snmpinterfaces',
        method: 'GET',
        params: { limit: 0 }
      }).success(function (data) {
        $scope.snmpInterfaces = data.snmpInterface;
        $scope.setStylesForSnmpInterfaces();
        $scope.filteredSnmpInterfaces = $scope.snmpInterfaces;
        $scope.updateFilteredSnmpInterfaces();
      });
    };

    $scope.isCollectionEnabled = function (intf) {
      return intf.collectFlag === 'C' || intf.collectFlag === 'UC';
    };

    $scope.updateCollection = function ($event, intf) {
      $scope.enableCollection(intf, $event.target.checked);
    };

    $scope.enableCollection = function (intf, enable) {
      intf.collectFlag = enable ? 'UC' : 'UN';
      $http.put('rest/nodes/' + $scope.nodeId + '/snmpinterfaces/' + intf.ifIndex, 'collect=' + intf.collectFlag, {
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
      }).success(function (data) {
        var action = $scope.isCollectionEnabled(intf) ? 'enabled' : 'disabled';
        growl.success('Data collection flag was successfully ' + action + ' for interface ' + intf.ifName);
      }).error(function (error, status) {
        growl.error('Cannot set data collection flag for interface ' + intf.ifName);
      });
    };

    $scope.updateFilteredSnmpInterfaces = function () {
      $scope.snmpInterfacesCurrentPage = 1;
      $scope.snmpInterfacesTotalItems = $scope.filteredSnmpInterfaces.length;
      $scope.snmpInterfacesNumPages = Math.ceil($scope.snmpInterfacesTotalItems / $scope.snmpInterfacesPageSize);
    };

    $scope.setStylesForSnmpInterfaces = function () {
      angular.forEach($scope.snmpInterfaces, function (intf) {
        var cssClass = undefined;
        if (intf.ifAdminStatus !== 1) {
          cssClass = 'onms-interface-status-unknown';
        } else {
          if (intf.ifOperStatus === 1) {
            cssClass = 'onms-interface-status-up';
          } else {
            cssClass = 'onms-interface-status-down';
          }
        }
        intf.backgroundClass = cssClass;
      });
    };

    $scope.$watch('filters.snmpInterface', function () {
      $scope.filteredSnmpInterfaces = $filter('filter')($scope.snmpInterfaces, $scope.filters.snmpInterface);
      $scope.updateFilteredSnmpInterfaces();
    });

    $scope.loadSnmpInterfaces();
  }]);

  // Bootstrap to a an element with ID 'onms-interfaces-config'

  angular.element(document).ready(function () {
    var el = document.getElementById('onms-interfaces-config');
    angular.bootstrap(angular.element(el), ['onms-interfaces-config']);
  });
});

/***/ }),

/***/ "./src/main/assets/js/apps/onms-interfaces/templates/template.config.html":
/*!********************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-interfaces/templates/template.config.html ***!
  \********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-interfaces/templates/template.config.html';
var html = "    <div class=\"jumbotron\" ng-show=\"snmpInterfaces.length == 0\">\n      <div class=\"container\">\n        <p>There are no SNMP interfaces for this node</p>\n      </div>\n    </div>\n    <div class=\"table-responsive\" ng-show=\"snmpInterfaces.length > 0\">\n      <div class=\"input-group\">\n        <span class=\"input-group-addon\">\n          <span class=\"glyphicon glyphicon-search\"></span>\n        </span>\n        <input class=\"form-control\" type=\"text\" placeholder=\"Search/Filter SNMP Interfaces\" ng-model=\"filters.snmpInterface\"></input>\n      </div>\n      <table class=\"table table-condensed\">\n        <thead>\n          <tr>\n            <th sort order=\"'ifIndex'\" by=\"snmpOrder\" reverse=\"snmpReverse\">SNMP ifIndex</th>\n            <th sort order=\"'ifType'\"  by=\"snmpOrder\" reverse=\"snmpReverse\">SNMP ifType</th>\n            <th sort order=\"'ifDescr'\" by=\"snmpOrder\" reverse=\"snmpReverse\">SNMP ifDescr</th>\n            <th sort order=\"'ifName'\"  by=\"snmpOrder\" reverse=\"snmpReverse\">SNMP ifName</th>\n            <th sort order=\"'ifAlias'\" by=\"snmpOrder\" reverse=\"snmpReverse\">SNMP ifAlias</th>\n            <th>Collect</th>\n          </tr>\n        </thead>\n        <tbody>\n          <tr ng-class=\"intf.backgroundClass\" ng-dblclick=\"openSnmpPage(intf)\" ng-repeat=\"intf in filteredSnmpInterfaces | orderBy:snmpOrder:snmpReverse | startFrom:(snmpInterfacesCurrentPage-1)*snmpInterfacesPageSize | limitTo:snmpInterfacesPageSize\">\n            <td>{{ intf.ifIndex }}</td>\n            <td>{{ intf.ifType  || 'N/A' }}</td>\n            <td>{{ intf.ifDescr || 'N/A' }}</td>\n            <td>{{ intf.ifName  || 'N/A' }}</td>\n            <td>{{ intf.ifAlias || 'N/A' }}</td>\n            <td>\n              <input type=\"checkbox\" ng-checked=\"isCollectionEnabled(intf)\" ng-click=\"updateCollection($event, intf)\" uib-tooltip=\"Check to enable collection, or uncheck to disable collection\"></input>\n            </td>\n          </tr>\n       </tbody>\n      </table>\n    </div>\n    <ul uib-pagination class=\"pagination-sm\"\n      total-items=\"snmpInterfacesTotalItems\"\n      num-pages=\"snmpInterfacesNumPages\"\n      ng-model=\"snmpInterfacesCurrentPage\"\n      max-size=\"snmpInterfacesMaxSize\"\n      boundary-links=\"true\"\n      ng-show=\"filteredSnmpInterfaces.length > snmpInterfacesPageSize\"></ul>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-interfaces/templates/template.sort.html":
/*!******************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-interfaces/templates/template.sort.html ***!
  \******************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-interfaces/templates/template.sort.html';
var html = "<span ng-click=\"onClick()\">\n  <span ng-transclude></span>&nbsp;&nbsp;\n  <i class=\"glyphicon\" ng-class=\"{'glyphicon-sort-by-alphabet': order===by && !reverse, 'glyphicon-sort-by-alphabet-alt': order===by && reverse}\"></i>\n</span>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/lib/onms-http/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/lib/onms-http/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (module, angular) {
    'use strict';

    angular.module('onms.http', []).config(['$httpProvider', function ($httpProvider) {
        $httpProvider.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
    }]);

    module.exports = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! angular-ui-bootstrap */ "./node_modules/angular-ui-bootstrap/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/npm */ "./node_modules/bootstrap/dist/js/npm.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/onms-interfaces/onms-interfaces-config/index.js","vendor"]]]);
});
//# sourceMappingURL=onms-interfaces-config.js.map