(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["onms-classifications"],{

/***/ "./src/main/assets/js/apps/onms-classifications/index.js":
/*!***************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/index.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! ../onms-elementList/lib/elementList */ "./src/main/assets/js/apps/onms-elementList/lib/elementList.js"), __webpack_require__(/*! ./views/index.html */ "./src/main/assets/js/apps/onms-classifications/views/index.html"), __webpack_require__(/*! ./views/config.html */ "./src/main/assets/js/apps/onms-classifications/views/config.html"), __webpack_require__(/*! ./views/group.html */ "./src/main/assets/js/apps/onms-classifications/views/group.html"), __webpack_require__(/*! ./views/modals/new-rule-modal.html */ "./src/main/assets/js/apps/onms-classifications/views/modals/new-rule-modal.html"), __webpack_require__(/*! ./views/modals/import-modal.html */ "./src/main/assets/js/apps/onms-classifications/views/modals/import-modal.html"), __webpack_require__(/*! ./views/modals/export-modal.html */ "./src/main/assets/js/apps/onms-classifications/views/modals/export-modal.html"), __webpack_require__(/*! ../../lib/onms-pagination */ "./src/main/assets/js/lib/onms-pagination/index.js"), __webpack_require__(/*! ../../lib/onms-http */ "./src/main/assets/js/lib/onms-http/index.js"), __webpack_require__(/*! angular-bootstrap-confirm */ "./node_modules/angular-bootstrap-confirm/dist/angular-bootstrap-confirm.js"), __webpack_require__(/*! angular-bootstrap-toggle/dist/angular-bootstrap-toggle */ "./node_modules/angular-bootstrap-toggle/dist/angular-bootstrap-toggle.js"), __webpack_require__(/*! angular-bootstrap-toggle/dist/angular-bootstrap-toggle.css */ "./node_modules/angular-bootstrap-toggle/dist/angular-bootstrap-toggle.css"), __webpack_require__(/*! angular-ui-router */ "./node_modules/angular-ui-router/lib/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (angular, elementList, indexTemplate, configTemplate, groupTemplate, newRuleModalTemplate, importModalTemplate, exportModalTemplate) {
    'use strict';

    (function () {
        'use strict';

        var MODULE_NAME = 'onms.classifications';

        angular.module(MODULE_NAME, ['angular-loading-bar', 'ngResource', 'ui.router', 'ui.bootstrap', 'ui.checkbox', 'ui.toggle', 'onms.http', 'onms.elementList', 'mwl.confirm', 'onms.pagination']).config(['$locationProvider', function ($locationProvider) {
            $locationProvider.hashPrefix('!');
            $locationProvider.html5Mode(false);
        }]).config(['$stateProvider', '$urlRouterProvider', function ($stateProvider, $urlRouterProvider) {
            $stateProvider.state('classifications', {
                url: '/classifications',
                controller: 'ClassificationController',
                templateUrl: indexTemplate
            }).state('classifications.config', {
                templateUrl: configTemplate,
                url: '/config',
                controller: 'ClassificationConfigController'
            }).state('classifications.group', {
                templateUrl: groupTemplate,
                url: '/:id',
                controller: 'ClassificationGroupController'
            });
            $urlRouterProvider.otherwise('classifications/config');
        }]).filter('capitalize', function () {
            return function (input) {
                return input ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
            };
        }).factory('ClassificationService', ['$resource', function ($resource) {
            return $resource('rest/classifications/', {}, {
                'classify': { method: 'POST', url: 'rest/classifications/classify' }
            });
        }]).factory('ClassificationGroupService', ['$resource', function ($resource) {
            return $resource('rest/classifications/groups/:id', { id: '@id' }, {
                'get': { method: 'GET' },
                'update': { method: 'PUT' },
                'query': { method: 'GET', isArray: true },
                'delete': { method: 'DELETE', params: { id: -1 /*force to -1 to prevent accidentally deleting all groups*/ } }
            });
        }]).factory('ClassificationRuleService', ['$resource', function ($resource) {
            return $resource('rest/classifications/:id', { id: '@id' }, {
                'get': { method: 'GET' },
                'save': { method: 'POST' },
                'update': { method: 'PUT' },
                'query': { method: 'GET', isArray: true },
                'delete': { method: 'DELETE' }
            });
        }]).factory('ProtocolService', ['$resource', function ($resource) {
            return $resource('rest/classifications/protocols');
        }]).controller('ClassificationController', ['$scope', '$state', 'ClassificationService', 'ClassificationGroupService', 'ProtocolService', function ($scope, $state, ClassificationService, ClassificationGroupService, ProtocolService) {
            $scope.groups = [];
            $scope.classificationRequest = {};
            $scope.classificationResponse = undefined;
            $scope.isClassificationCollapsed = true;
            $scope.error = undefined;

            $scope.classify = function (classificationRequest) {
                ClassificationService.classify(classificationRequest, function (result) {
                    $scope.classifyError = undefined;
                    $scope.classificationResponse = result.classification === undefined ? 'No mapping found' : result.classification;
                }, function (response) {
                    $scope.classificationResponse = undefined;
                    if (response.status === 400 && response.data && response.data.context && response.data.message) {
                        $scope.classifyError = {};
                        $scope.classifyError[response.data.context] = response.data.message;
                    } else {
                        $scope.classifyError['entity'] = 'Cannot perform the request.';
                    }
                });
            };

            $scope.refreshTabs = function (navigateToFirstGroup) {
                return ClassificationGroupService.query({}, function (response) {
                    // Remove disabled groups
                    $scope.groups = response.filter(function (group) {
                        return group.enabled === true;
                    });
                    // Sort by priority (highest first)
                    $scope.groups = $scope.groups.sort(function (l, r) {
                        return l.priority - r.priority;
                    });
                    $scope.groups = $scope.groups.reverse();

                    // Select first group if available
                    if (navigateToFirstGroup && $scope.groups.length !== 0) {
                        $state.go('classifications.group', { id: $scope.groups[0].id });
                    }
                });
            };

            $scope.loadProtocols = function () {
                ProtocolService.query(function (response, headers) {
                    $scope.protocols = response;
                });
            };

            $scope.fullyDefined = function () {
                var fullyDefined = $scope.classificationRequest && $scope.classificationRequest.protocol && $scope.classificationRequest.dstPort && $scope.classificationRequest.dstAddress && $scope.classificationRequest.srcPort && $scope.classificationRequest.srcAddress && $scope.classificationRequest.exporterAddress;
                return fullyDefined;
            };

            $scope.toggleClassificationMode = function () {
                $scope.classificationMode = $scope.classificationMode === 'simple' ? 'complex' : 'simple';
            };

            $scope.loadProtocols();
            $scope.refreshTabs(true);
        }]).controller('ClassificationConfigController', ['$scope', '$rootScope', '$location', '$log', 'ClassificationGroupService', function ($scope, $rootScope, $location, $log, ClassificationGroupService) {
            $scope.groups = [];
            $scope.query = {
                page: 1,
                limit: 20,
                totalItems: 0,
                orderBy: 'priority',
                order: 'desc'
            };
            $scope.updateGroup = function (group) {
                group.$update({}, function () {
                    $scope.refreshTabs();
                });
            };
            $scope.refresh = function () {
                ClassificationGroupService.query({}, function (result, headers) {
                    $scope.groups = result;
                    var contentRange = elementList.parseContentRange(headers('Content-Range'));
                    $scope.query.totalItems = contentRange.total;
                });
            };
            $scope.refresh();
        }]).controller('ClassificationGroupController', ['$scope', '$stateParams', '$uibModal', '$log', '$http', '$window', 'ClassificationRuleService', 'ClassificationGroupService', function ($scope, $stateParams, $uibModal, $log, $http, $window, ClassificationRuleService, ClassificationGroupService) {
            // Defaults
            $scope.rules = [];
            $scope.query = {
                page: 1,
                limit: 20,
                totalItems: 0,
                orderBy: 'position',
                order: 'asc',
                groups: [$stateParams.id],
                search: undefined
            };
            $scope.findGroup = function (groupId) {
                return ClassificationGroupService.get({ id: groupId }, function (response) {
                    $scope.group = response;
                    $scope.refresh();
                });
            };

            $scope.showExportRulesDialog = function () {
                var modalInstance = $uibModal.open({
                    backdrop: false,
                    controller: 'ClassificationExportController',
                    templateUrl: exportModalTemplate,
                    resolve: {
                        group: function group() {
                            return $scope.group;
                        }
                    }
                });
                modalInstance.result.then(function () {
                    $scope.refreshTabs();
                    $scope.refresh();
                });
            };

            $scope.refresh = function () {
                var parameters = $scope.query || {};
                return ClassificationRuleService.query({
                    limit: parameters.limit || 20,
                    offset: (parameters.page - 1) * parameters.limit || 0,
                    orderBy: parameters.orderBy,
                    order: parameters.order,
                    groupFilter: parameters.groups || [],
                    query: parameters.search
                }, function (result, headers) {
                    $scope.rules = result;
                    var contentRange = elementList.parseContentRange(headers('Content-Range'));
                    $scope.query.totalItems = contentRange.total;
                });
            };

            // In some cases the currently selected group needs to be refreshed, this method finds the group from
            // $scope.groups and updates $scope.group accordingly, in order to reflect updates in $scope.groups
            $scope.refreshGroup = function () {
                for (var i = 0; i < $scope.groups.length; i++) {
                    var group = $scope.groups[i];
                    if (group.id === $scope.group.id) {
                        $scope.group = group;
                        return;
                    }
                }
            };

            $scope.refreshAll = function () {
                var result = $scope.refreshTabs();
                result.$promise.then(function () {
                    $scope.refreshGroup();
                    $scope.refresh();
                });
            };

            $scope.changeOrderBy = function (column) {
                if ($scope.query.orderBy === column) {
                    $scope.query.order = $scope.query.order === 'asc' ? 'desc' : 'asc';
                } else {
                    $scope.query.orderBy = column;
                    $scope.query.order = 'asc';
                }
                $scope.refresh();
            };

            $scope.deleteRule = function (rule) {
                rule.$delete().then(function () {
                    $scope.refreshAll();
                });
            };

            $scope.deleteAllRules = function () {
                ClassificationRuleService.delete({ groupId: $scope.group.id }, function () {
                    $scope.refreshAll();
                });
            };

            var openModal = function openModal(_classification) {
                return $uibModal.open({
                    backdrop: false,
                    controller: 'ClassificationModalController',
                    templateUrl: newRuleModalTemplate,
                    size: 'md',
                    resolve: {
                        classification: function classification() {
                            return _classification;
                        }
                    }
                });
            };

            $scope.editRule = function (rule) {
                var modalInstance = openModal(rule);
                modalInstance.closed.then(function () {
                    $scope.refreshAll();
                }, function () {
                    // modal was dismissed
                    $scope.refresh();
                });
            };

            $scope.addRule = function () {
                var modalInstance = openModal();
                modalInstance.closed.then(function () {
                    $scope.refreshAll();
                });
            };

            $scope.importRules = function () {
                var modalInstance = $uibModal.open({
                    backdrop: false,
                    controller: 'ClassificationImportController',
                    templateUrl: importModalTemplate,
                    resolve: {
                        group: function group() {
                            return $scope.group;
                        }
                    }
                });
                modalInstance.closed.then(function () {
                    $scope.refreshAll();
                });
            };

            $scope.clearSearch = function () {
                $scope.query.search = undefined;
                $scope.refresh();
            };

            $scope.findGroup($stateParams.id);
        }]).controller('ClassificationImportController', ['$scope', '$http', '$uibModalInstance', 'group', function ($scope, $http, $uibModalInstance, group) {
            $scope.group = group;
            $scope.setFile = function (element) {
                $scope.$apply(function (scope) {
                    scope.fileToUpload = element.files[0];
                });
            };
            $scope.openFileDialogue = function () {
                setTimeout(function () {
                    document.getElementById('fileToImport').click();
                }, 0);
            };
            $scope.resetInput = function () {
                $scope.fileToUpload = undefined;
                $scope.error = undefined;
                $scope.failedRows = [];
                $scope.containsHeader = true;
                $scope.deleteExistingRules = false;
                $scope.pagination = {
                    page: 1,
                    totalItems: 0,
                    limit: 5
                };
            };

            $scope.navigateWithinErrors = function () {
                var limit = $scope.pagination.limit;
                var offset = ($scope.pagination.page - 1) * limit;
                var endIndex = Math.min(offset + limit, $scope.errors.length);
                $scope.failedRows = $scope.errors.slice(offset, endIndex);
            };

            $scope.uploadFile = function () {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $scope.error = undefined;
                    $scope.errors = [];
                    $scope.failedRows = [];
                    $http({
                        url: 'rest/classifications',
                        method: 'POST',
                        data: reader.result,
                        params: { 'hasHeader': $scope.containsHeader, 'deleteExistingRules': $scope.deleteExistingRules },
                        headers: { 'Content-Type': 'text/comma-separated-values' }
                    }).success(function (response) {
                        $uibModalInstance.close();
                    }).error(function (response, status) {
                        if (status === 500) {
                            $scope.error = 'An unexpected error occurred.';
                        }
                        if (status === 400) {
                            // General error
                            if (response.error) {
                                $scope.error = response.error.message;
                                return;
                            }
                            // Report failed rows
                            if (response.errors) {
                                $scope.error = 'The rules could not be imported. Please fix the errors shown below and retry.';
                                // Persist locally
                                var errorKeys = Object.getOwnPropertyNames(response.errors);
                                for (var i = 0; i < errorKeys.length; i++) {
                                    var index = errorKeys[i];
                                    var rowIndex = $scope.containsHeader ? parseInt(index, 10) + 1 : index; // increase row index if csv contains header
                                    $scope.errors.push({ index: rowIndex, message: response.errors[index].message });
                                }
                                // Update pagination settings
                                $scope.pagination.totalItems = $scope.errors.length;
                                $scope.navigateWithinErrors();
                            }
                        }
                    });
                };
                reader.readAsText($scope.fileToUpload);
            };
            $scope.resetInput();
        }]).controller('ClassificationExportController', ['$scope', '$http', '$uibModalInstance', 'group', '$window', function ($scope, $http, $uibModalInstance, group, $window) {
            $scope.group = group;
            $scope.export = {};
            $scope.export.requestedFileName = group.id + '_rules.csv';
            $scope.exportGroup = function () {
                var requestedFileName = $scope.export.requestedFileName.trim();
                $window.location = 'rest/classifications/groups/' + $scope.group.id + '?filename=' + requestedFileName + '&format=csv';
                $uibModalInstance.close();
            };
        }]).controller('ClassificationModalController', ['$scope', '$uibModalInstance', 'ProtocolService', 'ClassificationRuleService', 'classification', function ($scope, $uibModalInstance, ProtocolService, ClassificationRuleService, classification) {
            $scope.classification = classification || {};
            $scope.protocols = [];
            $scope.currentSelection = undefined;
            $scope.selectedProtocols = [];
            $scope.buttonName = $scope.classification.id ? 'Update' : 'Create';

            var convertStringArrayToProtocolsArray = function convertStringArrayToProtocolsArray(string) {
                return string.map(function (protocol) {
                    return { keyword: protocol };
                });
            };

            var convertProtocolsArrayToStringArray = function convertProtocolsArrayToStringArray(protocols) {
                return protocols.map(function (protocol) {
                    return protocol.keyword;
                });
            };

            var handleErrorResponse = function handleErrorResponse(response) {
                if (response && response.data) {
                    var error = response.data;
                    $scope.error = {};
                    $scope.error[error.context] = error.message;
                }
            };

            $scope.save = function () {
                // Close modal afterwards
                var closeCallback = function closeCallback() {
                    $uibModalInstance.close();
                };
                $scope.classification.protocols = convertProtocolsArrayToStringArray($scope.selectedProtocols);
                if ($scope.classification.id) {
                    ClassificationRuleService.update($scope.classification, closeCallback, handleErrorResponse);
                } else {
                    ClassificationRuleService.save($scope.classification, closeCallback, handleErrorResponse);
                }
            };

            $scope.cancel = function () {
                $uibModalInstance.dismiss('Cancelled by User');
            };

            $scope.insertProtocol = function (item) {
                if (item && $scope.selectedProtocols.indexOf(item) === -1) {
                    $scope.currentSelection = '';
                    $scope.selectedProtocols.push(item);
                }
            };

            $scope.removeProtocol = function (protocol) {
                var index = $scope.selectedProtocols.indexOf(protocol);
                if (index !== -1) {
                    $scope.selectedProtocols.splice(index, 1);
                }
            };

            $scope.loadProtocols = function () {
                ProtocolService.query(function (response, headers) {
                    $scope.protocols = response;
                });
            };

            if ($scope.classification.id) {
                $scope.selectedProtocols = convertStringArrayToProtocolsArray($scope.classification.protocols);
            }

            $scope.loadProtocols();
        }]);
    })();
});

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/config.html":
/*!************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/config.html ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/config.html';
var html = "<div class=\"panel-body\">\n    <div class=\"navbar-form navbar-right\">\n        <button id=\"action.refresh\" class=\"btn btn-sm btn-default\" ng-click=\"refresh()\" title=\"Refresh list\"><i class=\"fa fa-refresh\"></i></button>\n    </div>\n    <div ng-show=\"groups.length == 0\">No groups defined.</div>\n    <pagination model=\"query\" ng-show=\"groups.length > 0\" position=\"bottom\" on-change=\"refresh\">\n        <table class=\"table table-bordered table-striped\">\n            <thead>\n            <tr>\n                <th class=\"col-md-1 text-nowrap\">Priority</th>\n                <th class=\"col-md-3 text-nowrap\">Name</th>\n                <th class=\"col-md-5 text-nowrap\">Description</th>\n                <th class=\"col-md-1 text-nowrap\">Editable</th>\n                <th class=\"col-md-2 text-nowrap\">Enabled</th>\n            </tr>\n            </thead>\n            <tbody>\n            <tr ng-repeat=\"group in groups\" data-row=\"{{group.name}}\">\n                <td class=\"text-nowrap\">{{group['priority']}}</td>\n                <td class=\"text-nowrap\">{{group['name']}}</td>\n                <td class=\"text-nowrap\">{{group['description']}}</td>\n                <td class=\"text-nowrap\">{{!group['readOnly']}}</td>\n                <td class=\"text-nowrap\">\n                    <toggle id=\"action.{{group.name}}.toggle\" size=\"btn-xs\" ng-model=\"group['enabled']\" ng-change=\"updateGroup(group)\"></toggle>\n                </td>\n            </tr>\n            </tbody>\n        </table>\n    </pagination>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/group.html":
/*!***********************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/group.html ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/group.html';
var html = "<div class=\"panel-body\">\n    <div class=\"navbar-form navbar-left\">\n        <h5 style=\"margin-left: -10px\">{{group.description}} <span class=\"label label-default\" ng-if=\"group.readOnly\">read-only</span></h5>\n    </div>\n    <div class=\"navbar-form navbar-right\">\n        <div class=\"input-group\" role=\"group\" ng-show=\"group.ruleCount > 0\">\n            <span class=\"input-group-addon\"><i class=\"fa fa-search\"/></span>\n            <input type=\"text\"\n                   id=\"action.search\"\n                   ng-model=\"query.search\"\n                   ng-change=\"refresh()\"\n                   placeholder=\"search...\"\n                   class=\"form-control\" />\n            <div class=\"input-group-btn\">\n                <button class=\"btn btn-default\" title=\"Clear search\" ng-click=\"clearSearch()\" ng-show=\"query.search\"><i class=\"fa fa-close\"/></button>\n            </div>\n        </div>\n\n        <div class=\"btn-group\" role=\"group\">\n            <button id=\"action.refresh\" class=\"btn btn-default\" ng-click=\"refreshAll()\" title=\"Refresh list\"><i class=\"fa fa-refresh\"></i></button>\n        </div>\n        <div class=\"btn-group\" role=\"group\" ng-show=\"!group.readOnly\">\n            <button id=\"action.addRule\" class=\"btn btn-default\" ng-click=\"addRule()\" title=\"Add new classification rule\"><i class=\"fa fa-plus\"></i></button>\n            <button ng-show=\"rules.length > 0\"\n                    id=\"action.deleteAll\"\n                    class=\"btn btn-default\"\n                    mwl-confirm\n                    title=\"Delete rules\"\n                    message=\"Do you want to delete all {{group.name}} rules?\"\n                    on-confirm=\"deleteAllRules()\"\n                    placement=\"left\"\n                    confirm-button-type=\"danger\"\n                    confirm-text=\"Yes\"\n                    cancel-text=\"No\"><i class=\"fa fa-trash-o\"></i></button>\n        </div>\n        <div class=\"btn-group\" role=\"group\" ng-show=\"!group.readOnly\">\n            <button id=\"action.importCSV\" class=\"btn btn-default\" ng-click=\"importRules()\" title=\"Import classification rules from CSV\"><i class=\"fa fa-upload\"></i></button>\n            <button id=\"action.exportCSV\" class=\"btn btn-default\" ng-click=\"showExportRulesDialog()\" title=\"Export classification rules as CSV\" >\n                <i class=\"fa fa-download\"></i>\n            </button>\n        </div>\n    </div>\n    <div class=\"row\" ng-show=\"rules.length == 0\"><div class=\"col-sm-12\"><pre>No rules defined.</pre></div></div>\n    <pagination model=\"query\" ng-show=\"rules.length > 0\" position=\"bottom\" on-change=\"refresh\">\n        <table class=\"table table-bordered table-striped\">\n            <thead>\n            <tr>\n                <th class=\"col-md-1 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('position')\">Position</a>\n                    <i ng-show=\"query.orderBy === 'position' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'position' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-1 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('name')\">Application</a>\n                    <i ng-show=\"query.orderBy === 'name' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'name' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-1 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('protocol')\">Protocol</a>\n                    <i ng-show=\"query.orderBy === 'protocol' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'protocol' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-2 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('srcAddress')\">Src. Address</a>\n                    <i ng-show=\"query.orderBy === 'srcAddress' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'srcAddress' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-1 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('srcPort')\">Src. Port</a>\n                    <i ng-show=\"query.orderBy === 'srcPort' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'srcPort' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-2 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('dstAddress')\">Dst. Address</a>\n                    <i ng-show=\"query.orderBy === 'dstAddress' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'dstAddress' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-1 text-nowrap\">\n                    <a ng-click=\"changeOrderBy('dstPort')\">Dst. Port</a>\n                    <i ng-show=\"query.orderBy === 'dstPort' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'dstPort' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th ng-class=\"{'col-md-2': group.readOnly === false, 'col-md-3': group.readOnly === true}\" class=\"text-nowrap\">\n                    <a ng-click=\"changeOrderBy('exporterFilter')\">Exporter Filter</a>\n                    <i ng-show=\"query.orderBy === 'exporterFilter' &amp;&amp; query.order === 'asc'\" class=\"fa fa-sort-asc\"/>\n                    <i ng-show=\"query.orderBy === 'exporterFilter' &amp;&amp; query.order === 'desc'\" class=\"fa fa-sort-desc\"/>\n                </th>\n                <th class=\"col-md-1\" ng-if=\"group.readOnly === false\">\n                    Actions\n                </th>\n            </tr>\n            </thead>\n\n            <tbody>\n            <tr ng-repeat=\"rule in rules\">\n                <td>{{rule['position']}}</td>\n                <td>{{rule['name']}}</td>\n                <td>\n                    <span ng-repeat=\"protocol in rule.protocols\" class=\"label label-default\" style=\"margin-right: 5px;\">{{protocol}}</span>\n                </td>\n                <td>{{rule['srcAddress']}}</td>\n                <td>{{rule['srcPort']}}</td>\n                <td>{{rule['dstAddress']}}</td>\n                <td>{{rule['dstPort']}}</td>\n                <td>{{rule['exporterFilter']}}</td>\n                <td ng-if=\"group.readOnly === false\">\n                    <div class=\"pull-right\">\n                        <button id=\"action.{{rule.position}}.edit\" class=\"btn btn-sm btn-default\" ng-click=\"editRule(rule)\" title=\"edit rule\"><i class=\"fa fa-edit\"></i></button>\n                        <button id=\"action.{{rule.position}}.delete\" class=\"btn btn-sm btn-default\" ng-click=\"deleteRule(rule)\" title=\"delete rule\"><i class=\"fa fa-trash-o\"></i></button>\n                    </div>\n                </td>\n            </tr>\n            </tbody>\n        </table>\n    </pagination>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/index.html":
/*!***********************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/index.html ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/index.html';
var html = "<div>\n    <div class=\"col\" ng-class=\"{'col-md-12': isClassificationCollapsed, 'col-md-9': !isClassificationCollapsed}\">\n        <ul id=\"tabs\" class=\"nav nav-tabs\">\n            <li role=\"presentation\" ui-sref-active=\"active\">\n                <a ui-sref=\"classifications.config\" data-name=\"settings\">Settings</a>\n            </li>\n\n            <li role=\"presentation\" ui-sref-active=\"active\" ng-repeat=\"group in groups\">\n                <a ui-sref=\"classifications.group({'id': group.id, 'group': group})\" title=\"{{group.description}}\" data-name={{group.name}}>\n                    {{group.name | capitalize}} Rules <span class=\"badge badge-primary\" title=\"{{group.ruleCount}} defined rules\">{{group.ruleCount}}</span>\n                </a>\n            </li>\n        </ul>\n        <div class=\"panel\" ui-view>\n        </div>\n    </div>\n\n    <button id=\"action.classification.toggle\" class=\"btn btn-default\"\n            style=\"position: absolute; right: 30px; z-index: 1000\"\n            ng-click=\"isClassificationCollapsed = !isClassificationCollapsed\"\n            title=\"{{isClassificationCollapsed ? 'Test classification' : 'Collapse classification panel'}}\">\n        <i class=\"fa\" ng-class=\"{'fa-magic': isClassificationCollapsed, 'fa-caret-right': !isClassificationCollapsed}\"/>\n    </button>\n\n    <div id=\"classification-tab\" class=\"col-md-3\" class=\"collapse\" uib-collapse=\"isClassificationCollapsed\">\n        <div>\n            <ul class=\"nav nav-tabs\">\n                <li role=\"presentation\" class=\"active\">\n                    <a>Test Classification</a>\n                </li>\n            </ul>\n        </div>\n        <div class=\"panel\">\n            <div class=\"panel-default panel-body\">\n                <div class=\"col-md-12\">\n                    <form name=\"classifyForm\">\n                        <div class=\"form-group\" ng-class=\"{ 'has-error' : ruleForm['classify-protocol'].$invalid || classifyError.protocol }\">\n                            <label class=\"control-label\" for=\"classify-protocol\">Protocol</label>\n                            <input class=\"form-control\"\n                                   type=\"text\"\n                                   autocomplete=\"off\"\n                                   id=\"classify-protocol\"\n                                   name=\"classify-protocol\"\n                                   ng-model=\"classificationRequest.protocol\"\n                                   placeholder=\"A valid RFC specified IP protocol, e.g. TCP, UDP\"\n                                   typeahead-min-length=\"0\"\n                                   uib-typeahead=\"protocol.keyword for protocol in protocols | filter:$viewValue\"\n                                   typeahead-editable=\"false\"/>\n                            <p id=\"classifyError.protocol\" ng-show=\"classifyError.protocol\" class=\"help-block\">{{classifyError.protocol}}</p>\n                        </div>\n                        <div class=\"form-group\" ng-class=\"{ 'has-error' : ruleForm['classify-exporterAddress'].$invalid || classifyError.exporterAddress }\">\n                            <label class=\"control-label\" for=\"classify-exporterAddress\">Exporter Address</label>\n                            <input class=\"form-control\" type=\"text\" id=\"classify-exporterAddress\" name=\"classify-exporterAddress\" placeholder=\"e.g. 10.0.0.1\" ng-model=\"classificationRequest.exporterAddress\"></input>\n                            <p id=\"classifyError.exporterAddress\" ng-show=\"classifyError.exporterAddress\" class=\"help-block\">{{classifyError.exporterAddress}}</p>\n                        </div>\n                        <div class=\"form-group col-md-8 col-sm-8 col-xs-8\" style=\"padding-left: 0\" ng-class=\"{ 'has-error' : ruleForm['classify-srcAddress'].$invalid || classifyError.srcAddress }\">\n                            <label class=\"control-label\" for=\"classify-srcAddress\" >Source Address</label>\n                            <input class=\"form-control\" type=\"text\" id=\"classify-srcAddress\" name=\"classify-srcAddress\" placeholder=\"e.g. 127.0.0.1\" ng-model=\"classificationRequest.srcAddress\"></input>\n                            <p id=\"classifyError.srcAddress\" ng-show=\"classifyError.srcAddress\" class=\"help-block\">{{classifyError.srcAddress}}</p>\n                        </div>\n                        <div class=\"form-group col-md-4 col-sm-4 col-xs-4\" style=\"padding-right: 0\" ng-class=\"{ 'has-error' : ruleForm['classify-srcPort'].$invalid || classifyError.srcPort }\">\n                            <label class=\"control-label\" for=\"classify-srcPort\" >Port</label>\n                            <input class=\"form-control\" type=\"text\" id=\"classify-srcPort\" name=\"classify-srcPort\" placeholder=\"e.g. 55252\" ng-model=\"classificationRequest.srcPort\"></input>\n                            <p id=\"classifyError.srcPort\" ng-show=\"classifyError.srcPort\" class=\"help-block\">{{classifyError.srcPort}}</p>\n                        </div>\n                        <div class=\"form-group col-md-8 col-sm-8 col-xs-8\" style=\"padding-left: 0\" ng-class=\"{ 'has-error' : ruleForm['classify-dstAddress'].$invalid || classifyError.dstAddress }\">\n                            <label class=\"control-label\" for=\"classify-dstAddress\">Destination Address</label>\n                            <input class=\"form-control\" type=\"text\" id=\"classify-dstAddress\" name=\"classify-dstAddress\" placeholder=\"e.g. 127.0.0.1\" ng-model=\"classificationRequest.dstAddress\"></input>\n                            <p id=\"classifyError.dstAddress\" ng-show=\"classifyError.dstAddress\" class=\"help-block\">{{classifyError.dstAddress}}</p>\n                        </div>\n                        <div class=\"form-group col-md-4 col-sm-4 col-xs-4\" style=\"padding-right: 0\" ng-class=\"{ 'has-error' : ruleForm['classify-dstPort'].$invalid || classifyError.dstPort }\">\n                            <label class=\"control-label\" for=\"classify-dstPort\">Port</label>\n                            <input class=\"form-control\" type=\"text\" id=\"classify-dstPort\" name=\"classify-dstPort\" placeholder=\"e.g. 80\" ng-model=\"classificationRequest.dstPort\"></input>\n                            <p id=\"classifyError.dstPort\" ng-show=\"classifyError.dstPort\" class=\"help-block\">{{classifyError.dstPort}}</p>\n                        </div>\n                        <div class=\"badge\" ng-show=\"classificationResponse\">\n                            <span id=\"classification-response\" title=\"Based on the current set of rules, the given flow would be mapped to\">{{classificationResponse}}</span>\n                        </div>\n                        <div class=\"col-lg12 col-md-12 col-sm-12 col-xs12 alert alert-danger\" ng-show=\"classifyError.entity\">\n                            <span id=\"classification-error\">{{classifyError.entity}}</span>\n                        </div>\n                        <div class=\"form-group\">\n                            <button type=\"submit\" class=\"btn btn-primary pull-right\" id=\"classification-submit\" ng-click=\"classify(classificationRequest)\" ng-disabled=\"classifyForm.$invalid || !fullyDefined()\">Classify</button>\n                        </div>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/modals/export-modal.html":
/*!*************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/modals/export-modal.html ***!
  \*************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/modals/export-modal.html';
var html = "<div id=\"exportModal\">\n<div class=\"modal-header\">\n    <h4 class=\"modal-title\">Export Classification Rules for Group: {{group.name}}</h4>\n</div>\n\n<div class=\"modal-body\">\n    <form name=\"exportGroupForm\">\n        <div class=\"form-group\">\n            <div class=\"form-group\"\n                 ng-class=\"{ 'has-error' : exportGroupForm.requestedFileName.$invalid }\">\n                <label class=\"control-label\" for=\"export.requestedFileName\">File Name</label>\n                <input class=\"form-control\" type=\"text\" id=\"export.requestedFileName\" name=\"requestedFileName\"\n                       value=\"{{group.id}}_rules.csv\" ng-model=\"export.requestedFileName\"\n                       ng-pattern=\"/^[a-zA-Z1-9_ .-]{1,}$/\"\n                       required/>\n                <p ng-show=\"exportGroupForm.requestedFileName.$invalid\" class=\"help-block\">\n                    A valid file name is required, allowed characters: [a-zA-Z1-9_ .-]</p>\n            </div>\n        </div>\n    </form>\n</div>\n<div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-primary\" ng-click=\"exportGroup()\" ng-disabled=\"exportGroupForm.$invalid\">Export</button>\n    <button type=\"button\" class=\"btn btn-default\" ng-click=\"$dismiss('cancelled by user')\">Cancel</button>\n</div>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/modals/import-modal.html":
/*!*************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/modals/import-modal.html ***!
  \*************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/modals/import-modal.html';
var html = "<div class=\"modal-header\">\n  <h4 class=\"modal-title\">Import Classification Rules</h4>\n</div>\n<div class=\"modal-body\">\n  <form class=\"form-horizontal\">\n    <div class=\"form-group\">\n      <label class=\"col-sm-3 control-label\">Group</label>\n      <div class=\"col-sm-9\">\n        <p class=\"form-control-static\">{{group.name}}</p>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <label class=\"col-sm-3 control-label\" for=\"importFile\">Select file to import</label>\n      <div class=\"col-sm-9\">\n        <div class=\"input-group\">\n          <span class=\"input-group-btn\">\n              <button ng-click=\"openFileDialogue()\" class=\"btn btn-default\" type=\"button\">Choose</button>\n          </span>\n          <input ng-click=\"openFileDialogue()\" type=\"text\" id=\"importFile\" class=\"form-control\" placeholder='Choose a file...' ng-model=\"fileToUpload.name\"/>\n          <span class=\"input-group-btn\">\n             <button class=\"btn btn-default\" type=\"button\" ng-click=\"resetInput()\">Reset</button>\n          </span>\n        </div>\n      </div>\n    </div>\n    <div class=\"form-group\">\n      <div class=\"col-sm-offset-3 col-sm-9\">\n        <div class=\"checkbox\">\n          <label>\n            <input type=\"checkbox\" ng-model=\"containsHeader\"> Contains header\n          </label>\n        </div>\n        <div class=\"checkbox\">\n          <label>\n            <input type=\"checkbox\" ng-model=\"deleteExistingRules\"> Delete existing rules\n          </label>\n        </div>\n      </div>\n    </div>\n    <input id=\"fileToImport\" type=\"file\" style=\"visibility:hidden; display:none\" onchange=\"angular.element(this).scope().setFile(this)\" />\n  </form>\n  <div class=\"alert alert-danger\" ng-show=\"error\">\n    {{error}}\n  </div>\n  <div ng-show=\"failedRows.length > 0\">\n    <pagination model=\"pagination\" position=\"bottom\" on-change=\"navigateWithinErrors\">\n      <table class=\"table table-bordered table-striped\">\n        <tbody>\n        <tr>\n          <th class=\"col-md-1 text-nowrap\">Row Index</th>\n          <th class=\"col-md-11 text-nowrap\">Error Message</th>\n        </tr>\n\n        <tr ng-repeat=\"failedRow in failedRows\">\n          <td class=\"text-nowwrap\">{{failedRow['index']}}</td>\n          <td class=\"text-nowwrap\">{{failedRow['message']}}</td>\n        </tr>\n        </tbody>\n      </table>\n    </pagination>\n  </div>\n</div>\n<div class=\"modal-footer\">\n  <div style=\"display: inline\" title=\"Please confirm deletion\">\n    <button type=\"button\" class=\"btn btn-primary\" ng-click=\"uploadFile()\" ng-show=\"fileToUpload\" title=\"Upload Rule\">Upload</button>\n  </div>\n  <button type=\"button\" class=\"btn btn-default\" ng-click=\"$dismiss('cancelled by user')\" >Cancel</button>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-classifications/views/modals/new-rule-modal.html":
/*!***************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-classifications/views/modals/new-rule-modal.html ***!
  \***************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-classifications/views/modals/new-rule-modal.html';
var html = "<style>\n  .protocol {\n    margin-right: 5px;\n    font-size: 90%;\n    font-weight: normal;\n  }\n  .protocol a {\n    color: white;\n  }\n\n  .protocol a:hover {\n    color: green;\n    cursor: pointer;\n  }\n</style>\n<div id=\"ruleModal\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\" ng-show=\"classification.id === undefined\">Create Classification Rule</h4>\n    <h4 class=\"modal-title\" ng-show=\"classification.id !== undefined\">Edit Classification Rule</h4>\n  </div>\n  <div class=\"modal-body\">\n    <form name=\"ruleForm\" novalidate>\n      <div class=\"form-group\" ng-class=\"{ 'has-error' : error.entity }\">\n        <p ng-show=\"error.entity\" class=\"help-block\">{{error.entity}}</p>\n      </div>\n      <div class=\"form-group\" ng-class=\"{ 'has-error' : ruleForm.name.$invalid || error.name }\">\n        <label class=\"control-label\" for=\"rule.name\">Application Name</label>\n        <input class=\"form-control\" type=\"text\" id=\"rule.name\" name=\"name\" placeholder=\"HTTP\" ng-model=\"classification.name\" required/>\n        <p ng-show=\"ruleForm.name.$invalid\" class=\"help-block\">The name is required.</p>\n        <p ng-show=\"error.name\" class=\"help-block\">{{error.name}}</p>\n      </div>\n      <div class=\"form-group col-md-8\" style=\"padding-left: 0\" ng-class=\"{ 'has-error' : ruleForm.srcAddress.$invalid || error.srcAddress}\">\n        <label class=\"control-label\" for=\"rule.srcAddress\">Source IP Address</label>\n        <input class=\"form-control\" type=\"text\" id=\"rule.srcAddress\" name=\"srcAddress\" placeholder=\"127.0.0.1\" ng-model=\"classification.srcAddress\"/>\n        <p ng-show=\"error.srcAddress\" class=\"help-block\">{{error.srcAddress}}</p>\n      </div>\n      <div class=\"form-group col-md-4\" style=\"padding-right: 0\" ng-class=\"{ 'has-error' : ruleForm.srcPort.$invalid || error.srcPort }\">\n        <label class=\"control-label\" for=\"rule.srcPort\">Source Port</label>\n        <input class=\"form-control\" type=\"text\" id=\"rule.srcPort\" name=\"srcPort\" placeholder=\"80,8080\" ng-model=\"classification.srcPort\"/>\n        <p class=\"help-block\">{{error.srcPort}}</p>\n      </div>\n      <div class=\"form-group col-md-8\" style=\"padding-left: 0\" ng-class=\"{ 'has-error' : ruleForm.dstAddress.$invalid || error.dstAddress}\">\n        <label class=\"control-label\" for=\"rule.dstAddress\">Destination IP Address</label>\n        <input class=\"form-control\" type=\"text\" id=\"rule.dstAddress\" name=\"dstAddress\" placeholder=\"127.0.0.1\" ng-model=\"classification.dstAddress\"/>\n        <p ng-show=\"error.dstAddress\" class=\"help-block\">{{error.dstAddress}}</p>\n      </div>\n      <div class=\"form-group col-md-4\" style=\"padding-right: 0\" ng-class=\"{ 'has-error' : ruleForm.dstPort.$invalid || error.dstPort }\">\n        <label class=\"control-label\" for=\"rule.dstPort\">Destination Port</label>\n        <input class=\"form-control\" type=\"text\" id=\"rule.dstPort\" name=\"dstPort\" placeholder=\"80,8080\" ng-model=\"classification.dstPort\"/>\n        <p class=\"help-block\">{{error.dstPort}}</p>\n      </div>\n      <div class=\"form-group\" ng-class=\"{ 'has-error' : ruleForm.exporterFilter.$invalid || error.exporterFilter }\">\n        <label class=\"control-label\" for=\"rule.exporterFilter\">Exporter Filter</label>\n        <button class=\"btn-link\"\n                style=\"padding-left: 0px;\"\n                uib-popover-html=\"'<div>The rule is only applied if the exporter of the flow matches the defined <a href=https://wiki.opennms.org/wiki/Filters target=_blank>filter</a>.</div>'\"\n                popover-trigger=\"'outsideClick'\"><i class=\"fa fa-question-circle\"/></button>\n        <input class=\"form-control\" type=\"text\" id=\"rule.exporterFilter\" name=\"exporterFilter\" placeholder=\"categoryName == 'Exporters' | ipAddr == '10.0.0.1'\" ng-model=\"classification.exporterFilter\"/>\n        <p ng-show=\"error.exporterFilter\" class=\"help-block\">{{error.exporterFilter}}</p>\n      </div>\n      <div class=\"form-group\" ng-class=\"{ 'has-error' : ruleForm.protocol.$invalid || error.protocol }\">\n        <label class=\"control-label\" for=\"rule.protocol\">IP Protocol</label>\n        <input class=\"form-control\" type=\"text\"\n               id=\"rule.protocol\"\n               name=\"protocol\"\n               ng-model=\"currentSelection\"\n               placeholder=\"tcp\"\n               typeahead-on-select=\"insertProtocol($item)\"\n               typeahead-min-length=\"0\"\n               uib-typeahead=\"protocol.keyword for protocol in protocols | filter:$viewValue\"\n               typeahead-editable=\"false\"/>\n        <span ng-repeat=\"protocol in selectedProtocols\" class=\"label label-default protocol\">\n          {{protocol.keyword | uppercase}} <a name=\"remove-protocol\" ng-click=\"removeProtocol(protocol)\"><i class=\"fa fa-remove\" title=\"remove protocol\"></i></a>\n        </span>\n        <p ng-show=\"error.protocol\" class=\"help-block\">{{error.protocol}}</p>\n      </div>\n    </form>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-primary\" id=\"save-rule\" ng-click=\"save()\" ng-disabled=\"ruleForm.$invalid\">{{buttonName}}</button>\n    <button type=\"button\" class=\"btn btn-default\" id=\"cancel-rule\" ng-click=\"cancel()\" >Cancel</button>\n  </div>\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-elementList/lib/elementList.js":
/*!*********************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/lib/elementList.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! ../templates/angular-onms-elementList-editListInPlace.html */ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html"), __webpack_require__(/*! ../templates/angular-onms-elementList-editMapInPlace.html */ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, angular, jQuery, editListInPlaceTemplate, editMapInPlaceTemplate) {
	'use strict';

	var MODULE_NAME = 'onms.elementList';

	/**
  * ISO-8601 date format string.
  */
	window.ISO_8601_DATE_FORMAT = 'yyyy-MM-ddTHH:mm:ss.sssZ';
	window.ISO_8601_DATE_FORMAT_WITHOUT_MILLIS = 'yyyy-MM-ddTHH:mm:ssZ';

	/**
  * Function used to append an extra transformer to the default $http transforms.
  */
	var appendTransform = function appendTransform(defaultTransform, transform) {
		var t = angular.isArray(defaultTransform) ? defaultTransform : [defaultTransform];
		return t.concat(transform);
	};

	/**
  * Convert from a clause into a FIQL query string.
  */
	var toFiql = function toFiql(clauses) {
		var first = true;
		var fiql = '';
		for (var i = 0; i < clauses.length; i++) {
			if (!first) {
				fiql += ';';
			}
			fiql += clauses[i].property;

			switch (clauses[i].operator) {
				case 'EQ':
					fiql += '==';break;
				case 'NE':
					fiql += '!=';break;
				case 'LT':
					fiql += '=lt=';break;
				case 'LE':
					fiql += '=le=';break;
				case 'GT':
					fiql += '=gt=';break;
				case 'GE':
					fiql += '=ge=';break;
				default:
					// otherwise, do nothing
					break;
			}

			fiql += escapeSearchValue(clauses[i].value);

			first = false;
		}
		return fiql;
	};

	/**
  * Convert from a FIQL query string into separate clause objects.
  * This only works for simple queries composed of multiple AND (';')
  * clauses.
  * 
  * TODO: Expand this to cover more FIQL syntax
  */
	var fromFiql = function fromFiql(fiql) {
		var statements = fiql.split(';');
		var segments = [];
		var clauses = [];
		for (var i = 0; i < statements.length; i++) {
			if (statements[i].indexOf('==') > 0) {
				segments = statements[i].split('==');
				clauses.push({
					property: segments[0],
					operator: 'EQ',
					value: segments[1]
				});
			} else if (statements[i].indexOf('!=') > 0) {
				segments = statements[i].split('!=');
				clauses.push({
					property: segments[0],
					operator: 'NE',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=lt=') > 0) {
				segments = statements[i].split('=lt=');
				clauses.push({
					property: segments[0],
					operator: 'LT',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=le=') > 0) {
				segments = statements[i].split('=le=');
				clauses.push({
					property: segments[0],
					operator: 'LE',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=gt=') > 0) {
				segments = statements[i].split('=gt=');
				clauses.push({
					property: segments[0],
					operator: 'GT',
					value: segments[1]
				});
			} else if (statements[i].indexOf('=ge=') > 0) {
				segments = statements[i].split('=ge=');
				clauses.push({
					property: segments[0],
					operator: 'GE',
					value: segments[1]
				});
			}
		}
		return clauses;
	};

	/**
  * Parse an HTTP Content-Range header into the start, end, and total fields.
  * The header should be in a format like: "items 0-14/28".
  * 
  * @param contentRange String from the Content-Range header
  */
	var parseContentRange = function parseContentRange(contentRange) {
		if (!contentRange) {
			return { start: 0, end: 0, total: 0 };
		}
		// Example: items 0-14/28
		var pattern = /items\s+?(\d+)\s*-\s*(\d+)\s*\/\s*(\d+)/;
		return {
			start: Number(contentRange.replace(pattern, '$1')),
			end: Number(contentRange.replace(pattern, '$2')),
			total: Number(contentRange.replace(pattern, '$3'))
		};
	};

	/**
  * Escape FIQL reserved characters by URL-encoding them. Reserved characters are:
  * <ul>
  * <li>!</li>
  * <li>$</li>
  * <li>'</li>
  * <li>(</li>
  * <li>)</li>
  * <li>*</li>
  * <li>+</li>
  * <li>,</li>
  * <li>;</li>
  * <li>=</li>
  * </ul>
  * @param value
  * @returns String with reserved characters URL-encoded
  */
	var escapeSearchValue = function escapeSearchValue(value) {
		if (typeof value === 'string') {
			return value.replace('!', '%21').replace('$', '%24').replace('\'', '%27').replace('(', '%28').replace(')', '%29')
			// People are going to type this in as a wildcard, so I
			// guess they'll have to type in '%2A' if they want to
			// match an asterisk...
			//.replace('*', '%2A')
			.replace('+', '%2B').replace(',', '%2C').replace(';', '%3B').replace('=', '%3D');
		}
		return value;
	};

	var normalizeOffset = function normalizeOffset(offset, maxOffset, limit) {
		var newOffset = offset;

		// Offset of the last page
		var lastPageOffset = void 0;
		if (maxOffset < 0) {
			newOffset = 0;
			lastPageOffset = 0;
		} else {
			lastPageOffset = Math.floor(maxOffset / limit) * limit;
		}

		// Bounds checking
		newOffset = newOffset < 0 ? 0 : newOffset;
		newOffset = newOffset > lastPageOffset ? lastPageOffset : newOffset;

		// Make sure that offset is a multiple of limit
		newOffset = Math.floor(newOffset / limit) * limit;

		return newOffset;
	};

	/* // BMR: this doesn't seem to actually be used anywhere
 String.prototype.endsWith = function(suffix) {
 	return this.indexOf(suffix, this.length - suffix.length) !== -1;
 };
 */

	// $filters that can be used to create human-readable versions of filter values
	angular.module('onmsListFilters', []).filter('operator', function () {
		return function (input, value) {
			// See if the string contains a wildcard
			var fuzzy = typeof value === 'string' && value.indexOf('*') > -1;

			switch (input) {
				case 'EQ':
					return fuzzy ? 'is like' : 'equals';
				case 'NE':
					return fuzzy ? 'is not like' : 'does not equal';
				case 'LT':
					return 'is less than';
				case 'LE':
					return 'is less than or equal';
				case 'GT':
					return 'is greater than';
				case 'GE':
					return 'is greater than or equal';
				default:
					// If no match, return the input
					return input;
			}
		};
	}).filter('isNotEmpty', function () {
		return function (input) {
			return input && (typeof input === 'string' ? input.trim() !== '' : true);
		};
	});

	// List module
	angular.module(MODULE_NAME, []).config(['$locationProvider', function ($locationProvider) {
		$locationProvider.html5Mode({
			// Use HTML5 
			enabled: true,
			// Don't rewrite all <a> links on the page
			rewriteLinks: false
		});
	}]).directive('onmsListEditInPlace', function () {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;
				$scope.originalValue = angular.copy($scope.value);

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					$scope.editing = false;
				};

				$scope.onKeyup = function ($event) {
					// If the user types ESC, then abort the edit
					if ($event.keyCode === 27) {
						$scope.cancel();
					}
				};

				$scope.submit = function () {
					$scope.onSubmit();
					// TODO: Handle update failures
					// Now that we've save a new value, use it as the original value
					$scope.originalValue = $scope.value;
					// Switch out of edit mode
					$scope.unedit();
				};

				$scope.cancel = function () {
					// Restore the original value
					$scope.value = $scope.originalValue;
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				item: '=',
				value: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onSubmit: '&onSubmit'
			},
			templateUrl: editListInPlaceTemplate,
			transclude: true
		};
	}).directive('onmsListEditListInPlace', ['$window', function ($window) {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					// Undo any edits
					$scope.newValue = null;
					$scope.editing = false;
				};

				$scope.onKeyup = function (event) {
					switch (event.keyCode) {
						// If the user types Enter, then submit the edit
						case 13:
							$scope.add($scope.values, $scope.newValue);break;
						// If the user types ESC, then abort the edit
						case 27:
							$scope.unedit();break;
						// otherwise, do nothing
						default:
							break;
					}
				};

				$scope.confirmAndRemove = function (items, item) {
					// Splice the value out of the array
					if ($window.confirm('Are you sure you want to remove "' + item + '"?')) {
						items.splice(items.indexOf(item), 1);
						$scope.onEdit();
					}
				};

				$scope.add = function (items, item) {
					items.push(item);
					items.sort();
					// TODO: Handle update failures
					$scope.onEdit();
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				values: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onEdit: '&onEdit'
			},
			templateUrl: editListInPlaceTemplate,
			transclude: true
		};
	}]).directive('onmsListEditMapInPlace', ['$window', function ($window) {
		return {
			controller: ['$scope', function controller($scope) {
				$scope.editing = false;

				// Start editing the value
				$scope.edit = function () {
					$scope.editing = true;
				};

				// Stop editing the value
				$scope.unedit = function () {
					// Undo any edits
					$scope.newKey = null;
					$scope.newValue = null;
					$scope.editing = false;
				};

				$scope.onKeyup = function (event) {
					switch (event.keyCode) {
						// If the user types Enter, then submit the edit
						case 13:
							$scope.add($scope.values, $scope.newKey, $scope.newValue);break;
						// If the user types ESC, then abort the edit
						case 27:
							$scope.unedit();break;
						// otherwise, do nothing
						default:
							break;
					}
				};

				$scope.confirmAndRemove = function (items, key) {
					// Splice the value out of the array
					if ($window.confirm('Are you sure you want to remove "' + key + '"?')) {
						delete items[key];
						$scope.onEdit();
					}
				};

				$scope.add = function (items, key, value) {
					items[key] = value;
					// TODO: Handle update failures
					$scope.onEdit();
					// Switch out of edit mode
					$scope.unedit();
				};
			}],
			// Use an isolated scope
			scope: {
				values: '=',
				keyType: '=',
				valueType: '=',
				// Optional step attribute for number fields
				step: '=',
				onEdit: '&onEdit'
			},
			templateUrl: editMapInPlaceTemplate,
			transclude: true
		};
	}])

	/**
  * Generic list controller
  */
	.controller('ListCtrl', ['$scope', '$location', '$window', '$log', '$filter', function ($scope, $location, $window, $log, $filter) {
		$log.debug('ListCtrl initializing...');

		$scope.defaults = {
			_s: '',
			searchClauses: [],
			limit: 20,
			offset: 0,
			orderBy: '',
			order: 'asc'
		};

		var initialLimit = typeof $location.search().limit === 'undefined' ? $scope.defaults.limit : Number($location.search().limit) > 0 ? Number($location.search().limit) : $scope.defaults.limit;

		// Restore any query parameters that you can from the 
		// query string, blank out the rest
		$scope.query = {
			lastOffset: 0,
			maxOffset: 0,

			searchParam: typeof $location.search()._s === 'undefined' ? $scope.defaults._s : $location.search()._s,
			searchClauses: typeof $location.search()._s === 'undefined' ? $scope.defaults.searchClauses : fromFiql($location.search()._s),
			limit: initialLimit,
			newLimit: initialLimit,
			offset: typeof $location.search().offset === 'undefined' ? $scope.defaults.offset : Number($location.search().offset) > 0 ? normalizeOffset(Number($location.search().offset), Number.MAX_VALUE, initialLimit) : $scope.defaults.offset,

			// TODO: Validate that the orderBy is in a list of supported properties
			orderBy: typeof $location.search().orderBy === 'undefined' ? $scope.defaults.orderBy : $location.search().orderBy,
			order: typeof $location.search().order === 'undefined' ? $scope.defaults.order : $location.search().order === 'asc' ? 'asc' : 'desc'
		};

		// Sync the query hash with the $location query string
		$scope.$watch('query', function () {
			var queryParams = angular.copy($scope.query);

			// Delete derived values that we don't need in the query string
			delete queryParams.searchClauses;
			delete queryParams.newLimit;
			delete queryParams.lastOffset;
			delete queryParams.maxOffset;

			// Rename searchParam to _s
			queryParams._s = queryParams.searchParam === '' ? null : queryParams.searchParam;
			delete queryParams.searchParam;

			// Delete any parameters that have default or blank values
			if (queryParams.limit === $scope.defaults.limit || queryParams.limit === '') {
				delete queryParams.limit;
			}
			if (queryParams.offset === $scope.defaults.offset || queryParams.offset === '') {
				delete queryParams.offset;
			}
			if (queryParams.orderBy === $scope.defaults.orderBy || queryParams.orderBy === '') {
				delete queryParams.orderBy;
			}
			if (queryParams.order === $scope.defaults.order || queryParams.order === '') {
				delete queryParams.order;
			}
			if (queryParams._s === $scope.defaults._s || queryParams._s === '') {
				delete queryParams._s;
			}

			$location.search(queryParams);
		}, true // Use object equality because the reference doesn't change
		);

		// Add the search clause to the list of clauses
		$scope.addSearchClause = function (clause) {
			if (angular.isDate(clause.value)) {
				// Returns a value in yyyy-MM-ddTHH:mm:ss.sssZ format
				// Unfortunately, I don't think CXF will like this because
				// it includes the millisecond portion of the date.
				//clause.value = new Date(clause.value).toISOString();

				clause.value = $filter('date')(new Date(clause.value), ISO_8601_DATE_FORMAT);
			}

			// Make sure the clause isn't already in the list of search clauses
			if ($scope.getSearchClause(clause)) {
				return;
			}

			// TODO: Add validation?
			$scope.query.searchClauses.push(angular.copy(clause));
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		$scope.getSearchClause = function (clause) {
			for (var i = 0; i < $scope.query.searchClauses.length; i++) {
				if ($scope.clauseEquals(clause, $scope.query.searchClauses[i])) {
					return $scope.query.searchClauses[i];
				}
			}
			return null;
		};

		$scope.clauseEquals = function (a, b) {
			return a.property === b.property && a.operator === b.operator && a.value === b.value;
		};

		// Convert an epoch timestamp into String format before adding the search clause
		$scope.addEpochTimestampSearchClause = function (clause) {
			clause.value = $filter('date')(clause.value, ISO_8601_DATE_FORMAT);
			$scope.addSearchClause(clause);
		};

		// Remove a search clause from the list of clauses
		$scope.removeSearchClause = function (clause) {
			// TODO: Add validation?
			$scope.query.searchClauses.splice($scope.query.searchClauses.indexOf(clause), 1);
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		$scope.removeSearchClauses = function (clauses) {
			for (var i = 0; i < clauses.length; i++) {
				var index = $scope.query.searchClauses.indexOf(clauses[i]);
				if (index >= 0) {
					$scope.query.searchClauses.splice(index, 1);
				}
			}
			$scope.query.searchParam = toFiql($scope.query.searchClauses);
			$scope.refresh();
		};

		// Replace a search clause with a new clause
		$scope.replaceSearchClause = function (oldClause, newClause) {
			if (angular.isDate(newClause.value)) {
				// Returns a value in yyyy-MM-ddTHH:mm:ss.sssZ format
				// Unfortunately, I don't think CXF will like this because
				// it includes the millisecond portion of the date.
				//clause.value = new Date(clause.value).toISOString();

				newClause.value = $filter('date')(new Date(newClause.value), ISO_8601_DATE_FORMAT);
			}

			// TODO: Add validation?
			var scopeOldClause = $scope.getSearchClause(oldClause);
			var scopeNewClause = $scope.getSearchClause(newClause);
			if (!scopeOldClause) {
				if (!scopeNewClause) {
					// If the old clause is not present, simply add the new clause
					$scope.addSearchClause(newClause);
				} else {
					// If the old clause is not present and the new clause is already
					// present, then do nothing
				}
			} else {
				if (!scopeNewClause) {
					// If the old clause is present and the new clause is not, replace
					// the values inside the old clause and then refresh
					scopeOldClause.property = newClause.property;
					scopeOldClause.operator = newClause.operator;
					scopeOldClause.value = newClause.value;

					$scope.query.searchParam = toFiql($scope.query.searchClauses);
					$scope.refresh();
				} else {
					// If the old clause is present and the new clause is present,
					// then just remove the old clause (as if it had been replaced by
					// the already-existing new clause)
					$scope.removeSearchClause(oldClause);
				}
			}
		};

		// Clear the current search
		$scope.clearSearch = function () {
			if ($scope.query.searchClauses.length > 0) {
				$scope.query.searchClauses = [];
				$scope.query.searchParam = '';
				$scope.refresh();
			}
		};

		// Change the sorting of the table
		$scope.changeOrderBy = function (property) {
			if ($scope.query.orderBy === property) {
				// TODO: Figure out if we should reset limit/offset here also
				// If the property is already selected then reverse the sorting
				$scope.query.order = $scope.query.order === 'asc' ? 'desc' : 'asc';
			} else {
				// TODO: Figure out if we should reset limit/offset here also
				$scope.query.orderBy = property;
				$scope.query.order = $scope.defaults.order;
			}
			$scope.refresh();
		};

		$scope.setOffset = function (offset) {
			var o = normalizeOffset(offset, $scope.query.maxOffset, $scope.query.limit);

			if ($scope.query.offset !== o) {
				$scope.query.offset = o;
				$scope.refresh();
			}
		};

		$scope.setLimit = function (limit) {
			if (limit < 1) {
				$scope.query.newLimit = $scope.query.limit;
				// TODO: Throw a validation error
				return;
			}
			if ($scope.query.limit !== limit) {
				$scope.query.limit = limit;
				$scope.query.offset = normalizeOffset($scope.query.offset, $scope.query.maxOffset, $scope.query.limit);
				$scope.refresh();
			}
		};

		// Override this to implement updates to an object
		$scope.refresh = function () {
			$log.warn('You need to override $scope.$parent.refresh() in your controller');
		};

		// Override this to implement updates to an object
		$scope.update = function () {
			$log.warn('You need to override $scope.$parent.update() in your controller');
		};

		// Override this to implement deletions
		$scope.deleteItem = function (item) {
			$log.warn('You need to override $scope.$parent.deleteItem() in your controller');
		};

		$log.debug('ListCtrl initialized');
	}]).run(['$rootScope', '$log', function ($rootScope, $log) {
		$log.debug('Finished initializing ' + MODULE_NAME);
	}]);

	/*
 angular.element(document).ready(function() {
 	console.log('Bootstrapping ' + MODULE_NAME);
 	angular.bootstrap(document, [MODULE_NAME]);
 });
 */

	module.exports = {
		appendTransform: appendTransform,
		toFiql: toFiql,
		fromFiql: fromFiql,
		parseContentRange: parseContentRange,
		escapeSearchValue: escapeSearchValue,
		normalizeOffset: normalizeOffset
	};
});

/***/ }),

/***/ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html":
/*!**********************************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html ***!
  \**********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editListInPlace.html';
var html = "<!-- Show all of the current values -->\n<span ng-repeat=\"value in values\">\n\t<button class=\"btn btn-xs btn-default\" ng-click=\"confirmAndRemove(values, value)\" style=\"margin-bottom:3px;margin-right:3px;\">\n\t\t{{value}}&nbsp;<i class=\"fa fa-close\"/>\n\t</button>\n</span>\n\n<!-- Edit button -->\n<span style=\"line-height:24px;\" ng-hide=\"editing\">\n\t<a style=\"text-decoration: none;\" ng-click=\"edit()\"><i class=\"fa fa-edit fa-lg\"/></a>&nbsp;\n</span>\n\n<!-- TODO: Add the ability to support select controls -->\n<!-- Input for new item -->\n<span ng-show=\"editing\" class=\"text-nowrap\">\n\t<input type=\"{{valueType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newValue\"/>\n\t<a style=\"text-decoration: none;\" ng-click=\"add(values, newValue)\"><i class=\"fa fa-plus fa-lg\"/></a>\n\t<a style=\"text-decoration: none;\" ng-click=\"unedit()\"><i class=\"fa fa-close fa-lg\"/></a>\n</span>\n\n<!-- Transclude any content inside the tag -->\n<span ng-transclude/>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html":
/*!*********************************************************************************************************!*\
  !*** ./src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html ***!
  \*********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/apps/onms-elementList/templates/angular-onms-elementList-editMapInPlace.html';
var html = "<!-- Show all of the current values -->\n<span ng-repeat=\"(key,value) in values\">\n\t<button class=\"btn btn-xs btn-default\" ng-click=\"confirmAndRemove(values, key)\" style=\"margin-bottom:3px;margin-right:3px;\">\n\t\t<b>{{key}}:</b> {{value}}&nbsp;<i class=\"fa fa-close\"/>\n\t</button>\n</span>\n\n<!-- Edit button -->\n<span style=\"line-height:24px;\" ng-hide=\"editing\">\n\t<a style=\"text-decoration: none;\" ng-click=\"edit()\"><i class=\"fa fa-edit fa-lg\"/></a>&nbsp;\n</span>\n\n<!-- TODO: Add the ability to support select controls -->\n<!-- Input for new item -->\n<span ng-show=\"editing\" class=\"text-nowrap\">\n\t<input type=\"{{keyType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newKey\"/>\n\t<input type=\"{{valueType}}\" ng-keyup=\"onKeyup($event)\" ng-model=\"newValue\"/>\n\t<a style=\"text-decoration: none;\" ng-click=\"add(values, newKey, newValue)\"><i class=\"fa fa-plus fa-lg\"/></a>\n\t<a style=\"text-decoration: none;\" ng-click=\"unedit()\"><i class=\"fa fa-close fa-lg\"/></a>\n</span>\n\n<!-- Transclude any content inside the tag -->\n<span ng-transclude/>\n";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/lib/onms-http/index.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/lib/onms-http/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (module, angular) {
    'use strict';

    angular.module('onms.http', []).config(['$httpProvider', function ($httpProvider) {
        $httpProvider.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
    }]);

    module.exports = angular;
});

/***/ }),

/***/ "./src/main/assets/js/lib/onms-pagination/index.js":
/*!*********************************************************!*\
  !*** ./src/main/assets/js/lib/onms-pagination/index.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! vendor/angular-js */ "./src/main/assets/js/vendor/angular-js.js"), __webpack_require__(/*! ./pagination-toolbar.html */ "./src/main/assets/js/lib/onms-pagination/pagination-toolbar.html")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else { var mod; }
})(this, function (angular, paginationTemplate) {
    'use strict';

    var MODULE_NAME = 'onms.pagination';

    angular.module(MODULE_NAME, ['ui.bootstrap']).directive('pagination', function () {
        return {
            restrict: 'E',
            scope: {
                model: '=model',
                position: '@position',
                onChangeCallback: '=onChange'
            },
            link: function link(scope, element, attrs) {
                if (scope.model === undefined) {
                    throw new Error('No model defined.');
                }
                if (scope.model.page === undefined) {
                    throw new Error('No attribute model.page defined');
                }
                if (scope.model.totalItems === undefined) {
                    throw new Error('No attribute model.totalItems defined');
                }
                if (scope.model.limit === undefined) {
                    throw new Error('No attribute model.limit defined');
                }

                var currentPage = scope.model.page;
                scope.onChange = function () {
                    if (currentPage !== scope.model.page) {
                        currentPage = scope.model.page;
                        if (scope.onChangeCallback) {
                            scope.onChangeCallback();
                        }
                    }
                };
            },
            transclude: true,
            templateUrl: paginationTemplate
        };
    });
});

/***/ }),

/***/ "./src/main/assets/js/lib/onms-pagination/pagination-toolbar.html":
/*!************************************************************************!*\
  !*** ./src/main/assets/js/lib/onms-pagination/pagination-toolbar.html ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var path = '/home/bamboo/opennms-release/opennms-source/core/web-assets/src/main/assets/js/lib/onms-pagination/pagination-toolbar.html';
var html = "<div>\n    <!-- Content for pagination -->\n    <div ng-transclude ng-if=\"position === 'bottom'\"></div>\n\n    <!-- Paging controls -->\n    <div class=\"row\">\n        <div class=\"col-md-6 col-lg-6 col-sm-8\" ng-show=\"(model.totalItems / model.limit) > 1\">\n            <div style=\"margin: 0px;\"\n                 uib-pagination\n                 ng-model=\"model.page\"\n                 total-items=\"model.totalItems\"\n                 items-per-page=\"model.limit\"\n                 rotate=\"true\"\n                 boundary-links=\"true\"\n                 max-size=\"5\"\n                 boundary-link-numbers=\"true\"\n                 ng-change=\"onChange()\">\n            </div>\n        </div>\n        <div class=\"col-md-6 col-lg-6 col-sm-4\">\n            <pre class=\"pull-right\" ng-show=\"model.totalItems == 0\">No items found.</pre>\n            <pre class=\"pull-right\" ng-show=\"model.totalItems > 0\">{{model.totalItems / model.page === 1\n            ? \"Item \" + (model.offset + 1)\n            : \"Items \" + ((model.page - 1) * model.limit + 1) + \" - \" + (model.page * model.limit > model.totalItems ? model.totalItems : model.page * model.limit)}} ({{model.totalItems}} total)</pre>\n        </div>\n    </div>\n\n    <!-- Content for pagination -->\n    <div ng-transclude ng-if=\"position === 'top' || position === undefined\"></div>\n\n</div>";
window.angular.module('ng').run(['$templateCache', function(c) { c.put(path, html) }]);
module.exports = path;

/***/ }),

/***/ "./src/main/assets/js/vendor/angular-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/angular-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! angular */ "./node_modules/angular/index.js-exposed"), __webpack_require__(/*! angular-animate */ "./node_modules/angular-animate/index.js"), __webpack_require__(/*! angular-cookies */ "./node_modules/angular-cookies/index.js"), __webpack_require__(/*! angular-route */ "./node_modules/angular-route/index.js"), __webpack_require__(/*! angular-resource */ "./node_modules/angular-resource/index.js"), __webpack_require__(/*! angular-sanitize */ "./node_modules/angular-sanitize/index.js"), __webpack_require__(/*! angular-growl-v2 */ "./node_modules/angular-growl-v2/build/angular-growl.min.js"), __webpack_require__(/*! angular-loading-bar */ "./node_modules/angular-loading-bar/index.js"), __webpack_require__(/*! angular-growl-v2/build/angular-growl.css */ "./node_modules/angular-growl-v2/build/angular-growl.css"), __webpack_require__(/*! angular-loading-bar/build/loading-bar.css */ "./node_modules/angular-loading-bar/build/loading-bar.css"), __webpack_require__(/*! vendor/bootstrap-js */ "./src/main/assets/js/vendor/bootstrap-js.js"), __webpack_require__(/*! angular-bootstrap-checkbox */ "./node_modules/angular-bootstrap-checkbox/angular-bootstrap-checkbox.js"), __webpack_require__(/*! angular-ui-bootstrap */ "./node_modules/angular-ui-bootstrap/index.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, angular) {
  'use strict';

  console.log('init: angular-js'); // eslint-disable-line no-console

  /* Bootstrap UI */


  /* 3rd-Party Modules */
  /* Angular Core */
  module.exports = window['angular'] = angular;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/bootstrap-js.js":
/*!***************************************************!*\
  !*** ./src/main/assets/js/vendor/bootstrap-js.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! vendor/jquery-js */ "./src/main/assets/js/vendor/jquery-js.js"), __webpack_require__(/*! bootstrap/dist/js/npm */ "./node_modules/bootstrap/dist/js/npm.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: bootstrap-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ }),

/***/ "./src/main/assets/js/vendor/jquery-js.js":
/*!************************************************!*\
  !*** ./src/main/assets/js/vendor/jquery-js.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js-exposed")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (module, jQuery) {
  'use strict';

  console.log('init: jquery-js'); // eslint-disable-line no-console

  module.exports = jQuery;
});

/***/ })

},[["./src/main/assets/js/apps/onms-classifications/index.js","vendor"]]]);
});
//# sourceMappingURL=onms-classifications.js.map