/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import java.util.Optional;

public class Timeout {
    private final Long flowActiveTimeout;
    private final Long flowInActiveTimeout;
    private Long numBytes;
    private Long numPackets;
    private Long firstSwitched;
    private Long lastSwitched;

    public Timeout(Long active, Long inactive) {
        this.flowActiveTimeout = active;
        this.flowInActiveTimeout = inactive;
    }

    public void setNumBytes(Long numBytes) {
        this.numBytes = numBytes;
    }

    public void setNumPackets(Long numPackets) {
        this.numPackets = numPackets;
    }

    public void setFirstSwitched(Long firstSwitched) {
        this.firstSwitched = firstSwitched;
    }

    public void setLastSwitched(Long lastSwitched) {
        this.lastSwitched = lastSwitched;
    }

    public Long getDeltaSwitched() {
        if (this.flowActiveTimeout != null && this.flowInActiveTimeout != null) {
            long active = this.flowActiveTimeout * 1000L;
            long inActive = this.flowInActiveTimeout * 1000L;
            long numBytes = this.numBytes != null ? this.numBytes : 0L;
            long numPackets = this.numPackets != null ? this.numPackets : 0L;
            long firstSwitched = this.firstSwitched != null ? this.firstSwitched : 0L;
            long lastSwitched = this.lastSwitched != null ? this.lastSwitched : 0L;
            return Optional.of(this).map(timeoutValue -> numBytes > 0L || numPackets > 0L ? active : inActive).map(timeoutValue -> lastSwitched - timeoutValue).map(t -> Math.max(firstSwitched, t)).orElse(firstSwitched);
        }
        return this.firstSwitched;
    }
}

