/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.SequenceNumberTracker;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class UdpSessionManager {
    private final Map<TemplateKey, TemplateWrapper> templates = Maps.newHashMap();
    private final Map<TemplateKey, Map<Set<Value<?>>, List<Value<?>>>> options = Maps.newHashMap();
    private final Map<DomainKey, SequenceNumberTracker> sequenceNumbers = Maps.newHashMap();
    private final Duration timeout;
    private final Supplier<SequenceNumberTracker> sequenceNumberTracker;

    public UdpSessionManager(Duration timeout, Supplier<SequenceNumberTracker> sequenceNumberTracker) {
        this.timeout = timeout;
        this.sequenceNumberTracker = Objects.requireNonNull(sequenceNumberTracker);
    }

    public void doHousekeeping() {
        Instant timeout = Instant.now().minus(this.timeout);
        this.templates.entrySet().removeIf(e -> ((TemplateWrapper)e.getValue()).insertionTime.isBefore(timeout));
    }

    public Session getSession(SessionKey sessionKey) {
        return new UdpSession(sessionKey);
    }

    public void drop(SessionKey sessionKey) {
        this.templates.entrySet().removeIf(e -> Objects.equals(((TemplateKey)e.getKey()).domain.sessionKey, sessionKey));
    }

    public int count() {
        return this.templates.size();
    }

    private static final class TemplateWrapper {
        public final Instant insertionTime = Instant.now();
        public final Template template;

        private TemplateWrapper(Template template) {
            this.template = template;
        }
    }

    private static final class TemplateKey {
        public final DomainKey domain;
        public final int templateId;

        TemplateKey(SessionKey sessionKey, long observationDomainId, int templateId) {
            this.domain = new DomainKey(sessionKey, observationDomainId);
            this.templateId = templateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateKey)) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.domain, that.domain) && Objects.equals(this.templateId, that.templateId);
        }

        public int hashCode() {
            return Objects.hash(this.domain, this.templateId);
        }
    }

    private static final class DomainKey {
        public final SessionKey sessionKey;
        public final long observationDomainId;

        private DomainKey(SessionKey sessionKey, long observationDomainId) {
            this.sessionKey = Objects.requireNonNull(sessionKey);
            this.observationDomainId = observationDomainId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DomainKey)) {
                return false;
            }
            DomainKey that = (DomainKey)o;
            return Objects.equals(this.observationDomainId, that.observationDomainId) && Objects.equals(this.sessionKey, that.sessionKey);
        }

        public int hashCode() {
            return Objects.hash(this.sessionKey, this.observationDomainId);
        }
    }

    private final class UdpSession
    implements Session {
        private final SessionKey sessionKey;

        public UdpSession(SessionKey sessionKey) {
            this.sessionKey = sessionKey;
        }

        @Override
        public void addTemplate(long observationDomainId, Template template) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, template.id);
            UdpSessionManager.this.templates.put(key, new TemplateWrapper(template));
        }

        @Override
        public void removeTemplate(long observationDomainId, int templateId) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, templateId);
            UdpSessionManager.this.templates.remove(key);
        }

        @Override
        public void removeAllTemplate(long observationDomainId, Template.Type type) {
            UdpSessionManager.this.templates.entrySet().removeIf(e -> ((TemplateKey)e.getKey()).domain.observationDomainId == observationDomainId && ((TemplateWrapper)e.getValue()).template.type == type);
        }

        @Override
        public void addOptions(long observationDomainId, int templateId, Collection<Value<?>> scopes, List<Value<?>> values) {
            TemplateKey key = new TemplateKey(this.sessionKey, observationDomainId, templateId);
            UdpSessionManager.this.options.computeIfAbsent(key, k -> new HashMap()).put(new HashSet(scopes), values);
        }

        @Override
        public Session.Resolver getResolver(long observationDomainId) {
            return new Resolver(observationDomainId);
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.sessionKey.getRemoteAddress();
        }

        @Override
        public boolean verifySequenceNumber(long observationDomainId, long sequenceNumber) {
            DomainKey key = new DomainKey(this.sessionKey, observationDomainId);
            SequenceNumberTracker tracker = UdpSessionManager.this.sequenceNumbers.computeIfAbsent(key, k -> (SequenceNumberTracker)UdpSessionManager.this.sequenceNumberTracker.get());
            return tracker.verify(sequenceNumber);
        }

        private final class Resolver
        implements Session.Resolver {
            private final long observationDomainId;

            private Resolver(long observationDomainId) {
                this.observationDomainId = observationDomainId;
            }

            private TemplateKey key(int templateId) {
                return new TemplateKey(UdpSession.this.sessionKey, this.observationDomainId, templateId);
            }

            @Override
            public Template lookupTemplate(int templateId) throws MissingTemplateException {
                TemplateWrapper templateWrapper = (TemplateWrapper)UdpSessionManager.this.templates.get(this.key(templateId));
                if (templateWrapper != null) {
                    return templateWrapper.template;
                }
                throw new MissingTemplateException(templateId);
            }

            @Override
            public List<Value<?>> lookupOptions(List<Value<?>> values) {
                LinkedHashMap<String, Value> options = new LinkedHashMap<String, Value>();
                Set scoped = values.stream().map(Value::getName).collect(Collectors.toSet());
                for (Map.Entry e2 : Iterables.filter(UdpSessionManager.this.options.entrySet(), e -> Objects.equals(((TemplateKey)e.getKey()).domain.sessionKey, UdpSession.this.sessionKey) && Objects.equals(((TemplateKey)e.getKey()).domain.observationDomainId, this.observationDomainId))) {
                    Template template = ((TemplateWrapper)((UdpSessionManager)UdpSessionManager.this).templates.get(e2.getKey())).template;
                    if (!scoped.containsAll(template.scopeNames)) continue;
                    Set scopeValues = values.stream().filter(s -> template.scopeNames.contains(s.getName())).collect(Collectors.toSet());
                    for (Value value : ((Map)e2.getValue()).getOrDefault(scopeValues, Collections.emptyList())) {
                        options.put(value.getName(), value);
                    }
                }
                return new ArrayList(options.values());
            }
        }
    }

    public static interface SessionKey {
        public InetAddress getRemoteAddress();
    }
}

