/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.OptionsTemplateRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.OptionsTemplateSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Record;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.TemplateSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Packet
implements Iterable<FlowSet<?>>,
RecordProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Packet.class);
    public final Header header;
    public final List<TemplateSet> templateSets;
    public final List<OptionsTemplateSet> optionTemplateSets;
    public final List<DataSet> dataSets;

    public Packet(Session session, Header header, ByteBuf buffer) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        LinkedList<TemplateSet> templateSets = new LinkedList<TemplateSet>();
        LinkedList<OptionsTemplateSet> optionTemplateSets = new LinkedList<OptionsTemplateSet>();
        LinkedList<DataSet> dataSets = new LinkedList<DataSet>();
        block7: while (buffer.isReadable()) {
            ByteBuf headerBuffer = BufferUtils.slice((ByteBuf)buffer, (int)4);
            FlowSetHeader setHeader = new FlowSetHeader(headerBuffer);
            ByteBuf payloadBuffer = BufferUtils.slice((ByteBuf)buffer, (int)(setHeader.length - 4));
            switch (setHeader.getType()) {
                case TEMPLATE_SET: {
                    TemplateSet templateSet = new TemplateSet(this, setHeader, payloadBuffer);
                    for (Record record : templateSet) {
                        if (record.header.fieldCount == 0) {
                            if (record.header.templateId == 2) {
                                session.removeAllTemplate(this.header.observationDomainId, Template.Type.TEMPLATE);
                                continue;
                            }
                            if (record.header.fieldCount != 0) continue;
                            session.removeTemplate(this.header.observationDomainId, record.header.templateId);
                            continue;
                        }
                        session.addTemplate(this.header.observationDomainId, Template.builder(record.header.templateId, Template.Type.TEMPLATE).withFields(record.fields).build());
                    }
                    templateSets.add(templateSet);
                    break;
                }
                case OPTIONS_TEMPLATE_SET: {
                    OptionsTemplateSet optionsTemplateSet = new OptionsTemplateSet(this, setHeader, payloadBuffer);
                    for (Record record : optionsTemplateSet) {
                        if (((OptionsTemplateRecord)record).header.fieldCount == 0) {
                            if (((OptionsTemplateRecord)record).header.templateId == 3) {
                                session.removeAllTemplate(this.header.observationDomainId, Template.Type.OPTIONS_TEMPLATE);
                                continue;
                            }
                            if (((OptionsTemplateRecord)record).header.fieldCount != 0) continue;
                            session.removeTemplate(this.header.observationDomainId, ((OptionsTemplateRecord)record).header.templateId);
                            continue;
                        }
                        session.addTemplate(this.header.observationDomainId, Template.builder(((OptionsTemplateRecord)record).header.templateId, Template.Type.OPTIONS_TEMPLATE).withScopes(((OptionsTemplateRecord)record).scopes).withFields(((OptionsTemplateRecord)record).fields).build());
                    }
                    optionTemplateSets.add(optionsTemplateSet);
                    break;
                }
                case DATA_SET: {
                    DataSet dataSet;
                    Session.Resolver resolver = session.getResolver(header.observationDomainId);
                    try {
                        dataSet = new DataSet(this, setHeader, resolver, payloadBuffer);
                    }
                    catch (MissingTemplateException ex) {
                        LOG.debug("Skipping data-set due to missing template: {}", (Object)ex.getMessage());
                        break;
                    }
                    if (dataSet.template.type == Template.Type.OPTIONS_TEMPLATE) {
                        for (DataRecord record : dataSet) {
                            session.addOptions(this.header.observationDomainId, dataSet.template.id, record.scopes, record.fields);
                        }
                        continue block7;
                    }
                    dataSets.add(dataSet);
                    break;
                }
                default: {
                    throw new InvalidPacketException(buffer, "Invalid Set ID: %d", setHeader.setId);
                }
            }
        }
        this.templateSets = Collections.unmodifiableList(templateSets);
        this.optionTemplateSets = Collections.unmodifiableList(optionTemplateSets);
        this.dataSets = Collections.unmodifiableList(dataSets);
    }

    @Override
    public Iterator<FlowSet<?>> iterator() {
        return Iterators.concat(this.templateSets.iterator(), this.optionTemplateSets.iterator(), this.dataSets.iterator());
    }

    @Override
    public Stream<Iterable<Value<?>>> getRecords() {
        int recordCount = this.dataSets.stream().mapToInt(s -> s.records.size()).sum();
        return this.dataSets.stream().flatMap(s -> s.records.stream()).map(r -> Iterables.concat((Iterable)ImmutableList.of((Object)new UnsignedValue("@recordCount", recordCount), (Object)new UnsignedValue("@sequenceNumber", this.header.sequenceNumber), (Object)new UnsignedValue("@exportTime", this.header.exportTime), (Object)new UnsignedValue("@observationDomainId", this.header.observationDomainId)), r.fields, r.options));
    }

    @Override
    public long getObservationDomainId() {
        return this.header.observationDomainId;
    }

    @Override
    public long getSequenceNumber() {
        return this.header.sequenceNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("templateSets", this.templateSets).add("optionTemplateSets", this.optionTemplateSets).add("dataTemplateSets", this.dataSets).toString();
    }
}

