/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import com.google.common.primitives.UnsignedLong;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Optional;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.IllegalFlowException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.Timeout;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Direction;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.NetflowVersion;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.SamplingAlgorithm;

public class IpFixMessageBuilder {
    private final FlowMessage.Builder builder;
    private final Iterable<Value<?>> values;
    private final RecordEnrichment enrichment;
    private Long exportTime;
    private Long octetDeltaCount;
    private Long postOctetDeltaCount;
    private Long layer2OctetDeltaCount;
    private Long postLayer2OctetDeltaCount;
    private Long transportOctetDeltaCount;
    private InetAddress destinationIPv6Address;
    private InetAddress destinationIPv4Address;
    private Long destinationIPv6PrefixLength;
    private Long destinationIPv4PrefixLength;
    private Instant flowStartSeconds;
    private Instant flowStartMilliseconds;
    private Instant flowStartMicroseconds;
    private Instant flowStartNanoseconds;
    private Long flowStartDeltaMicroseconds;
    private Long flowStartSysUpTime;
    private Instant systemInitTimeMilliseconds;
    private Instant flowEndSeconds;
    private Instant flowEndMilliseconds;
    private Instant flowEndMicroseconds;
    private Instant flowEndNanoseconds;
    private Long flowEndDeltaMicroseconds;
    private Long flowEndSysUpTime;
    private InetAddress ipNextHopIPv6Address;
    private InetAddress ipNextHopIPv4Address;
    private InetAddress bgpNextHopIPv6Address;
    private InetAddress bgpNextHopIPv4Address;
    private Long packetDeltaCount;
    private Long postPacketDeltaCount;
    private Long transportPacketDeltaCount;
    private Long samplingAlgorithm;
    private Long samplerMode;
    private Long selectorAlgorithm;
    private Long samplingInterval;
    private Long samplerRandomInterval;
    private Long samplingFlowInterval;
    private Long samplingFlowSpacing;
    private Long flowSamplingTimeInterval;
    private Long flowSamplingTimeSpacing;
    private Long samplingSize;
    private Long samplingPopulation;
    private Long samplingProbability;
    private Long hashSelectedRangeMin;
    private Long hashSelectedRangeMax;
    private Long hashOutputRangeMin;
    private Long hashOutputRangeMax;
    private InetAddress sourceIPv6Address;
    private InetAddress sourceIPv4Address;
    private Long sourceIPv6PrefixLength;
    private Long sourceIPv4PrefixLength;
    private Long vlanId;
    private Long postVlanId;
    private Long dot1qVlanId;
    private Long dot1qCustomerVlanId;
    private Long postDot1qVlanId;
    private Long postDot1qCustomerVlanId;
    private Long flowActiveTimeout;
    private Long flowInactiveTimeout;
    private Long numBytes;
    private Long numPackets;

    public IpFixMessageBuilder(Iterable<Value<?>> values, RecordEnrichment enrichment) {
        this.values = values;
        this.enrichment = enrichment;
        this.builder = FlowMessage.newBuilder();
    }

    public byte[] buildData() throws IllegalFlowException {
        Integer selectorAlgorithm;
        this.values.forEach(this::addField);
        MessageUtils.first(this.octetDeltaCount, this.postOctetDeltaCount, this.layer2OctetDeltaCount, this.postLayer2OctetDeltaCount, this.transportOctetDeltaCount).ifPresent(bytes -> {
            this.numBytes = bytes;
            this.builder.setNumBytes(MessageUtils.setLongValue(bytes));
        });
        MessageUtils.first(this.destinationIPv6Address, this.destinationIPv4Address).ifPresent(ipAddress -> {
            this.builder.setDstAddress(ipAddress.getHostAddress());
            this.enrichment.getHostnameFor((InetAddress)ipAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstHostname(arg_0));
        });
        MessageUtils.first(this.destinationIPv6PrefixLength, this.destinationIPv4PrefixLength).ifPresent(prefixLen -> this.builder.setDstMaskLen(MessageUtils.setIntValue(prefixLen.intValue())));
        MessageUtils.first(this.ipNextHopIPv6Address, this.ipNextHopIPv4Address, this.bgpNextHopIPv6Address, this.bgpNextHopIPv4Address).ifPresent(ipAddress -> {
            this.builder.setNextHopAddress(ipAddress.getHostAddress());
            this.enrichment.getHostnameFor((InetAddress)ipAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNextHopHostname(arg_0));
        });
        MessageUtils.first(this.sourceIPv6Address, this.sourceIPv4Address).ifPresent(ipAddress -> {
            this.builder.setSrcAddress(ipAddress.getHostAddress());
            this.enrichment.getHostnameFor((InetAddress)ipAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcHostname(arg_0));
        });
        MessageUtils.first(this.sourceIPv6PrefixLength, this.sourceIPv4PrefixLength).ifPresent(prefixLen -> this.builder.setSrcMaskLen(MessageUtils.setIntValue(prefixLen.intValue())));
        MessageUtils.first(this.vlanId, this.postVlanId, this.dot1qVlanId, this.dot1qCustomerVlanId, this.postDot1qVlanId, this.postDot1qCustomerVlanId).ifPresent(vlanId -> this.builder.setVlan(MessageUtils.setIntValue(vlanId.intValue())));
        long timeStamp = this.exportTime != null ? this.exportTime * 1000L : 0L;
        this.builder.setTimestamp(timeStamp);
        Long flowStartDeltaMicroseconds = this.flowStartDeltaMicroseconds != null ? Long.valueOf(this.flowStartDeltaMicroseconds + timeStamp) : null;
        Long systemInitTimeMilliseconds = this.systemInitTimeMilliseconds != null ? Long.valueOf(this.systemInitTimeMilliseconds.toEpochMilli()) : null;
        Long flowStartSysUpTime = this.flowStartSysUpTime != null && systemInitTimeMilliseconds != null ? Long.valueOf(this.flowStartSysUpTime + systemInitTimeMilliseconds) : null;
        Optional<Long> firstSwitchedInMilli = MessageUtils.first(this.flowStartSeconds, this.flowStartMilliseconds, this.flowStartMicroseconds, this.flowStartNanoseconds).map(Instant::toEpochMilli);
        if (firstSwitchedInMilli.isPresent()) {
            this.builder.setFirstSwitched(MessageUtils.setLongValue(firstSwitchedInMilli.get()));
        } else {
            MessageUtils.first(flowStartDeltaMicroseconds, flowStartSysUpTime).ifPresent(firstSwitched -> this.builder.setFirstSwitched(MessageUtils.setLongValue(firstSwitched)));
        }
        Long flowEndDeltaMicroseconds = this.flowEndDeltaMicroseconds != null ? Long.valueOf(this.flowEndDeltaMicroseconds + timeStamp) : null;
        Long flowEndSysUpTime = this.flowEndSysUpTime != null && systemInitTimeMilliseconds != null ? Long.valueOf(this.flowEndSysUpTime + systemInitTimeMilliseconds) : null;
        Optional<Long> lastSwitchedInMilli = MessageUtils.first(this.flowEndSeconds, this.flowEndMilliseconds, this.flowEndMicroseconds, this.flowEndNanoseconds).map(Instant::toEpochMilli);
        if (lastSwitchedInMilli.isPresent()) {
            this.builder.setLastSwitched(MessageUtils.setLongValue(lastSwitchedInMilli.get()));
        } else {
            MessageUtils.first(flowEndDeltaMicroseconds, flowEndSysUpTime).ifPresent(lastSwitchedValue -> this.builder.setLastSwitched(MessageUtils.setLongValue(lastSwitchedValue)));
        }
        MessageUtils.first(this.packetDeltaCount, this.postPacketDeltaCount, this.transportPacketDeltaCount).ifPresent(packets -> {
            this.builder.setNumPackets(MessageUtils.setLongValue(packets));
            this.numPackets = packets;
        });
        SamplingAlgorithm samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
        Integer deprecatedSamplingAlgorithm = MessageUtils.first(this.samplingAlgorithm, this.samplerMode).map(Long::intValue).orElse(null);
        if (deprecatedSamplingAlgorithm != null) {
            if (deprecatedSamplingAlgorithm == 1) {
                samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
            }
            if (deprecatedSamplingAlgorithm == 2) {
                samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
            }
        }
        Integer n = selectorAlgorithm = this.selectorAlgorithm != null ? Integer.valueOf(this.selectorAlgorithm.intValue()) : null;
        if (selectorAlgorithm != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
                    break;
                }
                case 1: {
                    samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
                    break;
                }
                case 2: {
                    samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_TIME_BASED_SAMPLING;
                    break;
                }
                case 3: {
                    samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
                    break;
                }
                case 4: {
                    samplingAlgorithm = SamplingAlgorithm.UNIFORM_PROBABILISTIC_SAMPLING;
                    break;
                }
                case 5: {
                    samplingAlgorithm = SamplingAlgorithm.PROPERTY_MATCH_FILTERING;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    samplingAlgorithm = SamplingAlgorithm.HASH_BASED_FILTERING;
                    break;
                }
                case 9: {
                    samplingAlgorithm = SamplingAlgorithm.FLOW_STATE_DEPENDENT_INTERMEDIATE_FLOW_SELECTION_PROCESS;
                }
            }
        }
        this.builder.setSamplingAlgorithm(samplingAlgorithm);
        Double deprecatedSamplingInterval = MessageUtils.first(this.samplingInterval, this.samplerRandomInterval).map(Long::doubleValue).orElse(null);
        if (deprecatedSamplingInterval != null) {
            this.builder.setSamplingInterval(MessageUtils.setDoubleValue(deprecatedSamplingInterval));
        } else if (selectorAlgorithm != null) {
            switch (selectorAlgorithm) {
                case 0: {
                    break;
                }
                case 1: {
                    Double samplingInterval = this.samplingFlowInterval != null ? this.samplingFlowInterval.doubleValue() : 1.0;
                    Double samplingSpacing = this.samplingFlowSpacing != null ? this.samplingFlowSpacing.doubleValue() : 0.0;
                    Double samplingIntervalValue = samplingInterval + samplingSpacing / samplingInterval;
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(samplingIntervalValue));
                    break;
                }
                case 2: {
                    Double flowSamplingTimeInterval = this.flowSamplingTimeInterval != null ? this.flowSamplingTimeInterval.doubleValue() : 1.0;
                    Double flowSamplingTimeSpacing = this.flowSamplingTimeSpacing != null ? this.flowSamplingTimeSpacing.doubleValue() : 0.0;
                    Double samplingIntervalValue = flowSamplingTimeInterval + flowSamplingTimeSpacing / flowSamplingTimeSpacing;
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(samplingIntervalValue));
                    break;
                }
                case 3: {
                    Double samplingSize = this.samplingSize != null ? this.samplingSize.doubleValue() : 1.0;
                    Double samplingPopulation = this.samplingPopulation != null ? this.samplingPopulation.doubleValue() : 1.0;
                    Double samplingIntervalValue = samplingPopulation / samplingSize;
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(samplingIntervalValue));
                    break;
                }
                case 4: {
                    Double samplingProbability = this.samplingProbability != null ? this.samplingProbability.doubleValue() : 1.0;
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(1.0 / samplingProbability));
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    UnsignedLong hashSelectedRangeMin = this.hashSelectedRangeMin != null ? UnsignedLong.fromLongBits((long)this.hashSelectedRangeMin) : UnsignedLong.ZERO;
                    UnsignedLong hashSelectedRangeMax = this.hashSelectedRangeMax != null ? UnsignedLong.fromLongBits((long)this.hashSelectedRangeMax) : UnsignedLong.MAX_VALUE;
                    UnsignedLong hashOutputRangeMin = this.hashOutputRangeMin != null ? UnsignedLong.fromLongBits((long)this.hashOutputRangeMin) : UnsignedLong.ZERO;
                    UnsignedLong hashOutputRangeMax = this.hashOutputRangeMax != null ? UnsignedLong.fromLongBits((long)this.hashOutputRangeMax) : UnsignedLong.MAX_VALUE;
                    Double samplingIntervalValue = hashOutputRangeMax.minus(hashOutputRangeMin).dividedBy(hashSelectedRangeMax.minus(hashSelectedRangeMin)).doubleValue();
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(samplingIntervalValue));
                    break;
                }
                default: {
                    this.builder.setSamplingInterval(MessageUtils.setDoubleValue(Double.NaN));
                    break;
                }
            }
        } else {
            this.builder.setSamplingInterval(MessageUtils.setDoubleValue(1.0));
        }
        if (this.builder.getFirstSwitched().getValue() > this.builder.getLastSwitched().getValue()) {
            throw new IllegalFlowException(String.format("lastSwitched must be greater than firstSwitched: srcAddress=%s, dstAddress=%s, firstSwitched=%d, lastSwitched=%d, duration=%d", this.builder.getSrcAddress(), this.builder.getDstAddress(), this.builder.getFirstSwitched().getValue(), this.builder.getLastSwitched().getValue(), this.builder.getLastSwitched().getValue() - this.builder.getFirstSwitched().getValue()));
        }
        Long firstSwitched2 = this.builder.hasFirstSwitched() ? Long.valueOf(this.builder.getFirstSwitched().getValue()) : null;
        Long lastSwitched = this.builder.hasLastSwitched() ? Long.valueOf(this.builder.getLastSwitched().getValue()) : null;
        Timeout timeout = new Timeout(this.flowActiveTimeout, this.flowInactiveTimeout);
        timeout.setFirstSwitched(firstSwitched2);
        timeout.setLastSwitched(lastSwitched);
        timeout.setNumBytes(this.numBytes);
        timeout.setNumPackets(this.numPackets);
        Long deltaSwitched = timeout.getDeltaSwitched();
        MessageUtils.getUInt64Value(deltaSwitched).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDeltaSwitched(arg_0));
        this.builder.setNetflowVersion(NetflowVersion.IPFIX);
        return this.builder.build().toByteArray();
    }

    private void addField(Value<?> value) {
        switch (value.getName()) {
            case "@exportTime": {
                this.exportTime = MessageUtils.getLongValue(value);
                break;
            }
            case "octetDeltaCount": {
                this.octetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "postOctetDeltaCount": {
                this.postOctetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "layer2OctetDeltaCount": {
                this.layer2OctetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "postLayer2OctetDeltaCount": {
                this.postLayer2OctetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "transportOctetDeltaCount": {
                this.transportOctetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "flowDirection": {
                Long directionValue = MessageUtils.getLongValue(value);
                Direction direction = Direction.UNRECOGNIZED;
                if (directionValue != null) {
                    switch (directionValue.intValue()) {
                        case 0: {
                            direction = Direction.INGRESS;
                            break;
                        }
                        case 1: {
                            direction = Direction.EGRESS;
                        }
                    }
                }
                if (direction.equals((Object)Direction.UNRECOGNIZED)) break;
                this.builder.setDirection(direction);
                break;
            }
            case "destinationIPv6Address": {
                this.destinationIPv6Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "destinationIPv4Address": {
                this.destinationIPv4Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "bgpDestinationAsNumber": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstAs(arg_0));
                break;
            }
            case "destinationIPv6PrefixLength": {
                this.destinationIPv6PrefixLength = MessageUtils.getLongValue(value);
                break;
            }
            case "destinationIPv4PrefixLength": {
                this.destinationIPv4PrefixLength = MessageUtils.getLongValue(value);
                break;
            }
            case "destinationTransportPort": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstPort(arg_0));
                break;
            }
            case "engineId": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineId(arg_0));
                break;
            }
            case "engineType": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineType(arg_0));
                break;
            }
            case "@recordCount": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNumFlowRecords(arg_0));
                break;
            }
            case "@sequenceNumber": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setFlowSeqNum(arg_0));
                break;
            }
            case "ingressInterface": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setInputSnmpIfindex(arg_0));
                break;
            }
            case "ipVersion": {
                Long ipVersion = MessageUtils.getLongValue(value);
                if (ipVersion == null) break;
                this.builder.setIpProtocolVersion(MessageUtils.setIntValue(ipVersion.intValue()));
                break;
            }
            case "egressInterface": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setOutputSnmpIfindex(arg_0));
                break;
            }
            case "protocolIdentifier": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setProtocol(arg_0));
                break;
            }
            case "tcpControlBits": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTcpFlags(arg_0));
                break;
            }
            case "ipClassOfService": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTos(arg_0));
                break;
            }
            case "@observationDomainId": {
                Long observationDomainId = MessageUtils.getLongValue(value);
                if (observationDomainId == null) break;
                this.builder.setNodeIdentifier(String.valueOf(observationDomainId));
                break;
            }
            case "flowStartSeconds": {
                this.flowStartSeconds = MessageUtils.getTime(value);
                break;
            }
            case "flowStartMilliseconds": {
                this.flowStartMilliseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowStartMicroseconds": {
                this.flowStartMicroseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowStartNanoseconds": {
                this.flowStartNanoseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowStartDeltaMicroseconds": {
                this.flowStartDeltaMicroseconds = MessageUtils.getLongValue(value);
                break;
            }
            case "flowStartSysUpTime": {
                this.flowStartSysUpTime = MessageUtils.getLongValue(value);
                break;
            }
            case "systemInitTimeMilliseconds": {
                this.systemInitTimeMilliseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowEndSeconds": {
                this.flowEndSeconds = MessageUtils.getTime(value);
                break;
            }
            case "flowEndMilliseconds": {
                this.flowEndMilliseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowEndMicroseconds": {
                this.flowEndMicroseconds = MessageUtils.getTime(value);
                break;
            }
            case "flowEndNanoseconds": {
                this.flowEndNanoseconds = MessageUtils.getTime(value);
            }
            case "flowEndDeltaMicroseconds": {
                this.flowEndDeltaMicroseconds = MessageUtils.getLongValue(value);
                break;
            }
            case "flowEndSysUpTime": {
                this.flowEndSysUpTime = MessageUtils.getLongValue(value);
                break;
            }
            case "ipNextHopIPv6Address": {
                this.ipNextHopIPv6Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "ipNextHopIPv4Address": {
                this.ipNextHopIPv4Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "bgpNextHopIPv6Address": {
                this.bgpNextHopIPv6Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "bgpNextHopIPv4Address": {
                this.bgpNextHopIPv4Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "packetDeltaCount": {
                this.packetDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "postPacketDeltaCount": {
                this.postPacketDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "transportPacketDeltaCount": {
                this.transportPacketDeltaCount = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingAlgorithm": {
                this.samplingAlgorithm = MessageUtils.getLongValue(value);
                break;
            }
            case "samplerMode": {
                this.samplerMode = MessageUtils.getLongValue(value);
                break;
            }
            case "selectorAlgorithm": {
                this.selectorAlgorithm = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingInterval": {
                this.samplingInterval = MessageUtils.getLongValue(value);
                break;
            }
            case "samplerRandomInterval": {
                this.samplerRandomInterval = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingFlowInterval": {
                this.samplingFlowInterval = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingFlowSpacing": {
                this.samplingFlowSpacing = MessageUtils.getLongValue(value);
                break;
            }
            case "flowSamplingTimeInterval": {
                this.flowSamplingTimeInterval = MessageUtils.getLongValue(value);
                break;
            }
            case "flowSamplingTimeSpacing": {
                this.flowSamplingTimeSpacing = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingSize": {
                this.samplingSize = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingPopulation": {
                this.samplingPopulation = MessageUtils.getLongValue(value);
                break;
            }
            case "samplingProbability": {
                this.samplingProbability = MessageUtils.getLongValue(value);
                break;
            }
            case "hashSelectedRangeMin": {
                this.hashSelectedRangeMin = MessageUtils.getLongValue(value);
                break;
            }
            case "hashSelectedRangeMax": {
                this.hashSelectedRangeMax = MessageUtils.getLongValue(value);
                break;
            }
            case "hashOutputRangeMin": {
                this.hashOutputRangeMin = MessageUtils.getLongValue(value);
                break;
            }
            case "hashOutputRangeMax": {
                this.hashOutputRangeMax = MessageUtils.getLongValue(value);
                break;
            }
            case "sourceIPv6Address": {
                this.sourceIPv6Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "sourceIPv4Address": {
                this.sourceIPv4Address = MessageUtils.getInetAddress(value);
                break;
            }
            case "sourceIPv6PrefixLength": {
                this.sourceIPv6PrefixLength = MessageUtils.getLongValue(value);
                break;
            }
            case "sourceIPv4PrefixLength": {
                this.sourceIPv4PrefixLength = MessageUtils.getLongValue(value);
                break;
            }
            case "sourceTransportPort": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcPort(arg_0));
                break;
            }
            case "vlanId": {
                this.vlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "postVlanId": {
                this.postVlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "dot1qVlanId": {
                this.dot1qVlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "dot1qCustomerVlanId": {
                this.dot1qCustomerVlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "postDot1qVlanId": {
                this.postDot1qVlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "postDot1qCustomerVlanId": {
                this.postDot1qCustomerVlanId = MessageUtils.getLongValue(value);
                break;
            }
            case "flowActiveTimeout": {
                this.flowActiveTimeout = MessageUtils.getLongValue(value);
                break;
            }
            case "flowInactiveTimeout": {
                this.flowInactiveTimeout = MessageUtils.getLongValue(value);
            }
        }
    }
}

