/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.Dispatchable;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.IllegalFlowException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ParserBase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto.Header;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow5.proto.Packet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.Netflow5MessageBuilder;

public class Netflow5UdpParser
extends ParserBase
implements UdpParser,
Dispatchable {
    public Netflow5UdpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        super(Protocol.NETFLOW5, name, dispatcher, eventForwarder, identity, dnsResolver, metricRegistry);
    }

    public boolean handles(ByteBuf buffer) {
        return BufferUtils.uint16((ByteBuf)buffer) == 5;
    }

    public CompletableFuture<?> parse(ByteBuf buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        Header header = new Header(BufferUtils.slice((ByteBuf)buffer, (int)24));
        Packet packet = new Packet(header, buffer);
        this.detectClockSkew(header.unixSecs * 1000L + header.unixNSecs / 1000L, remoteAddress.getAddress());
        return this.transmit(packet, remoteAddress);
    }

    @Override
    protected byte[] buildMessage(Iterable<Value<?>> record, RecordEnrichment enrichment) throws IllegalFlowException {
        Netflow5MessageBuilder builder = new Netflow5MessageBuilder(record, enrichment);
        return builder.buildData();
    }
}

